/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.framework.ui.internal.MigrationFrameworkBaseWizardPage;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;

public class MigrationFrameworkResourcesWizardPage
extends MigrationFrameworkBaseWizardPage
implements IMigrationFrameworkDataModelProperties {
    ListViewer resourcesViewer;
    private Clipboard clipboard;
    private Action copyAction;
    private Action selectAllAction;

    protected MigrationFrameworkResourcesWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(MigrationMessages.MigrationFrameworkResourcesWizardPage_title);
        this.setDescription(MigrationMessages.MigrationFrameworkResourcesWizardPage_description);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.commonGridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        composite.setBackground(parent.getBackground());
        this.createHeaderArea(composite, MigrationMessages.MigrationFrameworkResourcesWizardPage_panel_title);
        this.createMessageArea(composite, MigrationMessages.MigrationFrameworkResourcesWizardPage_text);
        this.createResourcesGroup(composite);
        this.createClipboard();
        this.createContextMenu();
        return composite;
    }

    protected void createResourcesGroup(Composite parent) {
        Composite viewerContainer = new Composite(parent, 2048);
        viewerContainer.setLayout((Layout)new GridLayout());
        GridData containerGD = new GridData(1808);
        viewerContainer.setLayoutData((Object)containerGD);
        viewerContainer.setBackground(this.white);
        this.resourcesViewer = new ListViewer(viewerContainer, 770);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        this.resourcesViewer.getList().setLayoutData((Object)gData);
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.resourcesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resourcesViewer.setComparator(this.createComparator());
        this.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getPropertyName().equals("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES")) {
                    Set resourcesToChange = (Set)MigrationFrameworkResourcesWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES");
                    MigrationFrameworkResourcesWizardPage.this.resourcesViewer.setInput((Object)resourcesToChange);
                }
            }
        });
    }

    private void createClipboard() {
        this.clipboard = new Clipboard(Display.getCurrent());
        this.copyAction = new Action(MigrationMessages.MigrationValidationResultsView_copy){

            public void run() {
                String[] selected = MigrationFrameworkResourcesWizardPage.this.resourcesViewer.getList().getSelection();
                if (selected.length == 0) {
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < selected.length - 1; ++i) {
                    buffer.append(selected[i]);
                    buffer.append(System.getProperty("line.separator"));
                }
                buffer.append(selected[selected.length - 1]);
                Object[] data = new Object[]{buffer.toString()};
                Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
                MigrationFrameworkResourcesWizardPage.this.clipboard.setContents(data, transferTypes);
            }
        };
        this.selectAllAction = new Action(MigrationMessages.MigrationValidationResultsView_select_all){

            public void run() {
                MigrationFrameworkResourcesWizardPage.this.resourcesViewer.getList().selectAll();
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int selectedCount = MigrationFrameworkResourcesWizardPage.this.resourcesViewer.getList().getSelectionCount();
                MigrationFrameworkResourcesWizardPage.this.copyAction.setEnabled(selectedCount > 0);
                MigrationFrameworkResourcesWizardPage.this.selectAllAction.setEnabled(selectedCount < MigrationFrameworkResourcesWizardPage.this.resourcesViewer.getList().getItemCount());
                manager.add((IAction)MigrationFrameworkResourcesWizardPage.this.copyAction);
                manager.add((IAction)MigrationFrameworkResourcesWizardPage.this.selectAllAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.resourcesViewer.getControl());
        this.resourcesViewer.getControl().setMenu(menu);
    }

    public void performHelp() {
        String helpId = "/com.ibm.etools.rad.migration.doc/topics/c_migrationoverview.html";
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
    }

    public void dispose() {
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    public void enter() {
        super.enter();
        Set resourcesToChange = (Set)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES");
        if (!resourcesToChange.isEmpty()) {
            this.resourcesViewer.setInput((Object)resourcesToChange);
        }
    }

    private LabelProvider createLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    if (resource.getLocation() != null) {
                        return resource.getLocation().toString();
                    }
                    if (resource.getFullPath() != null) {
                        return resource.getFullPath().toString();
                    }
                }
                return element == null ? "" : element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        };
    }

    private ViewerComparator createComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IResource && e2 instanceof IResource) {
                    IResource r1 = (IResource)e1;
                    IResource r2 = (IResource)e2;
                    if (r1.getLocation() != null && r2.getLocation() != null) {
                        return r1.getLocation().toString().compareTo(r2.getLocation().toString());
                    }
                    if (r1.getFullPath() != null && r2.getFullPath() != null) {
                        return r1.getFullPath().toString().compareTo(r2.getFullPath().toString());
                    }
                }
                return e1.toString().compareTo(e2.toString());
            }
        };
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }
}

