/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationProjectReferenceUtil;
import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.framework.ui.internal.MigrationFrameworkBaseWizardPage;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MigrationFrameworkProjectsWizardPage
extends MigrationFrameworkBaseWizardPage
implements IMigrationFrameworkDataModelProperties {
    private static final String DEFAULT_MIGRATION_LOG_FILENAME = "migration.log";
    private boolean firstVisit = true;
    private CheckboxTableViewer projectsViewer;
    private Combo destinationField;
    private static final boolean BUILD_DESTINATION = false;

    protected MigrationFrameworkProjectsWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(MigrationMessages.MigrationFrameworkWizard_title);
        this.setDescription(MigrationMessages.MigrationFrameworkStartupWizardPage_text);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)this.commonGridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        composite.setBackground(parent.getBackground());
        this.createHeaderArea(composite, MigrationMessages.MigrationFrameworkProjectsWizardPage_title);
        this.createMessageArea(composite, MigrationMessages.MigrationFrameworkProjectsWizardPage_description);
        this.createProjectsGroup(composite);
        this.createButtonsGroup(composite);
        return composite;
    }

    protected void createProjectsGroup(Composite parent) {
        Composite viewerContainer = new Composite(parent, 2048);
        viewerContainer.setLayout((Layout)new GridLayout());
        GridData containerGD = new GridData(1808);
        viewerContainer.setLayoutData((Object)containerGD);
        viewerContainer.setBackground(this.white);
        this.projectsViewer = CheckboxTableViewer.newCheckList((Composite)viewerContainer, (int)768);
        GridData gData = new GridData(1808);
        gData.widthHint = 200;
        gData.heightHint = 80;
        gData.horizontalIndent = 10;
        gData.verticalIndent = 10;
        this.projectsViewer.getControl().setLayoutData((Object)gData);
        this.projectsViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() == null) {
                    return;
                }
                MigrationFrameworkProjectsWizardPage.this.projectsCheckedChanged();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.projectsViewer.getTable().setLayout((Layout)tableLayout);
        this.projectsViewer.getTable().setHeaderVisible(false);
        this.projectsViewer.getTable().setLinesVisible(false);
    }

    private void createDestinationGroup(Composite parent) {
        Composite destinationGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationGroup.setLayout((Layout)layout);
        destinationGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(destinationGroup, 0);
        label.setText(MigrationMessages.MigrationFrameworkWizardPage_logLocation);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.destinationField = new Combo(destinationGroup, 4);
        data = new GridData(768);
        data.widthHint = 250;
        this.destinationField.setLayoutData((Object)data);
        Button browseButton = new Button(destinationGroup, 8);
        browseButton.setText(MigrationMessages.MigrationFrameworkProjectsWizardPage_browse);
        browseButton.setLayoutData((Object)new GridData(128));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationFrameworkProjectsWizardPage.this.browse();
            }
        });
        StringBuffer buffer = new StringBuffer();
        buffer.append(ResourcesPlugin.getWorkspace().getRoot().getLocation());
        buffer.append(File.separatorChar);
        buffer.append(DEFAULT_MIGRATION_LOG_FILENAME);
        String defaultLocation = buffer.toString();
        this.destinationField.setText(defaultLocation);
    }

    protected void createButtonsGroup(Composite parent) {
        Composite buttonGroup = this.getWf().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        buttonGroup.setLayout((Layout)layout);
        buttonGroup.setLayoutData((Object)this.commonGridData());
        buttonGroup.setBackground(parent.getBackground());
        GridData gd = new GridData(272);
        Button selectAllButton = this.getWf().createButton(buttonGroup, MigrationMessages.MigrationFrameworkProjectsWizardPage_selectAll, 8);
        gd = new GridData(272);
        selectAllButton.setLayoutData((Object)gd);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationFrameworkProjectsWizardPage.this.selectAll();
            }
        });
        Button deselectAllButton = this.getWf().createButton(buttonGroup, MigrationMessages.MigrationFrameworkProjectsWizardPage_deselectAll, 8);
        gd = new GridData(272);
        deselectAllButton.setLayoutData((Object)gd);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationFrameworkProjectsWizardPage.this.deselectAll();
            }
        });
        Button selectReferencedlButton = this.getWf().createButton(buttonGroup, MigrationMessages.MigrationFrameworkProjectsWizardPage_selectReferenced, 8);
        gd = new GridData(272);
        selectReferencedlButton.setLayoutData((Object)gd);
        selectReferencedlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MigrationFrameworkProjectsWizardPage.this.selectReferenced();
            }
        });
    }

    public void performHelp() {
        String helpId = "/com.ibm.etools.rad.migration.doc/topics/c_migrationoverview.html";
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
    }

    public void enter() {
        super.enter();
        if (this.firstVisit) {
            this.getProjectsToMigrate();
            this.firstVisit = false;
        }
    }

    public void exit() {
        super.exit();
    }

    private void getProjectsToMigrate() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                List potentialProjects = (List)MigrationFrameworkProjectsWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS");
                List projectsToMigrate = WorkspaceMigrationEngine.instance().getProjectsToMigrate(potentialProjects, monitor);
                monitor.done();
                MigrationFrameworkProjectsWizardPage.this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS", (Object)projectsToMigrate);
                Set needsMigration = WorkspaceMigrationEngine.instance().getNonMigratedProjects();
                needsMigration.addAll(projectsToMigrate);
                MigrationFrameworkProjectsWizardPage.this.projectsViewer.setInput(MigrationFrameworkProjectsWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS"));
                MigrationFrameworkProjectsWizardPage.this.selectAll();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
            progress.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            MigrationPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            MigrationPlugin.logError((Throwable)e);
        }
    }

    private void getChangingResources() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                List selectedProjects = (List)MigrationFrameworkProjectsWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS");
                WorkspaceMigrationEngine.instance().getResourcesToChange(selectedProjects, monitor);
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            MigrationPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            MigrationPlugin.logError((Throwable)e);
        }
    }

    private void browse() {
        int separator;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*.log"});
        dialog.setText(MigrationMessages.MigrationFrameworkWizardPage_logLocation);
        String filePath = this.destinationField.getText();
        if (filePath != null && (separator = filePath.lastIndexOf(File.separator)) != -1) {
            filePath = filePath.substring(0, separator);
        }
        dialog.setFilterPath(filePath);
        dialog.setFileName(DEFAULT_MIGRATION_LOG_FILENAME);
        String selectedFileName = dialog.open();
        if (selectedFileName != null) {
            this.destinationField.setText(selectedFileName);
        }
    }

    private void projectsCheckedChanged() {
        List selectedProjects = this.getSelectedProjects();
        this.model.setProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS", (Object)selectedProjects);
        MigrationProjectReferenceUtil refUtil = new MigrationProjectReferenceUtil(this.getSelectedProjects());
        List referenced = refUtil.getReferencedProjects();
        this.validateReferencedProjects(referenced);
        this.getChangingResources();
    }

    private void selectAll() {
        List allProjects = (List)this.projectsViewer.getInput();
        if (allProjects.size() == this.projectsViewer.getCheckedElements().length) {
            return;
        }
        this.model.setProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS", (Object)allProjects);
        this.projectsViewer.setAllChecked(true);
        MigrationProjectReferenceUtil refUtil = new MigrationProjectReferenceUtil(allProjects);
        List referenced = refUtil.getReferencedProjects();
        this.validateReferencedProjects(referenced);
        this.getChangingResources();
    }

    private void deselectAll() {
        if (this.projectsViewer.getCheckedElements().length == 0) {
            return;
        }
        this.projectsViewer.setAllChecked(false);
        ArrayList selectedProjects = new ArrayList();
        this.model.setProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS", selectedProjects);
        this.getChangingResources();
    }

    private void selectReferenced() {
        MigrationProjectReferenceUtil refUtil = new MigrationProjectReferenceUtil(this.getSelectedProjects());
        List referenced = refUtil.getReferencedProjects();
        List allProjects = (List)this.projectsViewer.getInput();
        for (int i = 0; i < referenced.size(); ++i) {
            IProject project = (IProject)referenced.get(i);
            if (!allProjects.contains(project)) continue;
            this.projectsViewer.setChecked((Object)project, true);
        }
        List selectedProjects = this.getSelectedProjects();
        this.model.setProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS", (Object)selectedProjects);
        this.validateReferencedProjects(referenced);
        this.getChangingResources();
    }

    private void validateReferencedProjects(List<IProject> referencedProjects) {
        ArrayList<Status> statusRefs = new ArrayList<Status>();
        ArrayList<Status> statusUnavails = new ArrayList<Status>();
        IStatus status = Status.OK_STATUS;
        IProject[] workspaceProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        List migrationProjects = (List)this.projectsViewer.getInput();
        List<IProject> availableProjects = Arrays.asList(workspaceProjects);
        List selectedProjects = this.getSelectedProjects();
        for (int i = 0; i < referencedProjects.size(); ++i) {
            String message;
            IProject project = referencedProjects.get(i);
            if (selectedProjects.contains(project)) continue;
            if (migrationProjects.contains(project)) {
                message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkProjectsWizardPage_unselectedRef, (Object)project.getName());
                statusRefs.add(new Status(2, "com.ibm.etools.common.migration", message));
                continue;
            }
            if (availableProjects.contains(project)) continue;
            message = MigrationMessages.bind((String)MigrationMessages.MigrationFrameworkProjectsWizardPage_unavailableRef, (Object)project.getName());
            statusUnavails.add(new Status(2, "com.ibm.etools.common.migration", message));
        }
        if (!statusRefs.isEmpty()) {
            Status[] statusArray = statusRefs.toArray(new Status[statusRefs.size()]);
            status = new MultiStatus("com.ibm.etools.common.migration", 0, (IStatus[])statusArray, MigrationMessages.MigrationFrameworkProjectsWizardPage_unselectedRef, null);
        }
        if (!statusUnavails.isEmpty()) {
            Status[] statusArray = statusUnavails.toArray(new Status[statusUnavails.size()]);
            if (status.isMultiStatus()) {
                ((MultiStatus)status).merge((IStatus)new MultiStatus("com.ibm.etools.common.migration", 0, (IStatus[])statusArray, MigrationMessages.MigrationFrameworkProjectsWizardPage_unavailableRef, null));
            } else {
                status = new MultiStatus("com.ibm.etools.common.migration", 0, (IStatus[])statusArray, MigrationMessages.MigrationFrameworkProjectsWizardPage_unavailableRef, null);
            }
        }
        this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS", (Object)status);
    }

    private List getSelectedProjects() {
        Object[] checked = this.projectsViewer.getCheckedElements();
        if (checked != null) {
            return Arrays.asList(checked);
        }
        return Collections.EMPTY_LIST;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IMigrationFrameworkDataModelProperties.MIGRATION_PROJECTS", "IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS", "IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS"};
    }
}

