/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.AbstractMigrationHandler;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationFrameworkWizard;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.ui.ListLegacyProjectsDialog;
import com.ibm.etools.common.internal.migration.ui.MigrationValidationResultsView;
import com.ibm.etools.common.internal.migration.ui.plugin.MigrationUIPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class MigrationFrameworkHandler
extends AbstractMigrationHandler
implements Runnable {
    public static final String MIGRATION_RESULTS_VIEWER = "com.ibm.etools.common.migration.view.MigrationValidationResultsView";
    public static final String ALLOW_MIGRATION_WIZARD_AUTOMATION_PROPERTY = "com.ibm.etools.common.migration.ui.MigrationWizard";
    public static final String ALLOW_AUTOMATION_PROPERTY_VALUE = "allowAutomation";
    private static final String ALLOW_AUTOMATION_DEFUALT_VALUE = "";
    private static final String AUTOMATED_MIGRATION = System.getProperty("com.ibm.etools.common.migration.ui.MigrationWizard", "");
    private static final boolean WTP_AUTO_TEST = Boolean.getBoolean("wtp.autotest.noninteractive");
    private static final String SUPRESS_POP_UPS = System.getProperty("suppress_pop_ups", "");
    IDataModel model;

    public void handleMigration(IDataModel dataModel) {
        if (!AUTOMATED_MIGRATION.equals(ALLOW_AUTOMATION_PROPERTY_VALUE) && (ErrorDialog.AUTOMATED_MODE || WTP_AUTO_TEST || "1".equals(SUPRESS_POP_UPS))) {
            return;
        }
        this.model = dataModel;
        Display display = Display.getDefault();
        display.syncExec((Runnable)this);
    }

    @Override
    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        Shell shell = window.getShell();
        if (this.model != null) {
            IViewPart view = this.openMigrationResultsView(page);
            MigrationFrameworkWizard wizard = new MigrationFrameworkWizard(this.model);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.getShell().setSize(570, 600);
            int status = dialog.open();
            if (status == 0 && view != null) {
                this.displayMigrationResults(view, shell, page);
            }
        } else {
            MessageDialog.openInformation((Shell)shell, (String)MigrationMessages.MigrationFrameworkWizard_title, (String)MigrationMessages.MigrationResultsView_no_migration_needed_msg);
        }
    }

    protected void longRunningOperationComplete() {
        if (Display.getCurrent() != null) {
            Display.getCurrent().readAndDispatch();
        }
    }

    private void displayMigrationResults(IViewPart view, Shell shell, IWorkbenchPage page) {
        IStatus status = (IStatus)this.model.getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_VALIDATION_STATUS");
        ArrayList legacyProjects = (ArrayList)this.model.getProperty("IMigrationFrameworkDataModelProperties.LEGACY_PROJECTS");
        page.activate((IWorkbenchPart)view);
        ((MigrationValidationResultsView)view).showResults();
        if (legacyProjects.isEmpty()) {
            this.openValidationDialog(status, shell);
        } else {
            this.openLegacyProjectsDialog(shell, legacyProjects);
        }
    }

    private void openLegacyProjectsDialog(Shell shell, ArrayList<IProject> legacyProjects) {
        ListLegacyProjectsDialog dialog = new ListLegacyProjectsDialog(shell, MigrationMessages.MigrationFrameworkHandler_projects_dialog_title, MigrationMessages.MigrationFrameworkHandler_unsupported_msg, legacyProjects.toArray(new IProject[legacyProjects.size()]));
        dialog.open();
    }

    private void openValidationDialog(IStatus status, Shell shell) {
        switch (status.getSeverity()) {
            case 4: {
                MessageDialog.openError((Shell)shell, (String)MigrationMessages.MigrationFrameworkHandler_message_dialog_title, (String)MigrationMessages.MigrationFrameworkHandler_errors_found);
                break;
            }
            case 2: {
                MessageDialog.openWarning((Shell)shell, (String)MigrationMessages.MigrationFrameworkHandler_message_dialog_title, (String)MigrationMessages.MigrationFrameworkHandler_warnings_found);
                break;
            }
            default: {
                MessageDialog.openInformation((Shell)shell, (String)MigrationMessages.MigrationFrameworkHandler_message_dialog_title, (String)MigrationMessages.MigrationFrameworkHandler_completed_successfully);
            }
        }
    }

    private IViewPart openMigrationResultsView(IWorkbenchPage page) {
        IViewPart view = null;
        if (page != null) {
            try {
                view = page.showView(MIGRATION_RESULTS_VIEWER, null, 3);
                if (view != null) {
                    this.model.setProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESULTS_VIEW_LISTENER", (Object)view);
                }
            }
            catch (PartInitException e) {
                MigrationUIPlugin.logError((CoreException)e);
            }
        }
        return view;
    }
}

