/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.internal.migration.framework.ui;

import com.ibm.etools.common.internal.migration.framework.IMigrationFrameworkDataModelProperties;
import com.ibm.etools.common.internal.migration.framework.MigrationLog;
import com.ibm.etools.common.internal.migration.framework.WorkspaceMigrationEngine;
import com.ibm.etools.common.internal.migration.framework.ui.MigrationMessages;
import com.ibm.etools.common.internal.migration.plugin.MigrationPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class MigrationFrameworkFinishWizardPage
extends DataModelWizardPage
implements IMigrationFrameworkDataModelProperties {
    Label finished;
    TableViewer messagesViewer;

    protected MigrationFrameworkFinishWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(MigrationMessages.MigrationFrameworkFinishWizardPage_title);
        this.setDescription(MigrationMessages.MigrationFrameworkFinishWizardPage_description);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1536));
        this.createFinishingRemarks(composite);
        this.createMessagesGroup(composite);
        return composite;
    }

    private void createFinishingRemarks(Composite composite) {
        Composite info = new Composite(composite, 0);
        info.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        info.setLayout((Layout)layout);
        this.finished = new Label(info, 64);
        GridData data = new GridData(768);
        data.widthHint = 500;
        this.finished.setLayoutData((Object)data);
    }

    protected void createMessagesGroup(Composite parent) {
        this.messagesViewer = new TableViewer(parent, 2816);
        this.messagesViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.messagesViewer.setLabelProvider((IBaseLabelProvider)this.createMessagesLabelProvider());
        this.messagesViewer.setContentProvider((IContentProvider)this.createMessagesContentProvider());
    }

    public void performHelp() {
        String helpId = "/com.ibm.etools.rad.migration.doc/topics/c_migrationoverview.html";
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(helpId);
    }

    public void enter() {
        super.enter();
        this.checkoutResources();
        IStatus selectionStatus = (IStatus)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.SELECTED_MIGRATION_PROJECTS_STATUS");
        IStatus checkoutStatus = (IStatus)this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS");
        if (selectionStatus.getSeverity() == 0 && checkoutStatus.getSeverity() == 0) {
            this.finished.setText(MigrationMessages.MigrationFrameworkFinishWizardPage_finishText);
            this.messagesViewer.getControl().setVisible(false);
        } else {
            MultiStatus inputStatus = new MultiStatus("com.ibm.etools.common.migration", 0, MigrationMessages.MigrationFrameworkFinishWizardPage_title, null);
            if (selectionStatus.getSeverity() != 0) {
                this.finished.setText(MigrationMessages.MigrationFrameworkFinishWizardPage_reviewWarnings);
                inputStatus.merge(selectionStatus);
            }
            if (checkoutStatus.getSeverity() != 0) {
                this.finished.setText(MigrationMessages.MigrationFrameworkFinishWizardPage_reviewErrors);
                inputStatus.merge(checkoutStatus);
            }
            this.messagesViewer.setInput((Object)inputStatus);
            this.messagesViewer.getControl().setVisible(true);
            MigrationLog.getInstance().logStatus((IStatus)inputStatus, true);
        }
    }

    private IStructuredContentProvider createMessagesContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof MultiStatus) {
                    return ((MultiStatus)inputElement).getChildren();
                }
                if (inputElement instanceof Status) {
                    return new Status[]{(Status)inputElement};
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    private LabelProvider createMessagesLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                Image image = null;
                if (element instanceof IStatus) {
                    switch (((IStatus)element).getSeverity()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                            break;
                        }
                        case 2: {
                            image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                            break;
                        }
                        case 4: {
                            image = JFaceResources.getImage((String)"dialog_message_error_image");
                        }
                    }
                }
                return image;
            }

            public String getText(Object element) {
                if (element instanceof IStatus) {
                    return ((IStatus)element).getMessage();
                }
                return element == null ? "" : element.toString();
            }
        };
    }

    private void checkoutResources() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                Set resourcesToChange = (Set)MigrationFrameworkFinishWizardPage.this.getDataModel().getProperty("IMigrationFrameworkDataModelProperties.MIGRATION_RESOURCES");
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToChange.size());
                progress.setTaskName(MigrationMessages.MigrationFrameworkFinishWizardPage_attemptCheckout);
                IStatus status = WorkspaceMigrationEngine.instance().checkoutResources(resourcesToChange, (Object)MigrationFrameworkFinishWizardPage.this.getShell(), (IProgressMonitor)progress);
                ArrayList statusList = new ArrayList();
                MigrationFrameworkFinishWizardPage.this.createStatusChildren(status, statusList);
                MultiStatus statusWrapper = new MultiStatus("com.ibm.etools.common.migration", 0, statusList.toArray(new IStatus[statusList.size()]), status.getMessage(), null);
                MigrationFrameworkFinishWizardPage.this.getDataModel().setProperty("IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS", (Object)statusWrapper);
                progress.done();
            }
        };
        try {
            this.getContainer().run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            MigrationPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            MigrationPlugin.logError((Throwable)e);
        }
    }

    private void createStatusChildren(IStatus status, List<IStatus> statusList) {
        if (!status.isMultiStatus()) {
            if (!status.isOK()) {
                statusList.add(status);
            }
            return;
        }
        IStatus[] statuses = ((MultiStatus)status).getChildren();
        for (int i = 0; i < statuses.length; ++i) {
            this.createStatusChildren(statuses[i], statusList);
        }
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"IMigrationFrameworkDataModelProperties.RESOURCE_CHECKOUT_STATUS"};
    }
}

