/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.propertytester;

import com.ibm.etools.common.migration.extension.ui.internal.MigrationPlugin;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationProjectProperties;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class TargetedRuntimePropertyTester
extends PropertyTester {
    protected static final String RUNTIME_TYPE_ID = "com.ibm.etools.websphere.runtime";
    public static final String NEW_RUNTIME_TYPE_ID = "com.ibm.ws.ast.st.runtime";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IProject) {
            IFacetedProject facetedProject;
            IProject project = (IProject)receiver;
            MigrationProjectProperties migrationProps = new MigrationProjectProperties(project);
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) {
                    if (Logger.INFO) {
                        Logger.println("/debug/info", ((Object)((Object)this)).getClass(), "test", "{tp10} Unable to create faceted project from IProject=" + String.valueOf(receiver));
                    }
                    return false;
                }
            }
            catch (CoreException ce) {
                if (Logger.INFO) {
                    Logger.println("/debug/info", ((Object)((Object)this)).getClass(), "test", "{tp20} Unable to create faceted project from IProject=" + String.valueOf(receiver), (Throwable)ce);
                }
                return false;
            }
            String exVal = (String)expectedValue;
            IRuntime facetedRuntime = facetedProject.getPrimaryRuntime();
            if (Logger.INFO) {
                Logger.println("/debug/info", (Object)this, "test()", "project=" + facetedProject.getProject().getName() + " using IRuntime=" + String.valueOf(facetedRuntime));
            }
            if (exVal == null || exVal.equalsIgnoreCase("null")) {
                if (Logger.INFO) {
                    Logger.println("/debug/info", (Object)this, "test()", "looking for project with invalid Targeted Runtime.");
                }
                org.eclipse.wst.server.core.IRuntime runtime = null;
                if (facetedRuntime != null && TargetedRuntimePropertyTester.isWASRuntime(runtime = FacetUtil.getRuntime((IRuntime)facetedRuntime))) {
                    boolean projectContainsRuntimeClasspath;
                    boolean isOSGiAppOrBundleProj = MigrationPlugin.IsOSGiAppProject(project) || MigrationPlugin.IsOSGiBundleProject(project);
                    boolean bl = projectContainsRuntimeClasspath = !MigrationPlugin.projectClasspathContainsInstalledRuntime(project);
                    if (!projectContainsRuntimeClasspath && !isOSGiAppOrBundleProj) {
                        return migrationProps.isMigrationRequired();
                    }
                    if (!projectContainsRuntimeClasspath && isOSGiAppOrBundleProj) {
                        if (runtime == null || runtime.getRuntimeType() == null || runtime.getRuntimeType().getId() == null) {
                            return migrationProps.isMigrationRequired();
                        }
                        boolean isMatchingRuntimeInstalled = false;
                        org.eclipse.wst.server.core.IRuntime[] installedRuntimes = ServerCore.getRuntimes();
                        if (installedRuntimes != null) {
                            for (org.eclipse.wst.server.core.IRuntime serverCoreRuntime : installedRuntimes) {
                                if (serverCoreRuntime.getRuntimeType() == null || serverCoreRuntime.getRuntimeType() == null || !serverCoreRuntime.getRuntimeType().getId().equals(runtime.getRuntimeType().getId())) continue;
                                isMatchingRuntimeInstalled = true;
                                break;
                            }
                        }
                        if (!isMatchingRuntimeInstalled) {
                            return migrationProps.isMigrationRequired();
                        }
                    }
                }
                if (runtime == null && facetedRuntime != null) {
                    return migrationProps.isMigrationRequired();
                }
            } else if (exVal.endsWith("*")) {
                String subString = exVal.substring(0, exVal.lastIndexOf("*"));
                if (Logger.INFO) {
                    Logger.println("/debug/info", (Object)this, "test()", "Looking for project with TargetedFaceted runtime name that start with='" + exVal + "'");
                }
                if (facetedRuntime != null && facetedRuntime.getName().startsWith(subString)) {
                    return migrationProps.isMigrationRequired();
                }
            } else {
                org.eclipse.wst.server.core.IRuntime runtime = null;
                if (facetedRuntime != null) {
                    runtime = FacetUtil.getRuntime((IRuntime)facetedRuntime);
                }
                if (runtime != null) {
                    return migrationProps.isMigrationRequired();
                }
            }
        }
        return false;
    }

    public static boolean isWASRuntime(org.eclipse.wst.server.core.IRuntime runtime) {
        return runtime != null && runtime.getRuntimeType() != null && (runtime.getRuntimeType().getId().startsWith(RUNTIME_TYPE_ID) || runtime.getRuntimeType().getId().startsWith(NEW_RUNTIME_TYPE_ID));
    }
}

