/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.migrator;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPlugin;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationPluginCoreMessages;
import com.ibm.etools.common.migration.extension.ui.internal.MigrationProjectProperties;
import com.ibm.etools.common.migration.extension.ui.internal.RuntimeMigratorExtensions;
import com.ibm.etools.common.migration.extension.ui.internal.model.UnresolvedRuntime;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.etools.common.migration.framework.IMigrationStatus;
import com.ibm.etools.common.migration.framework.MigrationStatus;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class UnresolvedRuntimeMigrator
extends AbstractMigration {
    public static final String MIGRATOR_ID = "com.ibm.etools.common.migration.extension.ui.migrator.UnresolvedRuntimeMigrator";
    private static final String LAST_UNSUPPORTED_WEBSPHERE_FACET_VERSION = "5.1";

    public List<IFile> getResourcesToChange(IProject project, IProgressMonitor monitor) {
        UnresolvedRuntime unresolvedRuntime;
        IRuntime runtime;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime;
        IFacetedProject fProject;
        Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, UnresolvedRuntime> unresolvedRuntimes;
        ArrayList<IFile> resourcesToChange;
        block12: {
            resourcesToChange = new ArrayList<IFile>();
            unresolvedRuntimes = this.getUnresolvedRuntime();
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject == null) {
                    return null;
                }
            }
            catch (CoreException ce) {
                if (Logger.INFO) {
                    Logger.println("/debug/info", (Object)this, "getResourcesToChange()", "Unable to create faceted projected from project=" + String.valueOf(project), (Throwable)ce);
                }
                return null;
            }
            facetedRuntime = fProject.getPrimaryRuntime();
            if (Logger.INFO) {
                Logger.println("/debug/info", (Object)this, "getResourcesToChange()", "project=" + fProject.getProject().getName() + " using IRuntime=" + String.valueOf(facetedRuntime));
            }
            runtime = null;
            if (facetedRuntime != null) {
                runtime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)facetedRuntime);
                try {
                    if (MigrationPlugin.projectClasspathContainsInstalledRuntime(project)) {
                        if (!unresolvedRuntimes.containsKey(facetedRuntime)) {
                            unresolvedRuntimes.put(facetedRuntime, new UnresolvedRuntime());
                        }
                        unresolvedRuntime = unresolvedRuntimes.get(facetedRuntime);
                        unresolvedRuntime.addProject(fProject);
                        resourcesToChange.add(project.getFile(".classpath"));
                        resourcesToChange.add(project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml"));
                    }
                }
                catch (Exception e) {
                    if (!Logger.INFO) break block12;
                    Logger.println("/debug/info", (Object)this, "getResourcesToChange", "Problem obtaining the project classpath information", (Throwable)e);
                }
            }
        }
        if (runtime == null && facetedRuntime != null) {
            if (!unresolvedRuntimes.containsKey(facetedRuntime)) {
                unresolvedRuntimes.put(facetedRuntime, new UnresolvedRuntime());
            }
            unresolvedRuntime = unresolvedRuntimes.get(facetedRuntime);
            unresolvedRuntime.addProject(fProject);
            IFile facetMetaFile = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
            resourcesToChange.add(facetMetaFile);
        }
        this.updateDataModel(unresolvedRuntimes);
        return resourcesToChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWebSphereFacets(IProject project, IRuntime runtime) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        IFacetedProjectWorkingCopy workingCopy = facetedProject.createWorkingCopy();
        try {
            Set defaultFacetVersions = workingCopy.getDefaultConfiguration().getProjectFacets();
            for (IProjectFacetVersion facetVersion : defaultFacetVersions) {
                if (!FacetUtilities.isWebSphereFacetId((String)facetVersion.getProjectFacet().getId())) continue;
                if (facetedProject.hasProjectFacet(facetVersion.getProjectFacet())) {
                    workingCopy.changeProjectFacetVersion(facetVersion);
                    continue;
                }
                workingCopy.addProjectFacet(facetVersion);
            }
            workingCopy.commitChanges(null);
        }
        finally {
            workingCopy.dispose();
        }
    }

    public void updateDataModel(Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, UnresolvedRuntime> unresolvedRuntimes) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new STMigrationDataModelProvider());
        dataModel.setProperty("STMigrationDataModelProvider.unresolvedRuntimesProperty", unresolvedRuntimes);
        super.getDataModel().addNestedModel(MIGRATOR_ID, dataModel);
    }

    public Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, UnresolvedRuntime> getUnresolvedRuntime() {
        Hashtable unresolvedRuntimes = null;
        Object cached = MigrationPlugin.getNestedDataModelObject(MIGRATOR_ID, "STMigrationDataModelProvider.unresolvedRuntimesProperty", this.getDataModel());
        if (cached != null && cached instanceof Hashtable) {
            unresolvedRuntimes = (Hashtable)cached;
        }
        if (unresolvedRuntimes == null) {
            unresolvedRuntimes = new Hashtable();
        }
        return unresolvedRuntimes;
    }

    public IMigrationStatus migrate(IProject project, IProgressMonitor monitor) {
        MigrationProjectProperties migrationProps = new MigrationProjectProperties(project);
        IStatus status = null;
        Hashtable<org.eclipse.wst.common.project.facet.core.runtime.IRuntime, UnresolvedRuntime> unresolvedRuntimes = this.getUnresolvedRuntime();
        for (UnresolvedRuntime unresolvedRuntime : unresolvedRuntimes.values()) {
            if (!unresolvedRuntime.isProjectSelected(project)) continue;
            try {
                block15: {
                    if (Logger.INFO) {
                        Logger.println("/debug/info", ((Object)((Object)this)).getClass(), "migrate", "Retargeting project [" + String.valueOf(project) + "]");
                    }
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    IRuntime curResolvedRuntime = unresolvedRuntime.getRuntime();
                    if (curResolvedRuntime == null) continue;
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime curPrimraryRuntime = facetedProject.getPrimaryRuntime();
                    HashSet<IProjectFacetVersion> originalFacets = new HashSet<IProjectFacetVersion>(facetedProject.getProjectFacets());
                    this.fireRuntimeMigrationAction(1, facetedProject, originalFacets, curPrimraryRuntime, unresolvedRuntime.getRuntime());
                    if (curPrimraryRuntime != null && curResolvedRuntime != null && curPrimraryRuntime.getLocalizedName() != null && curPrimraryRuntime.getLocalizedName().equals(curResolvedRuntime.getName())) {
                        facetedProject.removeTargetedRuntime(curPrimraryRuntime, monitor);
                    }
                    this.fireRuntimeMigrationAction(20, facetedProject, originalFacets, curPrimraryRuntime, unresolvedRuntime.getRuntime());
                    this.fireRuntimeMigrationAction(30, facetedProject, originalFacets, curPrimraryRuntime, unresolvedRuntime.getRuntime());
                    MigrationPlugin.setRuntime(facetedProject, unresolvedRuntime.getRuntime());
                    this.fireRuntimeMigrationAction(40, facetedProject, originalFacets, curPrimraryRuntime, unresolvedRuntime.getRuntime());
                    try {
                        Set facetVersions = FacetUtilities.getWebSphereFacetVersions((IProject)project);
                        for (IProjectFacetVersion curFacetVersion : facetVersions) {
                            if (!LAST_UNSUPPORTED_WEBSPHERE_FACET_VERSION.equals(curFacetVersion.getVersionString())) continue;
                            this.setWebSphereFacets(project, unresolvedRuntime.getRuntime());
                            break;
                        }
                        if (facetVersions.isEmpty()) {
                            this.setWebSphereFacets(project, unresolvedRuntime.getRuntime());
                        }
                    }
                    catch (Exception e) {
                        if (!Logger.WARNING) break block15;
                        Logger.println("/debug/warning", (Object)this, "migrate()", "Cannot migrate the WebSphere v5.1 facet.", (Throwable)e);
                    }
                }
                status = new Status(1, "com.ibm.etools.common.migration.extension.ui", NLS.bind((String)MigrationPluginCoreMessages.W_NoRuntimeSelected, (Object)project));
            }
            catch (Exception e) {
                if (Logger.ERROR) {
                    Logger.println("/debug/error", ((Object)((Object)this)).getClass(), "migrate", "Exception attaching runtime [" + String.valueOf(unresolvedRuntime.getRuntime()) + "]to project:" + String.valueOf(project), (Throwable)e);
                }
                status = new Status(4, "com.ibm.etools.common.migration.extension.ui", NLS.bind((String)MigrationPluginCoreMessages.E_UnableToChangeRuntime, (Object)project, (Object)e.getMessage()));
                try {
                    migrationProps.setMigratedProject(false, null);
                }
                catch (CoreException ce) {
                    this.handleException((Exception)((Object)ce), "Problem adding the .settings properties to the project");
                }
            }
        }
        if (status == null) {
            status = Status.OK_STATUS;
        }
        try {
            migrationProps.setMigratedProject(true, null);
        }
        catch (CoreException ce) {
            this.handleException((Exception)((Object)ce), "Problem adding the .settings properties to the project");
        }
        return new MigrationStatus(status);
    }

    private void handleException(Exception e, String customMessage) {
        if (Logger.ERROR) {
            Logger.println("/debug/error", (Object)this, "handleException()", "** Exception during Server Migration **", (Throwable)e);
        }
        if (customMessage != null && Logger.ERROR) {
            Logger.println("/debug/error", (Object)this, "handleException()", "** " + customMessage + " **");
        }
    }

    private void fireRuntimeMigrationAction(int action, IFacetedProject facetedProject, Set<IProjectFacetVersion> originalFacets, org.eclipse.wst.common.project.facet.core.runtime.IRuntime targetedRuntime, IRuntime userSelectedRuntime) throws CoreException {
        RuntimeMigratorExtensions rmex = RuntimeMigratorExtensions.getInstance();
        for (IRuntimeMigratorModifier adopter : rmex.getOrderedSupportedMigrators(originalFacets)) {
            adopter.runtimeMigrationAction(action, facetedProject, targetedRuntime, userSelectedRuntime);
        }
    }

    public class STMigrationDataModelProvider
    extends AbstractDataModelProvider {
        public static final String UNRESOLVED_RUNTIME_PROP = "STMigrationDataModelProvider.unresolvedRuntimesProperty";

        public Set getPropertyNames() {
            Set propertyNames = super.getPropertyNames();
            propertyNames.add(UNRESOLVED_RUNTIME_PROP);
            return propertyNames;
        }

        public Object getDefaultProperty(String propertyName) {
            if (UNRESOLVED_RUNTIME_PROP.equals(propertyName)) {
                return new Hashtable();
            }
            return super.getDefaultProperty(propertyName);
        }
    }
}

