/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.server.core.IRuntime;

public class UnresolvedRuntime {
    private IRuntime runtime;
    private ArrayList<ProjectSelection> projectList;
    private String[] errorMessage;
    private ArrayList<IRuntime> availableRuntimes;

    public UnresolvedRuntime() {
        this.runtime = null;
        this.projectList = new ArrayList();
        this.availableRuntimes = new ArrayList();
    }

    public UnresolvedRuntime(IRuntime runtime, IFacetedProject[] projects) {
        this.runtime = runtime;
        this.projectList = new ArrayList();
        for (IFacetedProject project : projects) {
            this.projectList.add(new ProjectSelection(project));
        }
    }

    public void addProject(IFacetedProject facetedProject) {
        String name;
        IProject project = facetedProject.getProject();
        if (project != null && (name = project.getName()) != null) {
            for (ProjectSelection currentProjectSelection : this.projectList) {
                String currentName;
                IProject currentProject;
                if (currentProjectSelection == null || (currentProject = currentProjectSelection.getProject()) == null || !name.equals(currentName = currentProject.getName())) continue;
                return;
            }
        }
        this.projectList.add(new ProjectSelection(facetedProject));
    }

    public IProject[] getSelectedProjects() {
        ArrayList<IProject> selectedList = new ArrayList<IProject>();
        for (ProjectSelection projectSelection : this.projectList) {
            if (!projectSelection.isSelected()) continue;
            selectedList.add(projectSelection.getProject());
        }
        return selectedList.toArray(new IProject[0]);
    }

    public IProject[] getUnSelectedProjects() {
        ArrayList<IProject> selectedList = new ArrayList<IProject>();
        for (ProjectSelection projectSelection : this.projectList) {
            if (projectSelection.isSelected()) continue;
            selectedList.add(projectSelection.getProject());
        }
        return selectedList.toArray(new IProject[0]);
    }

    public IProject[] getProjectAsList() {
        IProject[] projects = new IProject[this.projectList.size()];
        for (int i = 0; i < this.projectList.size(); ++i) {
            projects[i] = this.projectList.get(i).getProject();
        }
        return projects;
    }

    public void setRuntime(IRuntime runtime) {
        this.runtime = runtime;
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    public void setProjectSelected(IProject project, boolean value) {
        for (ProjectSelection projectSelection : this.projectList) {
            if (projectSelection.getProject() != project) continue;
            projectSelection.setSelection(value);
        }
    }

    public boolean isProjectSelected(IProject project) {
        for (ProjectSelection projectSelection : this.projectList) {
            if (projectSelection.getProject() != project) continue;
            return projectSelection.isSelected();
        }
        return false;
    }

    public void setAvailableRuntimes(IRuntime[] runtimes) {
        this.availableRuntimes.clear();
        Collections.addAll(this.availableRuntimes, runtimes);
    }

    public IRuntime[] getAvailableRuntimes() {
        return this.availableRuntimes.toArray(new IRuntime[0]);
    }

    public String[] getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String[] errorMessage) {
        this.errorMessage = errorMessage;
    }

    private class ProjectSelection {
        private IFacetedProject project;
        private boolean selected;

        public ProjectSelection(IFacetedProject project) {
            this.project = project;
            this.selected = true;
        }

        public void setSelection(boolean selection) {
            this.selected = selection;
        }

        public IProject getProject() {
            return this.project.getProject();
        }

        public IFacetedProject getFacetedProject() {
            return this.project;
        }

        public boolean isSelected() {
            return this.selected;
        }
    }
}

