/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.IRuntimeMigratorModifierSupplier;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class RuntimeMigratorModifierSupplierExtension {
    private static String EP_ATTRIBUTE_ID = "id";
    private static String EP_ATTRIBUTE_CLASS = "class";
    private static RuntimeMigratorModifierSupplierExtension rmmse;
    List<IRuntimeMigratorModifierSupplier> runtimeMigratorModifiers = new LinkedList<IRuntimeMigratorModifierSupplier>();

    public static RuntimeMigratorModifierSupplierExtension getInstance() {
        if (rmmse == null) {
            return new RuntimeMigratorModifierSupplierExtension();
        }
        return rmmse;
    }

    public RuntimeMigratorModifierSupplierExtension() {
        this.loadExtensionPoints();
    }

    private void loadExtensionPoints() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("com.ibm.etools.common.migration.extension.ui.runtimeMigratorModifierSupplier");
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement exElement = extensions[i];
            IRuntimeMigratorModifierSupplier rmm = this.getRMMModifierClass(exElement);
            if (rmm == null) continue;
            this.runtimeMigratorModifiers.add(rmm);
        }
    }

    public List<IRuntimeMigratorModifier> getOrderedSupportedMigrators(Set<IProjectFacetVersion> originalFacets) {
        ArrayList<IRuntimeMigratorModifier> result = new ArrayList<IRuntimeMigratorModifier>();
        for (IRuntimeMigratorModifierSupplier element : this.runtimeMigratorModifiers) {
            result.addAll(element.getOrderedSupportedMigrators(originalFacets));
        }
        return result;
    }

    public IRuntimeMigratorModifier getSupportedMigrators(IProjectFacetVersion pfv) {
        for (IRuntimeMigratorModifierSupplier element : this.runtimeMigratorModifiers) {
            IRuntimeMigratorModifier migratorModifier = element.getSupportedMigrators(pfv);
            if (migratorModifier == null) continue;
            return migratorModifier;
        }
        return null;
    }

    public IRuntimeMigratorModifierSupplier getRMMModifierClass(IConfigurationElement configElement) {
        IRuntimeMigratorModifierSupplier mm;
        block2: {
            mm = null;
            try {
                mm = (IRuntimeMigratorModifierSupplier)configElement.createExecutableExtension(EP_ATTRIBUTE_CLASS);
            }
            catch (Exception e) {
                if (!Logger.DETAILS) break block2;
                Logger.println("/debug/details", this, "getMigrators (0)", "Unable to createExecutableExtension for <" + configElement.getAttribute(EP_ATTRIBUTE_ID) + ">", (Throwable)e);
            }
        }
        return mm;
    }
}

