/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.RMMElement;
import com.ibm.etools.common.migration.extension.ui.internal.RuntimeMigratorModifierSupplierExtension;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class RuntimeMigratorExtensions {
    private static String EP_ATTRIBUTE_ID = "id";
    List<RMMElement> runtimeMigratorModifiers = new LinkedList<RMMElement>();
    private static RuntimeMigratorExtensions _instance;

    public RuntimeMigratorExtensions() {
        this.loadExtensionPoints();
    }

    public static RuntimeMigratorExtensions getInstance() {
        if (_instance == null) {
            _instance = new RuntimeMigratorExtensions();
        }
        return _instance;
    }

    public static RuntimeMigratorExtensions getInstance(IDataModel dataModel) {
        RuntimeMigratorExtensions.getInstance();
        return _instance;
    }

    private void loadExtensionPoints() {
        if (Logger.DETAILS) {
            Logger.println("/debug/details", this, "loadExtensionPoints()", "--- Load .runtimeMigratorModifier extension point --->");
        }
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor("com.ibm.etools.common.migration.extension.ui.runtimeMigratorModifier");
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement exElement = extensions[i];
            RMMElement adopter = new RMMElement(exElement);
            if (adopter.isValid()) {
                this.runtimeMigratorModifiers.add(adopter);
                if (!Logger.DETAILS) continue;
                Logger.println("/debug/details", this, "loadExtensionPoints()", "Loaded IRuntimeMigrator: " + extensions[i].getAttribute(EP_ATTRIBUTE_ID));
                continue;
            }
            if (!Logger.ERROR) continue;
            Logger.println("/debug/error", this, "loadExtensionPoints()", "Extension is invalid: " + extensions[i].getAttribute(EP_ATTRIBUTE_ID));
        }
        int size = this.runtimeMigratorModifiers.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                RMMElement a = this.runtimeMigratorModifiers.get(i);
                RMMElement b = this.runtimeMigratorModifiers.get(j);
                if (a.getOrder() <= b.getOrder()) continue;
                this.runtimeMigratorModifiers.set(i, b);
                this.runtimeMigratorModifiers.set(j, a);
            }
        }
        if (Logger.DETAILS) {
            Logger.println("/debug/details", this, "loadExtensionPoints()", "<--- End .runtimeMigratorModifier extension point ---");
        }
    }

    public List<IRuntimeMigratorModifier> getOrderedSupportedMigrators(Set<IProjectFacetVersion> originalFacets) {
        ArrayList<IRuntimeMigratorModifier> result = new ArrayList<IRuntimeMigratorModifier>();
        for (RMMElement element : this.runtimeMigratorModifiers) {
            IRuntimeMigratorModifier migrator;
            if (!element.supports(originalFacets) || (migrator = element.getRMMModifierClass()) == null) continue;
            result.add(migrator);
        }
        RuntimeMigratorModifierSupplierExtension rmmse = RuntimeMigratorModifierSupplierExtension.getInstance();
        result.addAll(rmmse.getOrderedSupportedMigrators(originalFacets));
        return result;
    }

    public IRuntimeMigratorModifier getSupportedMigrators(IProjectFacetVersion pfv) {
        for (RMMElement element : this.runtimeMigratorModifiers) {
            IRuntimeMigratorModifier migrator;
            if (!element.supports(pfv) || (migrator = element.getRMMModifierClass()) == null) continue;
            return migrator;
        }
        RuntimeMigratorModifierSupplierExtension rmmse = RuntimeMigratorModifierSupplierExtension.getInstance();
        return rmmse.getSupportedMigrators(pfv);
    }

    public List<IRuntimeMigratorModifier> getOrderedSupportedMigrators() {
        ArrayList<IRuntimeMigratorModifier> result = new ArrayList<IRuntimeMigratorModifier>();
        for (RMMElement element : this.runtimeMigratorModifiers) {
            IRuntimeMigratorModifier migrator = element.getRMMModifierClass();
            if (migrator == null) continue;
            result.add(migrator);
        }
        return result;
    }
}

