/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.migration.extension.ui.IRuntimeMigratorModifier;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Version;

public class RMMElement {
    private static String EP_ATTRIBUTE_CLASS = "class";
    private static String EP_ATTRIBUTE_ORDER = "order";
    private static String EP_ATTRIBUTE_ID = "id";
    private static String EP_ELEMENT_FACET = "facet";
    private static String FACET_ELEMENT_ID = "id";
    private static String FACET_ELEMENT_VERSION = "version";
    private IConfigurationElement configElement;
    private IRuntimeMigratorModifier mm;
    private Integer order;
    private HashMap<String, VersionRange> supported = new HashMap();

    public RMMElement(IConfigurationElement configElement) {
        this.configElement = configElement;
        for (IConfigurationElement facet : configElement.getChildren(EP_ELEMENT_FACET)) {
            String facetId = facet.getAttribute(FACET_ELEMENT_ID);
            String version = facet.getAttribute(FACET_ELEMENT_VERSION);
            if (version == null || version.isEmpty()) {
                this.supported.put(facetId, null);
                continue;
            }
            try {
                VersionRange range = new VersionRange(version);
                this.supported.put(facetId, range);
            }
            catch (Exception e) {
                if (!Logger.ERROR) continue;
                Logger.println("/debug/error", this, "RMMElement(IConfigurationElement)", "The version range (" + version + ") for facet " + facetId + " is not valid in extension: " + this.getId());
            }
        }
    }

    public IRuntimeMigratorModifier getRMMModifierClass() {
        block4: {
            if (this.mm == null) {
                try {
                    this.mm = (IRuntimeMigratorModifier)this.configElement.createExecutableExtension(EP_ATTRIBUTE_CLASS);
                    if (Logger.DETAILS) {
                        Logger.println("/debug/details", this, "loadExtensionPoints()", "Loaded IRuntimeMigrator: " + this.mm.getClass().getCanonicalName());
                    }
                }
                catch (Exception e) {
                    if (!Logger.DETAILS) break block4;
                    Logger.println("/debug/details", this, "getMigrators (0)", "Unable to createExecutableExtension for <" + this.getId() + ">", (Throwable)e);
                }
            }
        }
        return this.mm;
    }

    public String getId() {
        return this.configElement.getAttribute(EP_ATTRIBUTE_ID);
    }

    public String getAttribute(String attributeName) {
        return this.configElement.getAttribute(attributeName);
    }

    public int getOrder() {
        if (this.order == null) {
            this.order = Integer.valueOf(this.configElement.getAttribute(EP_ATTRIBUTE_ORDER));
        }
        return this.order;
    }

    public boolean supports(String facet, String version) {
        if (facet == null || !this.supported.containsKey(facet)) {
            return false;
        }
        VersionRange range = this.supported.get(facet);
        if (range == null) {
            return true;
        }
        try {
            return range.isIncluded(new Version(version));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean supports(IProjectFacetVersion pfv) {
        if (pfv == null) {
            return false;
        }
        IProjectFacet facet = pfv.getProjectFacet();
        if (facet == null) {
            return false;
        }
        String version = pfv.getVersionString();
        return this.supports(facet.getId(), version);
    }

    public boolean supports(IFacetedProject project) {
        if (project == null) {
            return false;
        }
        return this.supports(project.getProjectFacets());
    }

    public boolean supports(Set<IProjectFacetVersion> facets) {
        for (IProjectFacetVersion pfv : facets) {
            if (!this.supports(pfv)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return !this.supported.isEmpty();
    }
}

