/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.migration.extension.ui.internal;

import com.ibm.etools.common.internal.migration.framework.MigrationFrameworkRegistry;
import com.ibm.etools.common.migration.extension.ui.internal.WebSpherePluginGraphicResources;
import com.ibm.etools.common.migration.extension.ui.internal.trace.Logger;
import com.ibm.etools.common.migration.framework.AbstractMigration;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MigrationPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.etools.common.migration.extension.ui";
    public static final String WAS_V85_RUNTIME_TYPE_ID = "com.ibm.ws.ast.st.runtime.v85";
    private static MigrationPlugin singleton;
    private static ResourceBundle resourceStrs;
    public static final String PROP_MIGRATED = "migrated";
    public static final String RAD_CONFIG_FILES = "RAD_CONFIG_FILES";
    public static final String RAD_SERVER_FILES = "RAD_SERVER_FILES";
    private static final String MIGRATED_SERVERS_ID = "MIGRATED_SERVERS_ID";
    private static final String METADATA_FILE = ".preferences";
    public static final float CURRENT_RAD_VERSION = 8.5f;
    public static final String SERVER_TYPE_ID_V5 = "com.ibm.websphere.v51.server.base";
    public static final String SERVER_TYPE_ID_REMOTE_V5 = "com.ibm.websphere.v51.server.remote.base";
    protected HashSet<String> jreNamesSet;

    public MigrationPlugin() {
        singleton = this;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry curImageRegistry = null;
        if (Display.getCurrent() != null) {
            curImageRegistry = WebSpherePluginGraphicResources.initialize();
        }
        return curImageRegistry;
    }

    public static MigrationPlugin getInstance() {
        return singleton;
    }

    public static String getResourceStr(String curKey) {
        String valueStr = curKey;
        if (MigrationPlugin.getResourceStrs() != null && curKey != null) {
            try {
                valueStr = MigrationPlugin.getResourceStrs().getString(curKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return valueStr;
    }

    public static String getResourceStr(String curBaseStrKey, String subsituteStrKey) {
        String valueStr = curBaseStrKey;
        if (valueStr != null) {
            try {
                valueStr = MigrationPlugin.getResourceStr(curBaseStrKey);
                String subsituteStr = MigrationPlugin.getResourceStr(subsituteStrKey);
                valueStr = MessageFormat.format(valueStr, subsituteStr);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return valueStr;
    }

    public static String getResourceStr(String curBaseStrKey, String subsituteStrKey1, String subsituteStrKey2) {
        String valueStr = curBaseStrKey;
        if (valueStr != null) {
            try {
                valueStr = MigrationPlugin.getResourceStr(curBaseStrKey);
                String subsituteStr1 = MigrationPlugin.getResourceStr(subsituteStrKey1);
                String subsituteStr2 = MigrationPlugin.getResourceStr(subsituteStrKey2);
                valueStr = MessageFormat.format(valueStr, subsituteStr1, subsituteStr2);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return valueStr;
    }

    public static ResourceBundle getResourceStrs() {
        return resourceStrs;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)new Logger(), props);
        try {
            if (resourceStrs == null) {
                resourceStrs = Platform.getResourceBundle((Bundle)this.getBundle());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceStrs == null && Logger.ERROR) {
            Logger.println("/debug/error", (Object)this, "start()", "Error: cannot find the plugin resource file.");
        }
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "start()", "Finished initializing the plugin: com.ibm.etools.common.migration.extension.ui");
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (Logger.INFO) {
            Logger.println("/debug/info", (Object)this, "stop()", "Shutting down the plugin: com.ibm.etools.common.migration.extension.ui");
        }
        super.stop(context);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/obj16/" + path));
    }

    public static boolean setRuntime(IFacetedProject facetedProject, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) throws CoreException {
        Set runSet = facetedProject.getTargetedRuntimes();
        if (runSet.isEmpty() || !runSet.contains(runtime)) {
            HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> runtimes = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
            runtimes.add(runtime);
            facetedProject.setTargetedRuntimes(runtimes, (IProgressMonitor)new NullProgressMonitor());
        }
        facetedProject.setPrimaryRuntime(runtime, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public static boolean setRuntime(IFacetedProject facetedProject, IRuntime runtime) throws CoreException {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetedRuntime = FacetUtil.getRuntime((IRuntime)runtime);
        Set runSet = facetedProject.getTargetedRuntimes();
        if (runSet.isEmpty() || !runSet.contains(runtime)) {
            HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime> runtimes = new HashSet<org.eclipse.wst.common.project.facet.core.runtime.IRuntime>();
            runtimes.add(facetedRuntime);
            facetedProject.setTargetedRuntimes(runtimes, (IProgressMonitor)new NullProgressMonitor());
        }
        facetedProject.setPrimaryRuntime(facetedRuntime, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public static Object getNestedDataModelObject(String dataModelId, String propertyName, IDataModel parentDataModel) {
        IDataModel dataModel = MigrationPlugin.getNestedDataModel(dataModelId, parentDataModel);
        Object cached = null;
        if (dataModel != null) {
            cached = dataModel.getProperty(propertyName);
        }
        return cached;
    }

    public static IDataModel getNestedDataModel(String id, IDataModel parentDataModel) {
        IDataModel rv = null;
        if (parentDataModel.isNestedModel(id)) {
            rv = parentDataModel.getNestedModel(id);
        }
        return rv;
    }

    public static boolean isActiveMigrator(IDataModel parentDataModel, String migratorID) {
        List property = (List)parentDataModel.getProperty("IMigrationFrameworkDataModelProperties.POTENTIAL_MIGRATION_PROJECTS");
        Iterator projectIterator = property.iterator();
        while (projectIterator.hasNext()) {
            List migratorList = MigrationFrameworkRegistry.INSTANCE.getMigratorsForProject((IProject)projectIterator.next());
            for (AbstractMigration migrator : migratorList) {
                if (!migrator.getMigratorID().equals(migratorID)) continue;
                return true;
            }
        }
        return false;
    }

    public static IRuntime findRuntimeWithTypeId(String runtimeTypeId) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            if (!runtimes[i].getRuntimeType().getId().equals(runtimeTypeId)) continue;
            return runtimes[i];
        }
        return null;
    }

    public static void setFacets(IProject project, org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime) throws CoreException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (MigrationPlugin.setRuntime(facetedProject, runtime)) {
            Set defaultFacets = runtime.getDefaultFacets(facetedProject.getFixedProjectFacets());
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion facetVersion : defaultFacets) {
                IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null);
                if (FacetUtilities.hasFacet((IProject)project, (String)facetVersion.getProjectFacet().getId())) continue;
                actions.add(action);
            }
            if (!actions.isEmpty()) {
                facetedProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public static boolean projectClasspathContainsInstalledRuntime(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            boolean found = false;
            for (int i = 0; i < rawClasspath.length && !found; ++i) {
                String segment;
                IPath path = rawClasspath[i].getPath();
                if (path.segmentCount() <= 2 || !MigrationPlugin.checkRuntimeById(segment = path.segment(2))) continue;
                found = true;
            }
            if (!found) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean IsOSGiBundleProject(IProject project) {
        return MigrationPlugin.projectContainsFacetWithId(project, "osgi.bundle");
    }

    public static boolean IsOSGiAppProject(IProject project) {
        return MigrationPlugin.projectContainsFacetWithId(project, "osgi.app");
    }

    private static boolean projectContainsFacetWithId(IProject project, String facetId) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                return false;
            }
            if (facetedProject.getProjectFacets() == null) {
                return false;
            }
            for (IProjectFacetVersion ipfv : facetedProject.getProjectFacets()) {
                String id;
                if (ipfv.getProjectFacet() == null || (id = ipfv.getProjectFacet().getId()) == null || !id.equals(facetId)) continue;
                return true;
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return false;
    }

    private static boolean checkRuntimeById(String id) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            if (!id.equals(runtimes[i].getId())) continue;
            return true;
        }
        return false;
    }

    static {
        resourceStrs = null;
    }
}

