/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.aries.internal.maven.ui.convert;

import com.ibm.etools.aries.internal.maven.core.convert.ConvertOperation;
import com.ibm.etools.aries.internal.maven.ui.AriesMavenUIActivator;
import com.ibm.etools.aries.internal.maven.ui.convert.MavenToOSGiDialog;
import com.ibm.etools.aries.internal.maven.ui.utils.Trace;
import com.ibm.etools.aries.internal.provisional.core.utils.AriesUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractConvertActionDelegate
implements IObjectActionDelegate {
    private ISelection selection;
    private boolean isFragment;

    protected AbstractConvertActionDelegate(boolean isFragment) {
        this.isFragment = isFragment;
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        final IProject project = (IProject)((IStructuredSelection)this.selection).getFirstElement();
        Shell activeShell = Display.getCurrent().getActiveShell();
        MavenToOSGiDialog dialog = new MavenToOSGiDialog(activeShell, project, this.isFragment);
        if (dialog.open() == 1) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    new ConvertOperation().convert(project, monitor);
                    AriesUtils.disassociateProjectFromEARs((IProject)project);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (Trace.TRACE_ERROR) {
                AriesMavenUIActivator.getTrace().trace("/debug/error", e.getMessage(), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

