/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ejb.ui.internal.utilities;

import com.ibm.etools.annotations.core.data.AnnotationInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class AnnotationOverrideHelper {
    static final String METAINF_FOLDER_NAME = "META-INF";
    static final String DEPLOYMENT_DESCRIPTOR_NAME = "ejb-jar.xml";

    public static boolean isEjb3Project(IProject project) {
        boolean result = false;
        if (project != null) {
            try {
                result = FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.ejb", (String)">=3.0");
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return result;
    }

    public static String getOverrideSourceFileString(IProject project) {
        try {
            if (!AnnotationOverrideHelper.isEjb3Project(project)) {
                return null;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        IFile ddFile = AnnotationOverrideHelper.findMetaInfFile(DEPLOYMENT_DESCRIPTOR_NAME, project);
        if (ddFile != null && ddFile.getFullPath() != null) {
            return ddFile.getFullPath().toString();
        }
        return "Test.xml";
    }

    public static IFile getOverrideSourceFile(IProject project) {
        IFile ddFile = AnnotationOverrideHelper.findMetaInfFile(DEPLOYMENT_DESCRIPTOR_NAME, project);
        if (ddFile != null) {
            return ddFile;
        }
        return null;
    }

    private static IFolder findMetaInfFolder(IProject project) throws CoreException {
        IVirtualResource[] members;
        IFolder result = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && (members = component.getRootFolder().members()) != null && members.length > 0) {
            boolean metaInfFolderFound = false;
            for (int i = 0; !metaInfFolderFound && i < members.length; ++i) {
                if (members[i].getType() != 16 || METAINF_FOLDER_NAME.equals(members[i].getName())) {
                    // empty if block
                }
                if (members[i].getType() != 32 || !METAINF_FOLDER_NAME.equals(members[i].getName())) continue;
                result = (IFolder)members[i].getUnderlyingResource();
                metaInfFolderFound = true;
            }
        }
        if (result != null) {
            int count = result.getFullPath().segmentCount();
            for (int i = 0; i < count; ++i) {
                result.getFullPath().segment(i);
                IResource[] res = result.members();
                if (res == null || res.length <= 0) continue;
                for (int ii = 0; ii < res.length; ++ii) {
                    res[ii].getType();
                }
            }
        }
        return result;
    }

    private static IFile findMetaInfFile(String fileName, IProject project) {
        IFile file = null;
        try {
            IResource resource;
            IFolder metaInfFolder = AnnotationOverrideHelper.findMetaInfFolder(project);
            if (metaInfFolder != null && (resource = project.getProject().findMember(metaInfFolder.getProjectRelativePath().append(fileName))) != null && resource instanceof IFile) {
                file = (IFile)resource;
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return file;
    }

    public static AnnotationInfo getAnnotationInfo(IJavaElement je) {
        return null;
    }
}

