/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.annotations.ejb.ui.internal;

import com.ibm.etools.annotations.core.api.AnnotationOverrideHandler;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.data.AnnotationOverrideInfo;
import com.ibm.etools.annotations.core.data.AttributeOverrideInfo;
import com.ibm.etools.annotations.core.utils.AnnotationConstants;
import com.ibm.etools.annotations.ejb.ui.internal.utilities.AnnotationOverrideHelper;
import com.ibm.etools.annotations.ejb.ui.internal.utilities.OverrideEModelHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;

public class DDOverrideHandler
extends AnnotationOverrideHandler {
    public AttributeOverrideInfo getOverrideValue(String tagName, String attrName, IProject project, String file, AnnotationInfo aInfo, int offset) {
        AnnotationOverrideInfo annoInfo = this.getOverrideValues(tagName, project, file, aInfo, offset);
        if (annoInfo == null) {
            return null;
        }
        AttributeOverrideInfo attrInfo = annoInfo.getAttributeInfo(attrName);
        if (attrInfo == null) {
            return null;
        }
        return attrInfo;
    }

    public AnnotationOverrideInfo getOverrideValues(String tagName, IProject project, String filename, AnnotationInfo aInfo, int offset) {
        try {
            if (!AnnotationOverrideHelper.isEjb3Project(project)) {
                return null;
            }
        }
        catch (Exception exc) {
            return null;
        }
        Hashtable annoOverrideInfoHash = OverrideEModelHandler.getSingleInstance().getAllOverridesInfoForAnnotation(project, filename, aInfo, offset);
        if (annoOverrideInfoHash != null) {
            StringBuffer key = new StringBuffer(tagName);
            if (aInfo != null) {
                key.append(aInfo.getOffset());
            } else {
                key.append(offset);
            }
            String tagKey = key.toString();
            AnnotationOverrideInfo AnnoOverInfo = null;
            if (annoOverrideInfoHash != null && !annoOverrideInfoHash.isEmpty()) {
                AnnoOverInfo = (AnnotationOverrideInfo)annoOverrideInfoHash.get(tagKey);
            }
            if (AnnoOverInfo == null && aInfo == null) {
                AnnoOverInfo = this.tryDifferentOffset(annoOverrideInfoHash, offset, tagName);
            }
            if (AnnoOverInfo != null) {
                String sourceOverrideFile = AnnotationOverrideHelper.getOverrideSourceFileString(project);
                AnnoOverInfo.setSourceOverride(sourceOverrideFile);
            }
            return AnnoOverInfo;
        }
        return null;
    }

    public void dumpOverrideInfo(Hashtable annotationLists, int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        String prefix = sb.toString();
        if (annotationLists != null) {
            Enumeration annos = annotationLists.keys();
            while (annos != null && annos.hasMoreElements()) {
                List attrInfo;
                String annoName = (String)annos.nextElement();
                AnnotationConstants.debug((Object)(prefix + "anno name:" + annoName));
                AnnotationOverrideInfo aInfo = (AnnotationOverrideInfo)annotationLists.get(annoName);
                if (aInfo == null || (attrInfo = aInfo.getAttributeOverrideInfo()) == null) continue;
                AnnotationConstants.debug((Object)(prefix + "attribute size=" + attrInfo.size()));
                for (int k = 0; k < attrInfo.size(); ++k) {
                    AttributeOverrideInfo attrO = (AttributeOverrideInfo)attrInfo.get(k);
                    AnnotationConstants.debug((Object)(prefix + " attributeName=" + attrO.getName()));
                    AnnotationConstants.debug((Object)(prefix + "    override value=" + String.valueOf(attrO.getValue())));
                    AnnotationConstants.debug((Object)(prefix + "    annotation value=" + String.valueOf(attrO.getAnnotationValue())));
                    AnnotationConstants.debug((Object)(prefix + "    isImplied=" + attrO.isImplied()));
                    AnnotationConstants.debug((Object)(prefix + "    isDeclared=" + attrO.isDeclared()));
                }
            }
        }
    }

    private AnnotationOverrideInfo tryDifferentOffset(Hashtable annoOverrideInfoHash, int offset, String tagName) {
        boolean found = false;
        if (annoOverrideInfoHash != null) {
            Enumeration tagKeys = annoOverrideInfoHash.keys();
            while (tagKeys != null && tagKeys.hasMoreElements() && !found) {
                String tagKey = (String)tagKeys.nextElement();
                if (!tagKey.startsWith(tagName)) continue;
                AnnotationOverrideInfo annoOverrideInfo = (AnnotationOverrideInfo)annoOverrideInfoHash.get(tagKey);
                IAnnotation aObj = annoOverrideInfo.getAnnotationObject();
                try {
                    if (aObj == null || aObj.getSourceRange() == null) continue;
                    int aOffsetStart = aObj.getSourceRange().getOffset();
                    int aOffsetEnd = aObj.getSourceRange().getLength() + aOffsetStart;
                    if (offset < aOffsetStart || offset > aOffsetEnd) continue;
                    found = true;
                    return annoOverrideInfo;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        return null;
    }
}

