/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.batch.ui.internal.views;

import com.ibm.ws.st.jee.batch.core.internal.wlp.util.JobLogHelper;
import com.ibm.ws.st.jee.batch.jobs.IJobManager;
import com.ibm.ws.st.jee.batch.jobs.model.JobLog;
import com.ibm.ws.st.jee.batch.ui.STBatchUIPlugin;
import com.ibm.ws.st.jee.batch.ui.internal.views.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.server.core.IServer;

public class JobLogViewPart
extends ViewPart {
    public static final String VIEW_ID = "com.ibm.ws.st.jee.batch.ui.joblogs.view";
    private TableViewer viewer;
    private IMenuManager menuManager;
    private JobLogContentProvider jobLogViewContentProvider;
    private Job lastEclipseJob;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogName);
        column.getColumn().setWidth(80);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogInstance);
        column.getColumn().setWidth(80);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogExecution);
        column.getColumn().setWidth(80);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogExitStatus);
        column.getColumn().setWidth(100);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogEndTime);
        column.getColumn().setWidth(200);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.jobLogServer);
        column.getColumn().setWidth(500);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setEnabled(true);
        this.jobLogViewContentProvider = new JobLogContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.jobLogViewContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new JobLogLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.setComparator((ViewerComparator)new JobLogComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && !selection.isEmpty() && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof JobLog) {
                    JobLogViewPart.this.openLog((JobLog)selectedObject);
                }
            }
        });
        this.menuManager = this.getViewSite().getActionBars().getMenuManager();
        this.menuManager.add((IContributionItem)new Separator("additions"));
        this.showAllLogs();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void showLogsFor(IServer targetServer, String jobName, IJobManager jobManager) {
        this.menuManager.removeAll();
        this.menuManager.add((IAction)new JobLogRefreshAction());
        this.menuManager.add((IAction)new JobLogShowAllAction());
        this.jobLogViewContentProvider.setFilterTo(targetServer, jobName, jobManager);
        this.refreshView();
    }

    private void showAllLogs() {
        this.menuManager.removeAll();
        this.menuManager.add((IAction)new JobLogRefreshAction());
        this.jobLogViewContentProvider.removeFilter();
        this.refreshView();
    }

    public void refreshView() {
        JobLogChangeAdapter listener = new JobLogChangeAdapter();
        if (this.lastEclipseJob != null) {
            this.lastEclipseJob.cancel();
        }
        this.lastEclipseJob = new Job(Messages.jobLogProcessingEntries){

            protected IStatus run(IProgressMonitor monitor) {
                JobLogViewPart.this.jobLogViewContentProvider.refreshLogs(monitor);
                return Status.OK_STATUS;
            }
        };
        this.lastEclipseJob.addJobChangeListener((IJobChangeListener)listener);
        this.lastEclipseJob.setPriority(20);
        this.lastEclipseJob.schedule();
    }

    private void openLog(JobLog jobLog) {
        String name;
        String browserName = name = jobLog.getJobInstance().getJobName();
        String tooltip = name;
        String browserId = jobLog.getJobLogRelativePath();
        try {
            URL url = new URL(jobLog.getJobLogRelativePath());
            IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser b = bs.createBrowser(38, browserId, browserName, tooltip);
            b.openURL(url);
        }
        catch (MalformedURLException e1) {
            STBatchUIPlugin.logError(e1);
        }
        catch (PartInitException e1) {
            STBatchUIPlugin.logError((CoreException)((Object)e1));
        }
    }

    private final class JobLogContentProvider
    implements IStructuredContentProvider {
        private IServer forServer;
        private String forJob;
        private IJobManager withJobManager;
        private boolean isFiltered = false;
        private List<JobLog> logList = new ArrayList<JobLog>();

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.logList.toArray();
        }

        public void setFilterTo(IServer targetServer, String jobName, IJobManager jobManager) {
            this.forServer = targetServer;
            this.forJob = jobName;
            this.withJobManager = jobManager;
            this.isFiltered = true;
        }

        public void removeFilter() {
            this.isFiltered = false;
        }

        public void refreshLogs(IProgressMonitor monitor) {
            this.logList = this.isFiltered ? JobLogHelper.getAllLogs((IServer)this.forServer, (String)this.forJob, (IJobManager)this.withJobManager, (IProgressMonitor)monitor) : JobLogHelper.getAllLogs((IProgressMonitor)monitor);
        }
    }

    private final class JobLogLabelProvider
    implements ITableLabelProvider {
        private JobLogLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            JobLog log = (JobLog)element;
            switch (columnIndex) {
                case 0: {
                    return log.getJobInstance().getJobName();
                }
                case 1: {
                    return String.valueOf(log.getJobInstance().getId());
                }
                case 2: {
                    return String.valueOf(log.getJobExecution().getId());
                }
                case 3: {
                    return log.getJobExecution().getExitStatus();
                }
                case 4: {
                    return log.getJobExecution().getEndTime();
                }
                case 5: {
                    return log.getTargetServer().getName();
                }
            }
            return null;
        }
    }

    private final class JobLogComparator
    extends ViewerComparator {
        private JobLogComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            JobLog log1 = (JobLog)e1;
            JobLog log2 = (JobLog)e2;
            int comparison = log1.getTargetServer().getId().toUpperCase().compareTo(log2.getTargetServer().getId().toUpperCase());
            if (comparison == 0 && (comparison = log1.getJobInstance().getJobName().toUpperCase().compareTo(log2.getJobInstance().getJobName().toUpperCase())) == 0 && (comparison = (int)(log1.getJobInstance().getId() - log2.getJobInstance().getId())) == 0) {
                comparison = (int)(log1.getJobExecution().getId() - log2.getJobExecution().getId());
            }
            return comparison;
        }
    }

    private class JobLogRefreshAction
    extends Action {
        public JobLogRefreshAction() {
            super(Messages.jobLogRefreshAction, null);
        }

        public void run() {
            super.run();
            JobLogViewPart.this.refreshView();
        }
    }

    private class JobLogShowAllAction
    extends Action {
        public JobLogShowAllAction() {
            super(Messages.jobLogShowAllLogsAction, null);
        }

        public void run() {
            super.run();
            JobLogViewPart.this.showAllLogs();
        }
    }

    private final class JobLogChangeAdapter
    extends JobChangeAdapter {
        private JobLogChangeAdapter() {
        }

        public void done(IJobChangeEvent event) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    JobLogViewPart.this.viewer.refresh();
                }
            });
            event.getJob().removeJobChangeListener((IJobChangeListener)this);
            JobLogViewPart.this.lastEclipseJob = null;
        }
    }
}

