/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.batch.ui.internal.launch;

import com.ibm.jee.batch.core.internal.BatchFilesUtil;
import com.ibm.jee.batch.core.internal.JSLParsingUtils;
import com.ibm.ws.st.jee.batch.core.internal.launch.util.BatchJobConfigurationHelper;
import com.ibm.ws.st.jee.batch.core.internal.launch.util.JobLaunchUtil;
import com.ibm.ws.st.jee.batch.ui.STBatchUIPlugin;
import com.ibm.ws.st.jee.batch.ui.internal.launch.Messages;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.xml.sax.SAXException;

public class JobLaunchTab
extends AbstractLaunchConfigurationTab {
    private Map<IProject, IFile[]> batchMap = null;
    private Text projectTextField;
    private Text jobTextField;
    private Combo serverCombo;
    private Label userIDLabel;
    private Text userIdText;
    private Label passwordLabel;
    private Text passwordText;
    private TableViewer viewer;
    private boolean isUpdating;
    private BatchJobConfigurationHelper jobConfiguration;
    private boolean launchTabEntriesValid;
    private Map<String, String> jobParameters = new LinkedHashMap<String, String>();
    private Set<String> jslJobParameters = new TreeSet<String>();
    private Button editButton;
    private Button addButton;
    private Button removeButton;

    public Image getImage() {
        return STBatchUIPlugin.getImageDescriptor("icons/obj16/jobnode.png").createImage();
    }

    public String getName() {
        return Messages.batchJob_tabName;
    }

    public void createControl(Composite arg0) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(arg0, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        Point minSize = composite.computeSize(0, 350);
        composite.setSize(minSize);
        if (composite.getParent() instanceof ScrolledComposite) {
            ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
            sc1.setMinSize(minSize);
            sc1.setExpandHorizontal(true);
            sc1.setExpandVertical(true);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createBrowseJobControl(composite);
        this.createServerControl(composite);
        this.createSecuritySectionControl(composite);
        this.createJobParametersList(composite);
        this.setControl((Control)scrolledComposite);
    }

    protected void createBrowseJobControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.batchJob_section);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        group.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.batchJob_project);
        data = new GridData(4, 2, false, false);
        label.setLayoutData((Object)data);
        this.projectTextField = new Text((Composite)group, 2048);
        data = new GridData(4, 2, true, false);
        this.projectTextField.setLayoutData((Object)data);
        this.projectTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (JobLaunchTab.this.isUpdating) {
                    return;
                }
                JobLaunchTab.this.isUpdating = true;
                String projectName = JobLaunchTab.this.projectTextField.getText().trim();
                if (!projectName.isEmpty()) {
                    String jobText;
                    IProject project = JobLaunchTab.this.getProject(projectName);
                    JobLaunchTab.this.setProject(project);
                    if (project != null && !(jobText = JobLaunchTab.this.jobTextField.getText().trim()).isEmpty()) {
                        IFile jobFile = JobLaunchTab.this.getJobFile(jobText, project);
                        JobLaunchTab.this.setJobFile(jobFile);
                    }
                } else {
                    JobLaunchTab.this.setProject(null);
                }
                JobLaunchTab.this.validateEntries();
                JobLaunchTab.this.isUpdating = false;
            }
        });
        Button projectBrowseButton = SWTUtil.createButton((Composite)group, (String)Messages.batchJob_browseProject);
        label = new Label((Composite)group, 0);
        label.setText(Messages.batchJob_jobFile);
        data = new GridData(4, 2, false, false);
        label.setLayoutData((Object)data);
        this.jobTextField = new Text((Composite)group, 2048);
        data = new GridData(4, 2, true, false);
        this.jobTextField.setLayoutData((Object)data);
        this.jobTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (JobLaunchTab.this.isUpdating) {
                    return;
                }
                JobLaunchTab.this.isUpdating = true;
                String jobFileName = JobLaunchTab.this.jobTextField.getText().trim();
                if (!jobFileName.isEmpty()) {
                    IFile jobFile = JobLaunchTab.this.getJobFile(jobFileName, JobLaunchTab.this.jobConfiguration.getProject());
                    JobLaunchTab.this.setJobFile(jobFile);
                } else {
                    JobLaunchTab.this.setJobFile(null);
                }
                JobLaunchTab.this.validateEntries();
                JobLaunchTab.this.isUpdating = false;
            }
        });
        Button jobSearchButton = SWTUtil.createButton((Composite)group, (String)Messages.batchJob_searchJobFile);
        projectBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objects;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(JobLaunchTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                dialog.setTitle(Messages.batchJob_projectBrowseTitle);
                dialog.setMessage(Messages.batchJob_projectBrowseDescription);
                dialog.setEmptyListMessage(Messages.batchJob_projectBrowseEmptyList);
                dialog.setElements((Object[])JobLaunchTab.this.getBatchProjects());
                if (dialog.open() == 0 && (objects = dialog.getResult()).length == 1 && objects[0] instanceof IProject) {
                    String jobText;
                    IProject project = (IProject)objects[0];
                    JobLaunchTab.this.isUpdating = true;
                    JobLaunchTab.this.projectTextField.setText(project.getName());
                    JobLaunchTab.this.setProject(project);
                    if (project != null && !(jobText = JobLaunchTab.this.jobTextField.getText().trim()).isEmpty()) {
                        IFile jobFile = JobLaunchTab.this.getJobFile(jobText, project);
                        JobLaunchTab.this.setJobFile(jobFile);
                    }
                    JobLaunchTab.this.validateEntries();
                    JobLaunchTab.this.isUpdating = false;
                }
            }
        });
        jobSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] objects;
                IProject project = JobLaunchTab.this.jobConfiguration.getProject();
                Object[] jobFiles = null;
                jobFiles = project != null ? JobLaunchTab.this.getJobFiles(project) : JobLaunchTab.this.getAllJobFiles();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(JobLaunchTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                dialog.setTitle(Messages.batchJob_searchJobFileTitle);
                dialog.setMessage(Messages.batchJob_searchJobFileDescription);
                dialog.setEmptyListMessage(Messages.batchJob_searchJobFileEmptyList);
                dialog.setElements(jobFiles);
                if (dialog.open() == 0 && (objects = dialog.getResult()).length == 1 && objects[0] instanceof IFile) {
                    IFile jobFile = (IFile)objects[0];
                    JobLaunchTab.this.isUpdating = true;
                    JobLaunchTab.this.jobTextField.setText(jobFile.getName());
                    JobLaunchTab.this.jobTextField.setToolTipText(jobFile.getFullPath().toString());
                    JobLaunchTab.this.setJobFile(jobFile);
                    JobLaunchTab.this.validateEntries();
                    JobLaunchTab.this.isUpdating = false;
                }
            }
        });
    }

    protected void setProject(IProject project) {
        IFile[] jobFiles;
        this.jobConfiguration.setProject(project);
        if (project != null && this.jobTextField.getText().trim().isEmpty() && (jobFiles = this.getJobFiles(project)).length == 1) {
            this.setJobFile(jobFiles[0]);
            this.jobTextField.setText(jobFiles[0].getName());
            this.jobTextField.setToolTipText(jobFiles[0].getFullPath().toString());
        }
    }

    protected void setJobFile(IFile jobFile) {
        this.jobConfiguration.setJobFile(jobFile);
        if (jobFile != null) {
            this.jobConfiguration.setProject(jobFile.getProject());
            if (this.projectTextField.getText().trim().isEmpty()) {
                this.projectTextField.setText(jobFile.getProject().getName());
            }
        }
    }

    protected void createServerControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.targetServer_label);
        this.serverCombo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 150;
        this.serverCombo.setLayoutData((Object)data);
        this.serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JobLaunchTab.this.jobConfiguration.setServerId(JobLaunchTab.this.serverCombo.getText());
                JobLaunchTab.this.validateEntries();
            }
        });
        Button newServerButton = SWTUtil.createButton((Composite)parent, (String)Messages.newServer_button);
        newServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServerUIUtil.showNewServerWizard((Shell)JobLaunchTab.this.getShell(), (String)"com.ibm.jee.batch", null, null)) {
                    JobLaunchTab.this.refreshServerList();
                }
            }
        });
    }

    protected void createSecuritySectionControl(Composite parent) {
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.userIDLabel = new Label(parent, 0);
        this.userIDLabel.setText(Messages.targetServerSecurityUser);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalIndent = 20;
        this.userIDLabel.setLayoutData((Object)data);
        this.userIdText = new Text(parent, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.userIdText.setLayoutData((Object)data);
        this.userIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobLaunchTab.this.jobConfiguration.setUserId(JobLaunchTab.this.userIdText.getText());
                JobLaunchTab.this.validateEntries();
            }
        });
        this.passwordLabel = new Label(parent, 0);
        this.passwordLabel.setText(Messages.targetServerSecurityPassword);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalIndent = 20;
        this.passwordLabel.setLayoutData((Object)data);
        this.passwordText = new Text(parent, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.passwordText.setEchoChar('*');
        this.passwordText.setLayoutData((Object)data);
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobLaunchTab.this.jobConfiguration.setPassword(JobLaunchTab.this.passwordText.getText());
                JobLaunchTab.this.validateEntries();
            }
        });
    }

    private void createJobParametersList(Composite parent) {
        TableViewerColumn column;
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        GridLayout gridLayout = new GridLayout(3, false);
        Group group = new Group(parent, 0);
        group.setText(Messages.propertiesSection);
        group.setLayoutData((Object)data);
        group.setLayout((Layout)gridLayout);
        this.viewer = new TableViewer((Composite)group, 66306);
        TableViewerColumn imageColumn = column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.propertiesPropLabel);
        column.getColumn().setWidth(150);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        column = new TableViewerColumn(this.viewer, 0);
        column.getColumn().setText(Messages.propertiesPropValue);
        column.getColumn().setWidth(200);
        column.getColumn().setResizable(true);
        column.getColumn().setMoveable(false);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setEnabled(true);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobLaunchTab.this.updateJobParametersTableButtons();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        imageColumn.setLabelProvider((CellLabelProvider)new JobParamsWarningLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 2;
        gd2.heightHint = 200;
        this.viewer.getTable().setLayoutData((Object)gd2);
        Composite buttons = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(1, false);
        buttons.setLayout((Layout)gridLayout);
        data = new GridData();
        data.verticalAlignment = 128;
        buttons.setLayoutData((Object)data);
        this.addButton = new Button(buttons, 0);
        this.addButton.setText(Messages.add);
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddEditPropertyDialog dlg = new AddEditPropertyDialog(JobLaunchTab.this.getShell());
                dlg.setTitle(Messages.addParameterDialogTitle);
                if (dlg.open() == 0) {
                    String name = dlg.getPropertyName();
                    String value = dlg.getPropertyValue();
                    if (name != null && name.length() > 0 && value != null && value.length() > 0) {
                        LinkedHashMap<String, String> newEntries = new LinkedHashMap<String, String>(JobLaunchTab.this.getModel());
                        newEntries.put(name, value);
                        JobLaunchTab.this.setModel(newEntries);
                        JobLaunchTab.this.jobConfiguration.setJobParameters(JobLaunchTab.this.getModel());
                        JobLaunchTab.this.viewer.refresh();
                        JobLaunchTab.this.updateJobParametersTableButtons();
                        JobLaunchTab.this.validateEntries();
                    }
                }
            }
        });
        this.editButton = new Button(buttons, 0);
        this.editButton.setText(Messages.edit);
        this.editButton.setLayoutData((Object)new GridData(768));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = JobLaunchTab.this.viewer.getSelection();
                if (!sel.isEmpty()) {
                    StructuredSelection sSel = (StructuredSelection)sel;
                    Map.Entry entry = (Map.Entry)sSel.getFirstElement();
                    AddEditPropertyDialog dlg = new AddEditPropertyDialog(JobLaunchTab.this.getShell());
                    dlg.setTitle(Messages.editParameterDialogTitle);
                    dlg.setPropertyName((String)entry.getKey());
                    dlg.setPropertyValue((String)entry.getValue());
                    if (dlg.open() == 0) {
                        String name = dlg.getPropertyName();
                        String value = dlg.getPropertyValue();
                        LinkedHashMap<String, String> newEntries = new LinkedHashMap<String, String>(JobLaunchTab.this.getModel());
                        if (!entry.getKey().equals(name)) {
                            newEntries.remove(entry.getKey());
                        }
                        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
                            newEntries.put(name, value);
                            JobLaunchTab.this.setModel(newEntries);
                            JobLaunchTab.this.jobConfiguration.setJobParameters(JobLaunchTab.this.getModel());
                            JobLaunchTab.this.viewer.refresh();
                            JobLaunchTab.this.updateJobParametersTableButtons();
                            JobLaunchTab.this.validateEntries();
                        }
                    }
                }
            }
        });
        this.removeButton = new Button(buttons, 0);
        this.removeButton.setText(Messages.remove);
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection sel = JobLaunchTab.this.viewer.getSelection();
                if (!sel.isEmpty()) {
                    StructuredSelection sSel = (StructuredSelection)sel;
                    Map.Entry entry = (Map.Entry)sSel.getFirstElement();
                    LinkedHashMap newEntries = new LinkedHashMap(JobLaunchTab.this.getModel());
                    newEntries.remove(entry.getKey());
                    JobLaunchTab.this.setModel(newEntries);
                    JobLaunchTab.this.jobConfiguration.setJobParameters(JobLaunchTab.this.getModel());
                    JobLaunchTab.this.viewer.refresh();
                    JobLaunchTab.this.updateJobParametersTableButtons();
                    JobLaunchTab.this.validateEntries();
                }
            }
        });
        this.updateJobParametersTableButtons();
    }

    private Map<IProject, IFile[]> getBatchMap() {
        if (this.batchMap == null) {
            IProject[] projects;
            this.batchMap = new HashMap<IProject, IFile[]>();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            for (IProject project : projects = workspaceRoot.getProjects()) {
                try {
                    if (!project.isAccessible() || !FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"com.ibm.jee.batch")) continue;
                    this.batchMap.put(project, null);
                }
                catch (CoreException ce) {
                    STBatchUIPlugin.logWarning("Check for batch facet failed for project: " + project.getName(), ce);
                }
            }
        }
        return this.batchMap;
    }

    private IProject[] getBatchProjects() {
        Set<IProject> projects = this.getBatchMap().keySet();
        IProject[] projectArray = projects.toArray(new IProject[projects.size()]);
        Arrays.sort(projectArray, new Comparator<IProject>(){

            @Override
            public int compare(IProject p1, IProject p2) {
                String n1 = p1.getName();
                String n2 = p2.getName();
                return n1.compareTo(n2);
            }
        });
        return projectArray;
    }

    private IProject getProject(String projectName) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectName);
        if (project != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    private IFile[] getJobFiles(IProject project) {
        Map<IProject, IFile[]> map = this.getBatchMap();
        IFile[] files = map.get(project);
        if (files == null) {
            files = BatchFilesUtil.getJSLFiles((IProject[])new IProject[]{project});
            this.sortFiles(files);
            map.put(project, files);
        }
        return files;
    }

    private IFile[] getAllJobFiles() {
        Set<IProject> projects = this.getBatchMap().keySet();
        IProject[] projectArray = projects.toArray(new IProject[projects.size()]);
        IFile[] jobFiles = BatchFilesUtil.getJSLFiles((IProject[])projectArray);
        this.sortFiles(jobFiles);
        return jobFiles;
    }

    private IFile getJobFile(String fileName, IProject project) {
        IFile[] jobFiles = null;
        jobFiles = project == null ? this.getAllJobFiles() : this.getJobFiles(project);
        for (IFile jobFile : jobFiles) {
            if (jobFile.getName().equals(fileName)) {
                return jobFile;
            }
            Path filePath = new Path(fileName);
            if (!jobFile.getLocation().equals((Object)filePath)) continue;
            return jobFile;
        }
        Path jobFilePath = new Path(BatchJobConfigurationHelper.getSubstitutedString((String)fileName));
        IFile jobFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)jobFilePath);
        if (jobFile != null) {
            return jobFile;
        }
        return null;
    }

    private void sortFiles(IFile[] files) {
        Arrays.sort(files, new Comparator<IFile>(){

            @Override
            public int compare(IFile f1, IFile f2) {
                String n1 = f1.getName();
                String n2 = f2.getName();
                return n1.compareTo(n2);
            }
        });
    }

    private void updateJobParametersTableButtons() {
        this.editButton.setEnabled(!this.viewer.getSelection().isEmpty());
        this.removeButton.setEnabled(!this.viewer.getSelection().isEmpty());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isUpdating = true;
        this.jobConfiguration = new BatchJobConfigurationHelper(configuration);
        IFile jobFile = this.jobConfiguration.getJobIFile();
        if (jobFile != null) {
            this.projectTextField.setText(jobFile.getProject().getName());
            this.jobTextField.setText(jobFile.getName());
        } else {
            this.projectTextField.setText(this.jobConfiguration.getProjectName());
            this.jobTextField.setText(this.jobConfiguration.getJobFileName());
        }
        this.setMessage(null);
        this.refreshServerList();
        if (this.userIdText != null) {
            this.userIdText.setText(this.jobConfiguration.getUserId());
        }
        if (this.passwordText != null) {
            this.passwordText.setText(this.jobConfiguration.getPassword());
        }
        if (this.viewer != null) {
            this.refreshJSLJobParameters();
            this.setModel(this.jobConfiguration.getJobParameters());
            this.viewer.setInput(this.getModel());
        }
        this.isUpdating = false;
        this.validateEntries();
    }

    private void refreshJSLJobParameters() {
        IFile job = this.jobConfiguration.getJobIFile();
        if (this.jobConfiguration.jobFileExists() && job != null) {
            try {
                this.jslJobParameters = JSLParsingUtils.getParams((String)job.getLocation().toOSString());
            }
            catch (FileNotFoundException e) {
                this.jslJobParameters = new TreeSet<String>();
                STBatchUIPlugin.logError(e);
            }
            catch (SAXException e) {
                STBatchUIPlugin.logError(e);
            }
            catch (IOException e) {
                STBatchUIPlugin.logError(e);
            }
            catch (ParserConfigurationException e) {
                STBatchUIPlugin.logError(e);
            }
        } else {
            this.jslJobParameters = new TreeSet<String>();
        }
    }

    private void refreshServerList() {
        String serverId = this.jobConfiguration.getServerId();
        if (this.serverCombo != null) {
            IServer[] serverList = JobLaunchUtil.getBatchEnabledServers();
            this.serverCombo.removeAll();
            for (IServer batchServer : serverList) {
                this.serverCombo.add(batchServer.getName());
                if (serverId == null || !serverId.equals(batchServer.getName())) continue;
                this.serverCombo.select(this.serverCombo.getItemCount() - 1);
            }
            if (this.serverCombo.getItemCount() > 0 && this.serverCombo.getSelectionIndex() < 1) {
                this.serverCombo.select(0);
                this.jobConfiguration.setServerId(this.serverCombo.getText());
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.jobConfiguration.fillOutWorkingCopy(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy arg0) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.launchTabEntriesValid;
    }

    protected void validateEntries() {
        this.launchTabEntriesValid = true;
        IProject project = this.jobConfiguration.getProject();
        IFile jobFile = this.jobConfiguration.getJobIFile();
        String projectText = this.projectTextField.getText().trim();
        String jobText = this.jobTextField.getText().trim();
        if (this.launchTabEntriesValid && project == null && !projectText.isEmpty()) {
            this.setErrorMessage(Messages.errorValidationProjectInvalid);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && jobFile == null) {
            if (jobText.isEmpty()) {
                this.setErrorMessage(Messages.errorValidationJobFileNeeded);
            } else if (project != null) {
                this.setErrorMessage(NLS.bind((String)Messages.errorValidationJobFileNotFoundInProject, (Object[])new String[]{jobText, project.getName()}));
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.errorValidationJobFileNotFound, (Object)jobText));
            }
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && !this.jobConfiguration.jobFileExists()) {
            this.setErrorMessage(Messages.errorValidationJobFileNotExist);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && !BatchFilesUtil.isJSLFile((IFile)jobFile)) {
            this.setErrorMessage(Messages.errorValidationJobFileNotJSL);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && (this.jobConfiguration.getServerId() == null || this.jobConfiguration.getServerId().isEmpty())) {
            this.setErrorMessage(Messages.errorValidationServer);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && !this.jobConfiguration.isSelectedServerStarted()) {
            this.setErrorMessage(Messages.errorValidationServerNotStarted);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && !this.jobConfiguration.selectedServerHasApps()) {
            this.setErrorMessage(Messages.errorValidationServerHasNoApps);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && !this.jobConfiguration.jobFilePublished()) {
            String batch = this.jobConfiguration.getProjectName();
            this.setErrorMessage(NLS.bind((String)Messages.errorValidationServerAppNotPackaged, (Object)batch));
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && (this.jobConfiguration.getUserId() == null || this.jobConfiguration.getUserId().isEmpty())) {
            this.setErrorMessage(Messages.errorValidationUserID);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid && (this.jobConfiguration.getPassword() == null || this.jobConfiguration.getPassword().isEmpty())) {
            this.setErrorMessage(Messages.errorValidationPassword);
            this.launchTabEntriesValid = false;
        }
        if (this.launchTabEntriesValid) {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    private Map<String, String> getModel() {
        return Collections.unmodifiableMap(this.jobParameters);
    }

    private void setModel(Map<String, String> model) {
        this.jobParameters = model;
    }

    private class PropertiesContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Map map = JobLaunchTab.this.getModel();
            return map.entrySet().toArray();
        }
    }

    private class PropertiesLabelProvider
    implements ITableLabelProvider {
        private PropertiesLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return (String)entry.getValue();
                }
            }
            return null;
        }
    }

    private class JobParamsWarningLabelProvider
    extends ColumnLabelProvider {
        private JobParamsWarningLabelProvider() {
        }

        public String getText(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return (String)entry.getKey();
        }

        public Image getImage(Object element) {
            if (!this.isJobParamInJsl(element)) {
                return STBatchUIPlugin.getImageDescriptor("icons/obj16/exception.gif").createImage();
            }
            return null;
        }

        public String getToolTipText(Object element) {
            if (!this.isJobParamInJsl(element)) {
                return Messages.jobParameterToolTip;
            }
            return null;
        }

        private boolean isJobParamInJsl(Object element) {
            Map.Entry entry = (Map.Entry)element;
            String key = (String)entry.getKey();
            return JobLaunchTab.this.jslJobParameters.contains(key);
        }
    }

    private class AddEditPropertyDialog
    extends Dialog
    implements ModifyListener {
        private String title;
        private Combo comboPropName;
        private Text txtPropValue;
        private Label lblPropName;
        private Label lblPropValue;
        private String propertyName;
        private String propertyValue;

        protected AddEditPropertyDialog(Shell parentShell) {
            super(parentShell);
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (this.title != null) {
                newShell.setText(this.title);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            comp.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            comp.setLayoutData((Object)data);
            this.lblPropName = new Label(comp, 0);
            this.lblPropName.setText(Messages.parameterName);
            this.comboPropName = new Combo(comp, 4);
            data = new GridData(768);
            this.comboPropName.setLayoutData((Object)data);
            this.comboPropName.addModifyListener((ModifyListener)this);
            TreeSet jobParams = new TreeSet(JobLaunchTab.this.jslJobParameters);
            jobParams.removeAll(JobLaunchTab.this.jobParameters.keySet());
            for (String i : jobParams) {
                this.comboPropName.add(i);
            }
            this.lblPropValue = new Label(comp, 0);
            this.lblPropValue.setText(Messages.parameterValue);
            this.txtPropValue = new Text(comp, 2048);
            data = new GridData(768);
            this.txtPropValue.setLayoutData((Object)data);
            this.txtPropValue.addModifyListener((ModifyListener)this);
            if (this.propertyName != null) {
                this.comboPropName.setText(this.propertyName);
            }
            if (this.propertyValue != null) {
                this.txtPropValue.setText(this.propertyValue);
            }
            return comp;
        }

        private void updateOKEnablement() {
            Button ok = this.getButton(0);
            if (ok != null) {
                ok.setEnabled(this.comboPropName.getText().length() > 0 && this.txtPropValue.getText().length() > 0);
            }
        }

        protected void okPressed() {
            String name = this.comboPropName.getText();
            String value = this.txtPropValue.getText();
            if (name != null && name.length() > 0) {
                this.setPropertyName(name);
            }
            if (value != null && value.length() > 0) {
                this.setPropertyValue(value);
            }
            super.okPressed();
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public void modifyText(ModifyEvent arg0) {
            this.updateOKEnablement();
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.updateOKEnablement();
            return control;
        }
    }
}

