/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.batch.ui.internal.launch;

import com.ibm.ws.st.jee.batch.core.internal.launch.util.BatchJobConfigurationHelper;
import com.ibm.ws.st.jee.batch.core.internal.launch.util.JobLaunchUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class JobLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        if (selection == null || mode == null || mode.isEmpty()) {
            return;
        }
        IFile jobFile = this.getJobFileFromSelection(selection);
        if (jobFile != null) {
            this.fillOutLauncher(jobFile, mode);
        }
    }

    private void fillOutLauncher(IFile jobFile, String mode) {
        ILaunchConfiguration launch = JobLaunchUtil.getExistingLaunchConfiguration((IFile)jobFile);
        if (launch == null) {
            BatchJobConfigurationHelper jobConfiguration = new BatchJobConfigurationHelper(jobFile);
            launch = jobConfiguration.saveToNewWorkingCopy();
        }
        String groupId = DebugUITools.getLaunchGroup((ILaunchConfiguration)launch, (String)mode).getIdentifier();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)shell, (IStructuredSelection)new StructuredSelection((Object)launch), (String)groupId);
    }

    private IFile getJobFileFromSelection(ISelection selection) {
        IFile jobFile = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection theSelection = (IStructuredSelection)selection;
            Object object = null;
            if (theSelection != null && !theSelection.isEmpty()) {
                object = theSelection.getFirstElement();
            }
            if (object != null && object instanceof IFile && (jobFile = (IFile)object) != null && !jobFile.exists()) {
                return null;
            }
        }
        return jobFile;
    }

    public void launch(IEditorPart editor, String mode) {
        if (editor == null || mode == null || mode.isEmpty()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        IFile jobFile = null;
        if (input instanceof IFileEditorInput && (jobFile = ((IFileEditorInput)input).getFile()) != null) {
            this.fillOutLauncher(jobFile, mode);
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection arg0) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart arg0) {
        return null;
    }

    public IResource getLaunchableResource(ISelection arg0) {
        return null;
    }

    public IResource getLaunchableResource(IEditorPart arg0) {
        return null;
    }
}

