/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.batch.ui.internal.launch;

import com.ibm.ws.st.jee.batch.core.internal.launch.util.BatchJobConfigurationHelper;
import com.ibm.ws.st.jee.batch.core.internal.wlp.util.LibertyServerUtil;
import com.ibm.ws.st.jee.batch.jobs.IJobManager;
import com.ibm.ws.st.jee.batch.jobs.JobException;
import com.ibm.ws.st.jee.batch.jobs.JobManagerFactory;
import com.ibm.ws.st.jee.batch.jobs.model.JobExecution;
import com.ibm.ws.st.jee.batch.jobs.model.JobInstance;
import com.ibm.ws.st.jee.batch.ui.STBatchUIPlugin;
import com.ibm.ws.st.jee.batch.ui.internal.launch.Messages;
import com.ibm.ws.st.jee.batch.ui.internal.views.JobLogViewPart;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.osgi.service.prefs.BackingStoreException;

public class JobLaunchConfiguration
extends AbstractJavaLaunchConfigurationDelegate {
    private static final String OPEN_LOG_VIEW_TOGGLE = "com.ibm.ws.st.jee.batch.ui.openLogView";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        BatchJobConfigurationHelper jobConfiguration = new BatchJobConfigurationHelper(configuration);
        IServer targetServer = jobConfiguration.getServerInstance();
        if (targetServer == null) {
            return;
        }
        String host = targetServer.getHost();
        String userID = jobConfiguration.getUserId();
        String password = jobConfiguration.getPassword();
        String trustStoreFile = null;
        String port = LibertyServerUtil.getHTTPSPort((IServer)targetServer);
        IJobManager jobManager = JobManagerFactory.createJobManager((String)"https", (String)host, (String)port, (String)userID, (String)password, trustStoreFile);
        LibertyServerUtil.BatchApp app = jobConfiguration.getCurrentBatchApp();
        String jobName = jobConfiguration.getJobID();
        this.validateJobConfiguration(jobConfiguration);
        Map parameters = jobConfiguration.getJobParameters();
        Properties jobProperties = null;
        if (parameters != null && parameters.size() > 0) {
            jobProperties = new Properties();
            for (String key : parameters.keySet()) {
                jobProperties.put(key, parameters.get(key));
            }
        }
        JobInstance job = null;
        try {
            job = jobManager.submitJob(app, jobName, jobProperties);
        }
        catch (Exception e) {
            String topLevelMessage = NLS.bind((String)Messages.errorJobSubmissionExceptionMessage, (Object)jobName, (Object)jobConfiguration.getServerId());
            IStatus st = null;
            if (e instanceof JobException) {
                IStatus serverStatus = ((JobException)e).getServerStatus();
                if (serverStatus != null) {
                    MultiStatus parentStatus = new MultiStatus("com.ibm.ws.st.jee.batch.ui", 4, topLevelMessage, (Throwable)e);
                    MultiStatus additionalInfoStatus = new MultiStatus("com.ibm.ws.st.jee.batch.ui", 4, new IStatus[]{serverStatus}, Messages.errorJobAdditionalInfoFromServer, null);
                    parentStatus.add((IStatus)additionalInfoStatus);
                    st = parentStatus;
                } else {
                    st = STBatchUIPlugin.createStatus(4, topLevelMessage, e);
                }
            } else {
                st = STBatchUIPlugin.createStatus(4, topLevelMessage, e);
            }
            throw new CoreException(st);
        }
        if (job == null) {
            String topLevelMessage = NLS.bind((String)Messages.errorJobSubmissionMessage, (Object)jobName, (Object)jobConfiguration.getServerId());
            IStatus st = STBatchUIPlugin.createStatus(4, topLevelMessage);
            throw new CoreException(st);
        }
        this.displayJobResults(job, jobManager, targetServer);
    }

    private void displayJobResults(final JobInstance job, final IJobManager jobManager, final IServer server) {
        StringBuilder bld = new StringBuilder();
        bld.append(NLS.bind((String)Messages.jobSubmissionDescription, (Object)job.getJobName(), (Object)job.getId()));
        bld.append(Messages.jobSubmissionDetails);
        List executions = job.getJobExecutions();
        if (executions.size() == 0) {
            bld.append(Messages.jobSubmissionDetailsNotAvailable);
        } else {
            for (JobExecution execution : executions) {
                bld.append(NLS.bind((String)Messages.jobSubmissionExecution, (Object)execution.getId()));
                bld.append(NLS.bind((String)Messages.jobSubmissionBatchStatus, (Object)execution.getBatchStatus()));
                bld.append(NLS.bind((String)Messages.jobSubmissionExitStatus, (Object)execution.getExitStatus()));
                bld.append(NLS.bind((String)Messages.jobSubmissionCreateTime, (Object)execution.getCreateTime()));
                bld.append(NLS.bind((String)Messages.jobSubmissionEndTime, (Object)execution.getEndTime()));
                bld.append(NLS.bind((String)Messages.jobSubmissionLastUpdateTime, (Object)execution.getLastUpdatedTime()));
                bld.append(NLS.bind((String)Messages.jobSubmissionStartTime, (Object)execution.getStartTime()));
            }
        }
        final String message = bld.toString();
        final String title = NLS.bind((String)Messages.jobSubmissionLabel, (Object)job.getJobName());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage wpage;
                IWorkbenchWindow wwin;
                IWorkbench wb = PlatformUI.getWorkbench();
                IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.ibm.ws.st.jee.batch.ui");
                boolean showLogView = preferences.getBoolean(JobLaunchConfiguration.OPEN_LOG_VIEW_TOGGLE, true);
                MessageDialogWithToggle msg = MessageDialogWithToggle.openInformation((Shell)wb.getDisplay().getActiveShell(), (String)title, (String)message, (String)Messages.jobSubmissionOpenLogView, (boolean)showLogView, null, null);
                boolean toggleValue = msg.getToggleState();
                if (toggleValue != showLogView) {
                    preferences.putBoolean(JobLaunchConfiguration.OPEN_LOG_VIEW_TOGGLE, toggleValue);
                    try {
                        preferences.flush();
                    }
                    catch (BackingStoreException e) {
                        STBatchUIPlugin.logError(e);
                    }
                }
                if (toggleValue && (wwin = wb.getActiveWorkbenchWindow()) != null && (wpage = wb.getActiveWorkbenchWindow().getActivePage()) != null) {
                    IViewPart batchLogView = wpage.findView("com.ibm.ws.st.jee.batch.ui.joblogs.view");
                    if (batchLogView == null) {
                        try {
                            batchLogView = wpage.showView("com.ibm.ws.st.jee.batch.ui.joblogs.view");
                        }
                        catch (PartInitException e1) {
                            STBatchUIPlugin.logError((CoreException)e1);
                        }
                    } else {
                        wpage.activate((IWorkbenchPart)batchLogView);
                    }
                    if (batchLogView != null && batchLogView instanceof JobLogViewPart) {
                        JobLogViewPart logView = (JobLogViewPart)batchLogView;
                        logView.showLogsFor(server, job.getJobName(), jobManager);
                    }
                }
            }
        });
    }

    private void validateJobConfiguration(BatchJobConfigurationHelper jobConfiguration) throws CoreException {
        IStatus st = null;
        if (!jobConfiguration.jobFileExists()) {
            String msg = Messages.errorJobSubmissionJobDoesNotExist;
            String project = jobConfiguration.getProjectName();
            String jobFileName = jobConfiguration.getJobID() + ".xml";
            st = STBatchUIPlugin.createStatus(4, NLS.bind((String)msg, (Object)jobFileName, (Object)project));
        }
        if (!jobConfiguration.jobFilePublished()) {
            String batch = jobConfiguration.getProjectName();
            st = STBatchUIPlugin.createStatus(4, NLS.bind((String)Messages.errorValidationServerAppNotPackaged, (Object)batch));
        }
        if (st != null) {
            throw new CoreException(st);
        }
    }
}

