/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.ui.wizards.servlet.pages;

import com.ibm.siptools.common.ui.SIPCommonUIPlugin;
import com.ibm.siptools.common.util.SipToolkitUtil;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.MultiSelectFilteredFileSelectionDialog;
import org.eclipse.jst.servlet.ui.internal.wizard.NewServletClassWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class NewSIPJavaClassWizardPage
extends NewServletClassWizardPage {
    private Text folderText;
    private Button folderButton;
    private Combo projectNameCombo;
    private String projectName;
    private Button existingClassButton;
    private Label existingClassLabel;
    private Text existingClassText;
    private Button existingButton;
    private static final String[] JSPEXTENSIONS = new String[]{"jsp"};

    public NewSIPJavaClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName, pageDesc, pageTitle, "jsr116.sip");
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                IFolder folder;
                IProject project;
                String projName = NewSIPJavaClassWizardPage.this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
                if (projName != null && projName.length() > 0) {
                    IProject containingProject = ProjectUtilities.getProject((Object)element);
                    return containingProject.getName().equals(projName);
                }
                if (element instanceof IProject) {
                    IProject project2 = (IProject)element;
                    return SipToolkitUtil.isSipProject((IProject)project2);
                }
                if (element instanceof IFolder && SipToolkitUtil.isSipProject((IProject)(project = (folder = (IFolder)element).getProject()))) {
                    return JemProjectUtilities.getSourceContainers((IProject)project).contains(folder);
                }
                return false;
            }
        };
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.addProjectNameGroup(composite);
        this.addFolderGroup(composite);
        this.addSeperator(composite, 3);
        this.addPackageGroup(composite);
        this.addClassnameGroup(composite);
        this.addSuperclassGroup(composite);
        this.addSeperator(composite, 3);
        this.createUseExistingGroup(composite);
        this.folderText.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getInfopopID());
        return composite;
    }

    private void addProjectNameGroup(Composite parent) {
        Label projectNameLabel = new Label(parent, 0);
        projectNameLabel.setText(J2EEUIMessages.getResourceString((String)"32"));
        GridData data = new GridData();
        projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(parent, 2056);
        data = new GridData(768);
        data.widthHint = 300;
        this.projectNameCombo.setLayoutData((Object)data);
        this.projectNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceFolder;
                super.widgetSelected(e);
                IProject newProject = ProjectUtilities.getProject((String)NewSIPJavaClassWizardPage.this.projectNameCombo.getText());
                if (NewSIPJavaClassWizardPage.this.folderText != null && (sourceFolder = NewSIPJavaClassWizardPage.this.getDefaultJavaSourceFolder(newProject).getFullPath().toOSString()) != null) {
                    NewSIPJavaClassWizardPage.this.folderText.setText(sourceFolder);
                }
                NewSIPJavaClassWizardPage.this.projectName = NewSIPJavaClassWizardPage.this.projectNameCombo.getText();
                if (NewSIPJavaClassWizardPage.this.projectName.length() > 0) {
                    NewSIPJavaClassWizardPage.this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)NewSIPJavaClassWizardPage.this.projectName);
                    NewSIPJavaClassWizardPage.this.model.setProperty("AddSIPServletDataModelProvider.SIP_PROJECT_NATURE", (Object)SipToolkitUtil.getSIPLevel((IProject)newProject));
                }
            }
        });
        new Label(parent, 0);
        this.synchHelper.synchCombo(this.projectNameCombo, "IArtifactEditOperationDataModelProperties.PROJECT_NAME", null);
        this.initializeProjectList();
        this.projectName = this.projectNameCombo.getText();
        if (this.projectName.length() > 0) {
            IProject newProject = ProjectUtilities.getProject((String)this.projectName);
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
            this.model.setProperty("AddSIPServletDataModelProvider.SIP_PROJECT_NATURE", (Object)SipToolkitUtil.getSIPLevel((IProject)newProject));
            String version = SipToolkitUtil.getSIPFacetVersion((IProject)newProject);
            this.model.setProperty("AddSIPServletDataModelProvider.SIP_PROJECT_VERSION", (Object)version);
        }
    }

    protected IFolder getDefaultJavaSourceFolder(IProject project) {
        if (project == null) {
            return null;
        }
        IPackageFragmentRoot[] sources = J2EEProjectUtilities.getSourceContainers((IProject)project);
        if (sources.length > 0) {
            try {
                return (IFolder)sources[0].getCorrespondingResource();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void initializeProjectList() {
        String[] names = new String[]{};
        IProject selectedProject = null;
        try {
            String projectNameFromModel;
            if (this.model != null && (projectNameFromModel = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME")) != null && projectNameFromModel.length() > 0) {
                selectedProject = ProjectUtilities.getProject((String)projectNameFromModel);
            }
        }
        catch (Exception e) {
            SIPCommonUIPlugin.getLocalLogger().info("Ignoring: " + e.getMessage());
        }
        try {
            if (selectedProject == null) {
                selectedProject = this.getSelectedProject();
            }
            if (selectedProject != null && selectedProject.isAccessible() && selectedProject.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                this.projectNameCombo.setText(selectedProject.getName());
                names = this.getFilteredProjects(SipToolkitUtil.getSIPLevel((IProject)selectedProject));
                this.projectNameCombo.setItems(names);
                this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)selectedProject.getName());
            }
        }
        catch (CoreException ce) {
            SIPCommonUIPlugin.getLocalLogger().info("Ignoring: " + ce.getMessage());
        }
        if (this.projectName == null && names.length > 0) {
            for (String currentNm : names) {
                if (!currentNm.equalsIgnoreCase(selectedProject.getName())) continue;
                this.projectName = currentNm;
                break;
            }
            if (this.projectName == null) {
                this.projectName = names[0];
            }
        }
        if ((this.projectNameCombo.getText() == null || this.projectNameCombo.getText().length() == 0) && this.projectName != null) {
            this.projectNameCombo.setText(this.projectName);
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)this.projectName);
        }
    }

    private String[] getFilteredProjects(String sipNature) {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < workspaceProjects.length; ++i) {
            IProject project = workspaceProjects[i];
            if (!project.isAccessible() || !SipToolkitUtil.isSipProject((IProject)project) || !SipToolkitUtil.getSIPLevel((IProject)project).equals(sipNature)) continue;
            items.add(project.getName());
        }
        if (items.isEmpty()) {
            return new String[0];
        }
        String[] names = items.toArray(new String[items.size()]);
        return names;
    }

    private void addFolderGroup(Composite composite) {
        Label folderLabel = new Label(composite, 16384);
        folderLabel.setText(J2EEUIMessages.FOLDER_LABEL);
        folderLabel.setLayoutData((Object)new GridData(256));
        this.folderText = new Text(composite, 2052);
        this.folderText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.folderText, "NewJavaClassDataModel.SOURCE_FOLDER", null);
        this.folderButton = new Button(composite, 8);
        this.folderButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.folderButton.setLayoutData((Object)new GridData(256));
        this.folderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSIPJavaClassWizardPage.this.handleFolderButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addPackageGroup(Composite composite) {
        this.packageLabel = new Label(composite, 16384);
        this.packageLabel.setText(J2EEUIMessages.JAVA_PACKAGE_LABEL);
        this.packageLabel.setLayoutData((Object)new GridData(256));
        this.packageText = new Text(composite, 2052);
        this.packageText.setLayoutData((Object)new GridData(768));
        IPackageFragment packageFragment = this.getSelectedPackageFragment();
        if (packageFragment != null && packageFragment.exists()) {
            this.projectNameCombo.setText(packageFragment.getElementName());
            this.model.setProperty("NewJavaClassDataModel.JAVA_PACKAGE", (Object)packageFragment.getElementName());
        }
        this.synchHelper.synchText(this.packageText, "NewJavaClassDataModel.JAVA_PACKAGE", null);
        this.packageButton = new Button(composite, 8);
        this.packageButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.packageButton.setLayoutData((Object)new GridData(256));
        this.packageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSIPJavaClassWizardPage.this.handlePackageButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addClassnameGroup(Composite composite) {
        this.classLabel = new Label(composite, 16384);
        this.classLabel.setText(J2EEUIMessages.CLASS_NAME_LABEL);
        this.classLabel.setLayoutData((Object)new GridData(256));
        this.classText = new Text(composite, 2052);
        this.classText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.classText, "NewJavaClassDataModel.CLASS_NAME", null);
        new Label(composite, 16384);
    }

    protected void addSeperator(Composite composite, int horSpan) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        Label seperator = new Label(composite, 258);
        data = new GridData(256);
        data.horizontalSpan = horSpan;
        seperator.setLayoutData((Object)data);
    }

    private void addSuperclassGroup(Composite composite) {
        this.superLabel = new Label(composite, 16384);
        this.superLabel.setText(J2EEUIMessages.SUPERCLASS_LABEL);
        this.superLabel.setLayoutData((Object)new GridData(256));
        this.superText = new Text(composite, 2052);
        this.superText.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchText(this.superText, "NewJavaClassDataModel.SUPERCLASS", null);
        this.superButton = new Button(composite, 8);
        this.superButton.setText(J2EEUIMessages.BROWSE_BUTTON_LABEL);
        this.superButton.setLayoutData((Object)new GridData(256));
        this.superButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewSIPJavaClassWizardPage.this.handleSuperButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public IProject getSelectedProject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection stucturedSelection = (IStructuredSelection)selection;
        if (stucturedSelection.getFirstElement() instanceof EObject) {
            return ProjectUtilities.getProject((Object)stucturedSelection.getFirstElement());
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null && element.getJavaProject() != null) {
            return element.getJavaProject().getProject();
        }
        return this.getExtendedSelectedProject(stucturedSelection.getFirstElement());
    }

    private IPackageFragment getSelectedPackageFragment() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        IJavaElement element = this.getInitialJavaElement(selection);
        if (element != null) {
            if (element.getElementType() == 4) {
                return (IPackageFragment)element;
            }
            if (element.getElementType() == 7) {
                return ((IType)element).getPackageFragment();
            }
        }
        return null;
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(IWebWizardConstants.USE_EXISTING_SERVLET_CLASS);
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, "NewServletClassDataModel.USE_EXISTING_CLASS", null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSIPJavaClassWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassLabel.setEnabled(false);
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.existingClassText.setEnabled(false);
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        this.existingClassButton.setEnabled(false);
        this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSIPJavaClassWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        if (!enable) {
            this.existingClassText.setText("");
        }
        this.existingClassLabel.setEnabled(enable);
        this.existingClassButton.setEnabled(enable);
        this.packageText.setEnabled(!enable);
        this.packageButton.setEnabled(!enable);
        this.packageLabel.setEnabled(!enable);
        this.classText.setEnabled(!enable);
        this.classText.setText("");
        this.classLabel.setEnabled(!enable);
        this.superText.setEnabled(!enable);
        this.superButton.setEnabled(!enable);
        this.superLabel.setEnabled(!enable);
    }

    protected void handleClassButtonSelected() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        MultiSelectFilteredFileSelectionDialog ms = new MultiSelectFilteredFileSelectionDialog(this.getShell(), IWebWizardConstants.NEW_SERVLET_WIZARD_WINDOW_TITLE, IWebWizardConstants.CHOOSE_SERVLET_CLASS, JSPEXTENSIONS, false, project);
        IContainer root = component.getRootFolder().getUnderlyingFolder();
        ms.setInput((Object)root);
        ms.open();
        if (ms.getReturnCode() == 0) {
            String qualifiedClassName = "";
            if (ms.getSelectedItem() == 0) {
                Object obj = ms.getFirstResult();
                if (obj != null && obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    IPath pFull = file.getFullPath();
                    IPath pBase = root.getFullPath();
                    IPath path = pFull.removeFirstSegments(pBase.segmentCount());
                    qualifiedClassName = path.makeAbsolute().toString();
                    this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(false));
                }
            } else {
                IType type = (IType)ms.getFirstResult();
                if (type != null) {
                    qualifiedClassName = type.getFullyQualifiedName();
                    this.model.setProperty("NewServletClassDataModel.IS_SERVLET_TYPE", (Object)new Boolean(true));
                }
            }
            this.existingClassText.setText(qualifiedClassName);
        }
        this.getControl().setCursor(null);
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        return super.getExtendedSelectedProject(selection);
    }
}

