/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.ui.wizards.servlet;

import com.ibm.siptools.common.datamodel.AddSIPServletDataModelProvider;
import com.ibm.siptools.common.plugin.ResourceHandler;
import com.ibm.siptools.common.plugin.SIPCommonConstants;
import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import com.ibm.siptools.common.ui.SIPCommonUIPlugin;
import com.ibm.siptools.common.ui.wizards.servlet.pages.AddSIPServletWizardPage;
import com.ibm.siptools.common.ui.wizards.servlet.pages.NewSIPJavaClassWizardPage;
import com.ibm.siptools.common.ui.wizards.servlet.pages.NewSIPServletOptionsPage;
import com.ibm.siptools.common.util.SipToolkitUtil;
import com.ibm.siptools.custom.TreeParent;
import com.ibm.siptools.editmodel.SipArtifactEdit;
import com.ibm.siptools.v11.model.providers.SIP11ModelProvider;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.servlet.ui.internal.wizard.AddServletWizard;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class SIPServletWizard
extends AddServletWizard {
    private static final String SIP_SERVLET_WIZARD_TITLE = ResourceHandler.getString((String)"SIP_SERVLET_WIZARD_TITLE");
    private static final String SIP_SERVLET_WIZARD_PAGE_TITLE = ResourceHandler.getString((String)"SIP_SERVLET_WIZARD_PAGE_TITLE");
    private static final String ADD_SERVLET_PAGE_NAME = "page1";
    private static final String CLASS_DESTINATION_PAGE_NAME = "page2";
    private static final String CLASS_OPTIONS_PAGE_NAME = "page3";
    private IDataModel model;
    private AddSIPServletDataModelProvider modelProvider;
    private IProject sipProject;
    private boolean useAnnotations = true;

    public SIPServletWizard(IProject sipProject, String componentName) {
        this.useAnnotations = false;
        this.model = this.getDataModel();
        if (sipProject != null) {
            this.model.setProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", (Object)sipProject.getName());
        }
        if (componentName != null && componentName.length() > 0) {
            this.model.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)componentName);
        } else {
            this.model.setProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", (Object)sipProject.getName());
        }
        this.sipProject = sipProject;
        this.init();
    }

    public SIPServletWizard(IDataModel model) {
        super(model);
        this.model = model;
        this.init();
    }

    public SIPServletWizard() {
        this.model = this.getDataModel();
        this.init();
    }

    private void init() {
        if (this.useAnnotations) {
            this.model.setBooleanProperty("IAnnotationsDataModel.useAnnotations", true);
        } else {
            this.model.setBooleanProperty("IAnnotationsDataModel.useAnnotations", false);
        }
        this.setWindowTitle(SIP_SERVLET_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(SIPCommonPlugin.getDefault().getImageDescriptor("sip_servlet"));
    }

    public void doAddPages() {
        NewSIPJavaClassWizardPage classDestinationPage = new NewSIPJavaClassWizardPage(this.model, CLASS_DESTINATION_PAGE_NAME, IWebWizardConstants.NEW_JAVA_CLASS_DESTINATION_WIZARD_PAGE_DESC, SIP_SERVLET_WIZARD_PAGE_TITLE);
        this.addPage((IWizardPage)classDestinationPage);
        AddSIPServletWizardPage servletPage = new AddSIPServletWizardPage(this.model, ADD_SERVLET_PAGE_NAME);
        this.addPage((IWizardPage)servletPage);
        NewSIPServletOptionsPage optionsPage = new NewSIPServletOptionsPage(this.model, CLASS_OPTIONS_PAGE_NAME, IWebWizardConstants.NEW_JAVA_CLASS_OPTIONS_WIZARD_PAGE_DESC, SIP_SERVLET_WIZARD_PAGE_TITLE);
        this.addPage((IWizardPage)optionsPage);
        servletPage.setInfopopID("com.ibm.siptools.doc.sipsrv1000");
        classDestinationPage.setInfopopID("com.ibm.siptools.doc.sipsrv1000");
        optionsPage.setInfopopID("com.ibm.siptools.doc.sipsrv1000");
    }

    protected boolean runForked() {
        return false;
    }

    public boolean canFinish() {
        try {
            Object servMappings = this.model.getProperty("AddSIPServletDataModel.SERVLETMAPPINGS");
            if (servMappings != null && servMappings instanceof Boolean && ((Boolean)servMappings).booleanValue()) {
                return false;
            }
            return super.canFinish();
        }
        catch (Exception e) {
            SIPCommonPlugin.ErrorMessage((String)("SIP11ServletWizard.canFinish unexpected Exception=" + e.getMessage()), (Exception)e);
            return false;
        }
    }

    protected IProject getDefaultSipProject() {
        IProject project = null;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection != null && selection.getFirstElement() != null) {
            project = ProjectUtilities.getProject((Object)selection.getFirstElement());
        }
        if (project == null) {
            IProject[] projects = ProjectUtilities.getAllProjects();
            IProjectNature nature = null;
            for (int i = 0; i < projects.length; ++i) {
                nature = SipToolkitUtil.getRuntime((IProject)projects[i]);
                if (nature == null) continue;
                project = projects[i];
                break;
            }
        }
        return project;
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = J2EEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected IDataModelProvider getDefaultProvider() {
        this.modelProvider = new AddSIPServletDataModelProvider();
        return this.modelProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postPerformFinish() throws InvocationTargetException {
        SipArtifactEdit artifactEdit = null;
        try {
            JavaClass javaClass = null;
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IVirtualComponent component = ComponentCore.createComponent((IProject)p);
            IModelProvider sipProvider = SipToolkitUtil.getSIPModelProvider((IProject)p);
            if (sipProvider instanceof SipArtifactEdit) {
                artifactEdit = SipArtifactEdit.getSipArtifactEditForRead((IVirtualComponent)component);
                ResourceSet resourceSet = artifactEdit.getDeploymentDescriptorResource().getResourceSet();
                javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(className, resourceSet);
                J2EEEditorUtility.openInEditor((JavaClass)javaClass, (IProject)p);
            } else if (sipProvider instanceof SIP11ModelProvider) {
                SIP11ModelProvider sip11Provider = (SIP11ModelProvider)sipProvider;
                ProjectResourceSet resourceSet = sip11Provider.getResourceSet(p);
                javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(className, (ResourceSet)resourceSet);
                J2EEEditorUtility.openInEditor((JavaClass)javaClass, (IProject)p);
            }
        }
        catch (Exception cantOpen) {
            cantOpen.printStackTrace();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
    }

    protected boolean prePerformFinish() {
        String projectName;
        IProject proj;
        IFile sipXMLFile;
        Object tp = this.model.getProperty("AddSIPServletDataModel.SERVLETMAPPINGS");
        if (tp != null && tp instanceof TreeParent && !(sipXMLFile = SipToolkitUtil.getSipXmlFile((IProject)(proj = ProjectUtilities.getProject((String)(projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME")))))).exists()) {
            try {
                SipToolkitUtil.createSIPDDStub((IProject)proj, (IProjectFacetVersion)SIPCommonConstants.SIP_FACET_11, (IFile)sipXMLFile, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                SIPCommonPlugin.getLocalLogger().error("SIPServletWizard.prePerformFinish():  failed to create a sip.xml file " + e.getMessage());
            }
        }
        QualifiedName qn = new QualifiedName(null, "TrackNewProject");
        try {
            String newProjProperty = (String)this.getDefaultSipProject().getWorkspace().getRoot().getSessionProperty(qn);
            if (newProjProperty != null && newProjProperty.equals("new project")) {
                ResourcesPlugin.getWorkspace().getRoot().setSessionProperty(qn, (Object)"existing project");
            }
        }
        catch (CoreException e) {
            SIPCommonUIPlugin.getLocalLogger().info(e.getMessage());
        }
        return true;
    }
}

