/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.ui.wizards.project;

import com.ibm.siptools.common.datamodel.SIPProjectCreationDataModelProvider;
import com.ibm.siptools.common.plugin.ResourceHandler;
import com.ibm.siptools.common.plugin.SIPCommonPlugin;
import com.ibm.siptools.common.ui.SIPCommonUIPlugin;
import com.ibm.siptools.common.ui.wizards.project.pages.ConvergedProjectCreationPage;
import com.ibm.ws.ast.facets.core.IFacetConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.VersionFormatException;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.web.ui.internal.wizards.NewProjectDataModelFacetWizard;

public class ConvergedProjectWizard
extends NewProjectDataModelFacetWizard
implements IWizard {
    private boolean DEFAULT_GENERATE_DD = true;
    private static final String CONVERGED_PROJECT = ResourceHandler.getString((String)"SIP_PROJECT");

    public ConvergedProjectWizard() {
        this.setWindowTitle(CONVERGED_PROJECT);
        this.setGenerateDDFlag(this.DEFAULT_GENERATE_DD);
    }

    public ConvergedProjectWizard(IDataModel model) {
        super(model);
        this.setGenerateDDFlag(this.DEFAULT_GENERATE_DD);
    }

    protected IWizardPage createFirstPage() {
        ConvergedProjectCreationPage page = new ConvergedProjectCreationPage(this.getDataModel(), "first.page");
        return page;
    }

    protected IDataModelProvider getDefaultProvider() {
        return new SIPProjectCreationDataModelProvider();
    }

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        return SIPCommonPlugin.getDefault().getImageDescriptor("sip_project");
    }

    protected IDataModel createDataModel() {
        return DataModelFactory.createDataModel((IDataModelProvider)new SIPProjectCreationDataModelProvider());
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.jsr116.sip11converged");
    }

    protected String getFinalPerspectiveID() {
        return ProductManager.getProperty((String)"finalPerspectiveWeb");
    }

    public boolean performFinish() {
        QualifiedName qn = new QualifiedName(null, "TrackNewProject");
        try {
            ResourcesPlugin.getWorkspace().getRoot().setSessionProperty(qn, (Object)"new project");
        }
        catch (CoreException e) {
            SIPCommonUIPlugin.getLocalLogger().info(e.getMessage());
        }
        super.performFinish();
        return true;
    }

    private void setGenerateDDFlag(boolean value) {
        J2EEPlugin.getDefault().getJ2EEPreferences().setValue("dynamic_web_generate_dd", value);
    }

    protected void setRuntimeAndDefaultFacets(IRuntime runtime) {
        IFacetedProjectWorkingCopy dm = this.getFacetedProjectWorkingCopy();
        dm.setTargetedRuntimes(Collections.emptySet());
        if (runtime != null) {
            dm.setProjectFacets(this.getMinFacetsForRuntime(dm, runtime));
            dm.setTargetedRuntimes(Collections.singleton(runtime));
        } else {
            dm.setProjectFacets(this.getMinFacetsDefaults(dm, runtime));
        }
    }

    private Set<IProjectFacetVersion> getMinFacetsDefaults(IFacetedProjectWorkingCopy dm, IRuntime runtime) {
        HashSet<IProjectFacetVersion> minFacets = new HashSet<IProjectFacetVersion>();
        for (IProjectFacet f : dm.getFixedProjectFacets()) {
            try {
                minFacets.add(f.getLatestVersion());
            }
            catch (VersionFormatException e) {
                SIPCommonUIPlugin.getLocalLogger().error(e.getMessage());
            }
            catch (CoreException e) {
                SIPCommonUIPlugin.getLocalLogger().error(e.getMessage());
            }
        }
        return minFacets;
    }

    private Set<IProjectFacetVersion> getMinFacetsForRuntime(IFacetedProjectWorkingCopy dm, IRuntime runtime) {
        String id = FacetUtil.getRuntime((IRuntime)runtime).getRuntimeType().getId();
        HashSet<IProjectFacetVersion> minFacets = new HashSet<IProjectFacetVersion>();
        try {
            for (IProjectFacet f : dm.getFixedProjectFacets()) {
                minFacets.add(f.getLatestSupportedVersion(runtime));
            }
            if (id.startsWith("com.ibm.ws.ast.st.runtime")) {
                IProjectFacet webSphereCoEx = ProjectFacetsManager.getProjectFacet((String)IFacetConstants.WEB_COEXISTENCE_FACET_ID);
                minFacets.add(webSphereCoEx.getLatestSupportedVersion(runtime));
                IProjectFacet webSphereExt = ProjectFacetsManager.getProjectFacet((String)IFacetConstants.WEB_EXTENDED_FACET_ID);
                minFacets.add(webSphereExt.getLatestSupportedVersion(runtime));
            }
            return minFacets;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

