/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.siptools.common.ui;

import com.ibm.siptools.common.plugin.Logger;
import com.ibm.siptools.common.plugin.ResourceHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SIPCommonUIPlugin
extends AbstractUIPlugin
implements ResourceLocator {
    public static final String PLUGIN_ID = "com.ibm.siptools.common.ui";
    public static final String SIP1X_ID = "com.ibm.siptools.common.ui";
    public static final boolean isDebugging = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common.ui/debug"));
    public static final boolean debug = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common.ui/debug/debug"));
    public static final boolean info = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common.ui/debug/info")) || debug;
    public static final boolean warn = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common.ui/debug/warning")) || info;
    public static final boolean error = "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.siptools.common.ui/debug/error")) || warn;
    private static SIPCommonUIPlugin plugin;
    private URL pluginURL = null;
    public static final String[] ICON_DIRS;
    private Logger _logger;

    public SIPCommonUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static SIPCommonUIPlugin getDefault() {
        return plugin;
    }

    public String getPluginID() {
        return "com.ibm.siptools.common.ui";
    }

    public URL getBaseURL() {
        if (this.pluginURL == null) {
            try {
                this.pluginURL = FileLocator.resolve((URL)this.getBundle().getEntry("/"));
            }
            catch (IOException e) {
                SIPCommonUIPlugin.getLocalLogger().info(e.getMessage());
            }
        }
        return this.pluginURL;
    }

    public Object getImage(String key) {
        String gif = "/" + key + ".gif";
        IPath path = null;
        for (int i = 0; i < ICON_DIRS.length; ++i) {
            path = new Path(ICON_DIRS[i]).append(gif);
            if (Platform.find((Bundle)this.getBundle(), (IPath)path) == null) continue;
            try {
                return new URL(this.getBaseURL(), path.toString());
            }
            catch (MalformedURLException exception) {
                SIPCommonUIPlugin.getLocalLogger().info(exception.getMessage());
            }
        }
        return null;
    }

    public String getString(String key) {
        try {
            if (key.startsWith("%")) {
                key = key.substring(1);
            }
            return ResourceHandler.getString((String)key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
    }

    public String getString(String key, Object[] substitutions) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public String getString(String key, boolean translate) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return ResourceHandler.getString((String)key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        if (key.startsWith("%")) {
            key = key.substring(1);
        }
        return this.getString(key, substitutions);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        URL url = (URL)this.getImage(key);
        return url != null ? ImageDescriptor.createFromURL((URL)url) : ImageDescriptor.getMissingImageDescriptor();
    }

    public static Logger getLocalLogger() {
        return SIPCommonUIPlugin.getDefault().getCreateLogger();
    }

    private Logger getCreateLogger() {
        if (this._logger == null) {
            this._logger = new Logger((Plugin)this);
        }
        return this._logger;
    }

    static {
        ICON_DIRS = new String[]{"icons/full/obj16", "icons/full/cview16", "icons/full/ctool16", "icons/full/clcl16", "icons/full/ovr16", "icons/full/extra", "icons/full/wizban", "icons", ""};
    }
}

