/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.internal.ejb.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class FacetHelper {
    public static final String LIBERTY_RUNTIME_ID = "com.ibm.ws.st.runtime";

    public static IRuntime findRuntimeWithType(String runtimeTypeId) {
        org.eclipse.wst.server.core.IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            IRuntime facetRuntime;
            if (runtimes[i].getRuntimeType() == null || !runtimes[i].getRuntimeType().getId().equals(runtimeTypeId) || !(facetRuntime = FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)runtimes[i])).supports(IJ2EEFacetConstants.EJB_30)) continue;
            return facetRuntime;
        }
        return null;
    }

    public static boolean isRuntime80OrHigher() {
        return FacetHelper.findRuntimeWithType("com.ibm.ws.ast.st.runtime.v80") != null || FacetHelper.findRuntimeWithType("com.ibm.ws.ast.st.runtime.v85") != null || FacetHelper.findRuntimeWithType("com.ibm.ws.ast.st.runtime.v90") != null;
    }

    public static boolean isLibertyRuntime() {
        org.eclipse.wst.server.core.IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            if (!runtimes[i].getRuntimeType().getId().startsWith(LIBERTY_RUNTIME_ID)) continue;
            return true;
        }
        return false;
    }

    public static IRuntime findRuntimeWithName(String runtimeName) {
        org.eclipse.wst.server.core.IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            if (!runtimes[i].getName().equals(runtimeName)) continue;
            return FacetUtil.getRuntime((org.eclipse.wst.server.core.IRuntime)runtimes[i]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRuntimeAndFacets(IFacetedProject facetedProject, IRuntime runtime) throws CoreException {
        if (!facetedProject.getTargetedRuntimes().contains(runtime)) {
            Set<IRuntime> runtimes = Collections.singleton(runtime);
            facetedProject.setTargetedRuntimes(runtimes, (IProgressMonitor)new NullProgressMonitor());
            facetedProject.setPrimaryRuntime(runtime, (IProgressMonitor)new NullProgressMonitor());
        }
        IFacetedProjectWorkingCopy workingCopy = facetedProject.createWorkingCopy();
        try {
            Set defaultFacets = workingCopy.getDefaultConfiguration().getProjectFacets();
            HashSet<IFacetedProject.Action> actions = new HashSet<IFacetedProject.Action>();
            for (IProjectFacetVersion facetVersion : defaultFacets) {
                IProjectFacet projFacet;
                if (!facetedProject.hasProjectFacet(facetVersion.getProjectFacet())) {
                    actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, facetVersion, null));
                }
                if (!(projFacet = facetVersion.getProjectFacet()).equals((Object)JavaFacet.FACET)) continue;
                IProjectFacetVersion latestJavaFacet = projFacet.getLatestSupportedVersion(runtime);
                if (facetedProject.hasProjectFacet(facetVersion)) continue;
                actions.add(new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, latestJavaFacet, null));
            }
            if (!actions.isEmpty()) {
                facetedProject.modify(actions, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        finally {
            workingCopy.dispose();
        }
    }

    public static boolean isJava500Higher(IJavaProject javaProject) {
        String jdtVersion = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (jdtVersion.startsWith("1.3")) {
            return false;
        }
        if (jdtVersion.startsWith("1.4")) {
            return false;
        }
        if (jdtVersion.startsWith("1.5")) {
            return true;
        }
        return true;
    }

    public IProjectFacetVersion getJavaFacetVersion(IJavaProject javaProject) {
        String jdtVersion = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (jdtVersion.startsWith("1.3")) {
            return JavaFacet.VERSION_1_3;
        }
        if (jdtVersion.startsWith("1.4")) {
            return JavaFacet.VERSION_1_4;
        }
        if (jdtVersion.startsWith("1.5")) {
            return JavaFacet.VERSION_1_5;
        }
        if (jdtVersion.startsWith("1.6")) {
            return JavaFacet.VERSION_1_6;
        }
        if (jdtVersion.startsWith("1.7")) {
            return JavaFacet.VERSION_1_7;
        }
        return JavaFacet.VERSION_1_8;
    }

    public static boolean isFaceted(IJavaProject javaProject) throws CoreException {
        IFacetedProject facetProject = ProjectFacetsManager.create((IProject)javaProject.getProject());
        return facetProject != null;
    }
}

