/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.internal.ejb.ui;

import com.ibm.jee.internal.ejb.ui.AddEJB3SupportProposal;
import com.ibm.jee.internal.ejb.ui.FacetHelper;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class EJB3SupportQuickFixProcessor
implements IQuickFixProcessor {
    public static final String STATELESS = "Stateless";
    public static final String STATEFUL = "Stateful";
    public static final String MESSAGEDRIVEN = "MessageDriven";
    public static final String SINGLETON = "Singleton";
    public static final String LOCALBEAN = "LocalBean";

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        if (FacetHelper.isFaceted(unit.getJavaProject())) {
            return null;
        }
        ArrayList<IJavaCompletionProposal> res = null;
        for (int i = 0; i < locations.length; ++i) {
            IProblemLocation problem = locations[i];
            int id = problem.getProblemId();
            if ((!FacetHelper.isJava500Higher(unit.getJavaProject()) || 0x1000002 != id) && -1610612233 != id) continue;
            res = this.getAddEJB3SupportProposals(context, problem, res);
        }
        if (res == null || res.isEmpty()) {
            return null;
        }
        return res.toArray(new IJavaCompletionProposal[res.size()]);
    }

    public boolean hasCorrections(ICompilationUnit cu, int problemId) {
        return problemId == 0x1000002 || problemId == -1610612233;
    }

    private ArrayList<IJavaCompletionProposal> getAddEJB3SupportProposals(IInvocationContext context, IProblemLocation location, ArrayList<IJavaCompletionProposal> proposals) {
        Name node = null;
        ASTNode selectedNode = location.getCoveringNode(context.getASTRoot());
        if (proposals == null) {
            proposals = new ArrayList();
        }
        if (selectedNode instanceof Name) {
            boolean isEJB31;
            node = (Name)selectedNode;
            String typeName = ASTNodes.getSimpleNameIdentifier((Name)node);
            boolean bl = isEJB31 = typeName.equalsIgnoreCase(SINGLETON) || typeName.equalsIgnoreCase(LOCALBEAN);
            if (typeName.equalsIgnoreCase(STATELESS) || typeName.equalsIgnoreCase(STATEFUL) || typeName.equalsIgnoreCase(MESSAGEDRIVEN) || isEJB31) {
                if (ServerCore.getRuntimes().length == 0) {
                    return proposals;
                }
                if (isEJB31 && !FacetHelper.isRuntime80OrHigher() && !FacetHelper.isLibertyRuntime()) {
                    return proposals;
                }
                if (this.hasWASorLibertyRuntime()) {
                    proposals.add(new AddEJB3SupportProposal(context, 8, selectedNode));
                }
            }
        }
        return proposals;
    }

    private boolean hasWASorLibertyRuntime() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            if (!WASRuntimeUtil.isWASRuntime((IRuntime)runtimes[i]) && !runtimes[i].getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime")) continue;
            return true;
        }
        return false;
    }
}

