/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.internal.ejb.ui;

import com.ibm.jee.internal.ejb.ui.EJB3SupportMsg;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class EJB3RuntimSelectionDialog
extends TitleAreaDialog {
    static final String EJB_3_2 = "3.2";
    static final String EJB_3_1 = "3.1";
    static final String EJB_3_0 = "3.0";
    protected String title_;
    protected String message_;
    protected IRuntime wasRuntime;
    protected String ejb3Version;
    protected Combo targetedRuntimes;
    protected Combo ejb3Versions;
    protected boolean exclusiveEJB31orGreater = false;
    protected Map<String, IRuntime> selectIRuntimes = new HashMap<String, IRuntime>();

    public EJB3RuntimSelectionDialog(Shell parent, String title, String message) {
        super(parent);
        this.title_ = title;
        this.message_ = message;
        this.setShellStyle(0x10870 | EJB3RuntimSelectionDialog.getDefaultOrientation());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title_);
    }

    protected Control createDialogArea(Composite composite) {
        this.setTitle(this.title_);
        this.setMessage(this.message_);
        Composite parent = (Composite)super.createDialogArea(composite);
        UIUtils uiUtils = new UIUtils("com.ibm.jee.ejb.ui");
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        parent.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        parent.setLayout((Layout)gl);
        Composite runtimeComp = uiUtils.createComposite(parent, 2);
        this.targetedRuntimes = uiUtils.createCombo(runtimeComp, EJB3SupportMsg.EJB_RUNTIME_LABEL, EJB3SupportMsg.EJB_RUNTIME_TOOLTIP, null, 2056);
        this.targetedRuntimes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EJB3RuntimSelectionDialog.this.updateEjb3Version();
            }
        });
        IRuntime[] runtimes = ServerCore.getRuntimes();
        for (int i = 0; i < runtimes.length; ++i) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime;
            if (runtimes[i].getRuntimeType() == null || !this.isEJBSupported(facetRuntime = FacetUtil.getRuntime((IRuntime)runtimes[i]))) continue;
            this.targetedRuntimes.add(runtimes[i].getName());
            this.selectIRuntimes.put(runtimes[i].getName(), runtimes[i]);
        }
        this.targetedRuntimes.select(this.targetedRuntimes.getItemCount() - 1);
        this.ejb3Versions = uiUtils.createCombo(runtimeComp, EJB3SupportMsg.EJB_VERSION_LABEL, EJB3SupportMsg.EJB_VERSION_TOOLTIP, null, 2056);
        this.ejb3Versions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.updateEjb3Version();
        return parent;
    }

    private boolean isEJBSupported(org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime) {
        return this.exclusiveEJB31orGreater ? facetRuntime.supports(IJ2EEFacetConstants.EJB_31) || facetRuntime.supports(IJ2EEFacetConstants.EJB_32) : facetRuntime.supports(IJ2EEFacetConstants.EJB_30);
    }

    protected void updateEjb3Version() {
        this.ejb3Versions.removeAll();
        String runtimeText = this.targetedRuntimes.getText();
        IRuntime runtime = this.selectIRuntimes.get(runtimeText);
        if (WASRuntimeUtil.isWASv85OrLaterRuntime((IRuntime)runtime) || runtime.getRuntimeType().getId().startsWith("com.ibm.ws.st.runtime") && this.selectIRuntimes.containsKey(runtimeText)) {
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = FacetUtil.getRuntime((IRuntime)runtime);
            if (facetRuntime.supports(IJ2EEFacetConstants.EJB_32)) {
                this.ejb3Versions.add(EJB_3_2);
            }
            if (facetRuntime.supports(IJ2EEFacetConstants.EJB_31)) {
                this.ejb3Versions.add(EJB_3_1);
            }
        }
        if (!this.exclusiveEJB31orGreater) {
            this.ejb3Versions.add(EJB_3_0);
        }
        this.ejb3Versions.select(0);
    }

    protected void okPressed() {
        this.wasRuntime = this.selectIRuntimes.get(this.targetedRuntimes.getText());
        this.ejb3Version = this.ejb3Versions.getText();
        super.okPressed();
    }

    public IRuntime getWasRuntime() {
        return this.wasRuntime;
    }

    public String getEJB3Version() {
        return this.ejb3Version;
    }

    public void setSelectedNode(ASTNode selectedNode) {
        String typeName = ASTNodes.getSimpleNameIdentifier((Name)((Name)selectedNode));
        this.exclusiveEJB31orGreater = typeName.equalsIgnoreCase("Singleton") || typeName.equalsIgnoreCase("LocalBean");
    }
}

