/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.internal.ejb.ui;

import com.ibm.jee.internal.ejb.ui.EJB3RuntimSelectionDialog;
import com.ibm.jee.internal.ejb.ui.EJB3SupportMsg;
import com.ibm.jee.internal.ejb.ui.EJB3SupportPlugin;
import com.ibm.jee.internal.ejb.ui.EJBFacetInstallDataModelProvider;
import com.ibm.jee.internal.ejb.ui.FacetHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class AddEJB3SupportProposal
implements IJavaCompletionProposal {
    private final int fRelevance;
    private final ICompilationUnit fCompilationUnit;
    private final IJavaProject javaProject;
    private final ASTNode node;
    private IRuntime runtime;
    private String ejb3Version;

    public AddEJB3SupportProposal(IInvocationContext context, int relevance, ASTNode selectedNode) {
        this.fRelevance = relevance;
        this.fCompilationUnit = context.getCompilationUnit();
        this.javaProject = this.fCompilationUnit.getJavaProject();
        this.node = selectedNode;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public String getAdditionalProposalInfo() {
        return EJB3SupportMsg.AddEJB3Support_Addition_Info_WAS;
    }

    public String getDisplayString() {
        return EJB3SupportMsg.AddEJB3SupportWAS;
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
    }

    public void apply(final IDocument document) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    EJB3RuntimSelectionDialog dialog = new EJB3RuntimSelectionDialog(Display.getDefault().getActiveShell(), EJB3SupportMsg.AddEJB3SupportWAS, EJB3SupportMsg.AddEJB3Support_Dialog_Message);
                    dialog.setSelectedNode(AddEJB3SupportProposal.this.node);
                    if (dialog.open() == 0) {
                        AddEJB3SupportProposal.this.runtime = dialog.getWasRuntime();
                        AddEJB3SupportProposal.this.ejb3Version = dialog.getEJB3Version();
                        AddEJB3SupportProposal.this.convert(document);
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            EJB3SupportPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private void convert(IDocument document) {
        IProject project = this.javaProject.getProject();
        IFacetedProject facetProj = null;
        IDataModel jdm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        jdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.javaProject.getProject().getName());
        if (this.ejb3Version.equals("3.2")) {
            jdm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaFacet.VERSION_1_7);
        } else {
            jdm.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)JavaFacet.VERSION_1_6);
        }
        try {
            String configFolder = null;
            IPackageFragmentRoot[] roots = this.javaProject.getPackageFragmentRoots();
            if (roots.length != 0) {
                for (IPackageFragmentRoot root : roots) {
                    if (root.getKind() != 1 || root.getElementName().length() <= 0) continue;
                    configFolder = root.getElementName();
                    break;
                }
            }
            if (configFolder == null) {
                configFolder = this.getDefaultEJBContentFolder();
            }
            IDataModel udm = DataModelFactory.createDataModel((IDataModelProvider)new EJBFacetInstallDataModelProvider());
            udm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.javaProject.getProject().getName());
            udm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)this.ejb3Version);
            udm.setProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", (Object)(this.javaProject.getProject().getName() + ".jar"));
            udm.setProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER", (Object)configFolder);
            udm.setProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
            udm.setProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", (Object)Boolean.FALSE);
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
            dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.javaProject.getProject().getName());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            map.add(jdm);
            map.add(udm);
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            facetProj = ProjectFacetsManager.create((IProject)project);
            if (facetProj != null) {
                if (facetProj.getPrimaryRuntime() == null) {
                    FacetHelper.setRuntimeAndFacets(facetProj, FacetUtil.getRuntime((IRuntime)this.runtime));
                }
                if (facetProj.getPrimaryRuntime() != null && facetProj.hasProjectFacet(IJ2EEFacetConstants.EJB_30) || facetProj.hasProjectFacet(IJ2EEFacetConstants.EJB_31) || facetProj.hasProjectFacet(IJ2EEFacetConstants.EJB_32)) {
                    Name nameNode = null;
                    if (this.node instanceof Name) {
                        nameNode = (Name)this.node;
                    }
                    if (nameNode != null && nameNode.isSimpleName()) {
                        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)this.fCompilationUnit, (boolean)true);
                        importRewrite.addImport("javax.ejb." + nameNode.getFullyQualifiedName());
                        TextEdit edit = importRewrite.rewriteImports(null);
                        edit.apply(document);
                    }
                }
            }
        }
        catch (CoreException e) {
            EJB3SupportPlugin.getDefault().getLog().log(e.getStatus());
        }
        catch (Exception e) {
            Status status = new Status(2, "com.ibm.jee.ejb.ui", 2, EJB3SupportMsg.ErrorSetRuntimeFacetMessage, (Throwable)e);
            EJB3SupportPlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private String getDefaultEJBContentFolder() {
        J2EEPreferences preferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        String configFolder = preferences.getString("ejbContent");
        if (configFolder == null || configFolder.trim().length() == 0) {
            configFolder = "ejbModule";
        }
        return configFolder;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

