/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.common.annotations.ui.internal.util;

import com.ibm.etools.annotations.core.data.AnnotatedClassInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfo;
import com.ibm.etools.annotations.core.data.AnnotatedProjectInfosRepository;
import com.ibm.etools.annotations.core.data.AnnotationInfo;
import com.ibm.etools.annotations.core.utils.AnnotationUtils;
import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public final class JeeAnnotationsUiUtilities {
    public static final String PROBLEM_MARKER = "com.ibm.jee.common.annotations.ui.ejb3AnnotationProblemMarker";
    public static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    public static final String NEW_MANIFEST_CLASSPATH = "";
    public static final String NEW_MANIFEST_VERSION = "1.0";
    public static final String SCAN_POLICY_CUSTOM_PROPERTY = "UseEJB61FEPScanPolicy";
    public static final String META_INF_FOLDER_NAME = "META-INF";
    public static final String ANNOTATION_MARKER = "com.ibm.jee.common.annotations.ui.ejb3AnnotationMarker";
    public static final String MARKER_ATTR_CHAR_START_OLD = "com.ibm.jee.common.annotations.ui.CHAR_START_OLD";
    public static final String MARKER_ATTR_CHAR_END_OLD = "com.ibm.jee.common.annotations.ui.CHAR_END_OLD";
    public static final String MARKER_ATTR_KIND = "com.ibm.jee.common.annotations.ui.KIND";
    private static JeeAnnotationsUiUtilities singleInstance;

    private JeeAnnotationsUiUtilities() {
    }

    public static JeeAnnotationsUiUtilities getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new JeeAnnotationsUiUtilities();
        }
        return singleInstance;
    }

    public void createMarker(final String markerId, final IResource resource, String message, int severity, int start, int length, int lineNumber, final Map<String, Object> attributes, IProgressMonitor monitor) throws CoreException {
        if (attributes == null) {
            throw new IllegalArgumentException("Optional attributes map cannot be null.");
        }
        attributes.put("severity", new Integer(severity));
        attributes.put("message", message);
        attributes.put("charStart", new Integer(start));
        attributes.put("charEnd", new Integer(start + length));
        if (lineNumber > 0) {
            attributes.put("lineNumber", lineNumber);
        }
        IWorkspaceRunnable createMarkerRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor pm) throws CoreException {
                IMarker marker = resource.createMarker(markerId);
                marker.setAttributes(attributes);
            }
        };
        resource.getWorkspace().run(createMarkerRunnable, ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource), 1, monitor);
    }

    public void deleteMarker(String markerId, IResource resource, int start, int length) throws CoreException {
        if (resource == null) {
            throw new IllegalArgumentException("Resource cannot be null.");
        }
        int endChar = start + length;
        for (IMarker marker : resource.findMarkers(markerId, false, 2)) {
            if (start != marker.getAttribute("charStart", 0) - 1 || endChar != marker.getAttribute("charEnd", 0)) continue;
            marker.delete();
        }
    }

    public static void removeMarkers(IResource resource, String markerId) {
        try {
            IMarker[] wsMarkers;
            for (IMarker wsMarker : wsMarkers = resource.findMarkers(markerId, false, 2)) {
                wsMarker.delete();
            }
        }
        catch (CoreException e) {
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public Set<IAnnotation> findAnnotations(IFile javaFile, Set<String> annotationNames) {
        Set<Object> result = null;
        if (javaFile != null && annotationNames != null && !annotationNames.isEmpty()) {
            result = new HashSet();
            AnnotatedProjectInfo projectInfo = AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForEJB(javaFile.getProject(), false, true);
            IJavaElement javaElement = JavaCore.create((IFile)javaFile);
            if (javaElement != null) {
                List annotationInfos = projectInfo.getAllAnnotationsForType(javaElement.getElementName());
                result = this.findAnnotations(annotationInfos, annotationNames);
            }
        }
        return result;
    }

    public Set<IAnnotation> findAnnotations(IProject project, Set<String> annotationNames) {
        HashSet<IAnnotation> result = null;
        if (project != null && annotationNames != null && !annotationNames.isEmpty()) {
            result = new HashSet<IAnnotation>();
            AnnotatedProjectInfo projectInfo = AnnotatedProjectInfosRepository.getInstance().getAnnotatedProjectInfoForEJB(project, false, true);
            for (String annotationName : annotationNames) {
                AnnotatedClassInfo[] classInfos;
                for (AnnotatedClassInfo classInfo : classInfos = projectInfo.getAnnotatedClassInfos(annotationName)) {
                    List annotationInfos = AnnotationUtils.getAllAnnotationInfosUtilMethod((AnnotatedClassInfo)classInfo);
                    result.addAll(this.findAnnotations(annotationInfos, annotationNames));
                }
            }
        }
        return result;
    }

    public Set<IAnnotation> findAnnotations(List<AnnotationInfo> annotationInfos, Set<String> annotationNames) {
        HashSet<IAnnotation> result = new HashSet<IAnnotation>();
        if (annotationInfos != null && annotationNames != null && !annotationNames.isEmpty()) {
            for (AnnotationInfo annotationInfo : annotationInfos) {
                IAnnotation annotation = annotationInfo.getAnnotation();
                if (annotation == null || !annotationNames.contains(annotation.getElementName()) && !annotationNames.contains(AnnotationUtils.getAnnoNameFromLongName((String)annotation.getElementName()))) continue;
                result.add(annotation);
            }
        }
        return result;
    }

    public int findLineNumber(IAnnotation annotation, IProgressMonitor monitor) throws JavaModelException {
        int result = -1;
        ICompilationUnit icu = (ICompilationUnit)annotation.getAncestor(5);
        if (icu != null) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(icu);
            CompilationUnit cu = (CompilationUnit)parser.createAST(monitor);
            result = cu.getLineNumber(annotation.getSourceRange().getOffset());
        }
        return result;
    }

    public IFile findMetaInfFile(String fileName, IProject project) {
        IFile file = null;
        try {
            IResource resource;
            IFolder metaInfFolder = JeeAnnotationsUiUtilities.getSingleInstance().findMetaInfFolder(project);
            if (metaInfFolder != null && (resource = project.getProject().findMember(metaInfFolder.getProjectRelativePath().append(fileName))) != null && resource.getType() == 1) {
                file = (IFile)resource;
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Exception encountered while discovering XML metadata files.", (Throwable)ce);
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
        }
        return file;
    }

    public IFolder findMetaInfFolder(IProject project) throws CoreException {
        IVirtualResource[] members;
        IFolder result = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && (members = component.getRootFolder().members()) != null && members.length > 0) {
            boolean metaInfFolderFound = false;
            for (int i = 0; !metaInfFolderFound && i < members.length; ++i) {
                if (members[i].getType() != 32 || !META_INF_FOLDER_NAME.equals(members[i].getName())) continue;
                result = (IFolder)members[i].getUnderlyingResource();
                metaInfFolderFound = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findScanPolicyValue(IProject project) {
        Manifest manifest;
        boolean result;
        block7: {
            result = false;
            manifest = null;
            try {
                IFile manifestFile = this.findMetaInfFile(MANIFEST_FILE_NAME, project);
                if (manifestFile == null) break block7;
                try (InputStream contents = manifestFile.getContents();){
                    manifest = new Manifest(contents);
                }
            }
            catch (IOException ioe) {
                Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Exception encountered while reading MANIFEST.MF.", (Throwable)ioe);
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (CoreException ce) {
                Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Exception encountered while reading MANIFEST.MF.", (Throwable)ce);
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        if (manifest != null) {
            String value = manifest.getMainAttributes().getValue(SCAN_POLICY_CUSTOM_PROPERTY);
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    public IRuntime findServerRuntime(IProject project) {
        IRuntime result = null;
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime primaryRuntime = null;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject != null) {
                primaryRuntime = facetedProject.getPrimaryRuntime();
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Faceted project could not be determined for project: " + project.getName(), (Throwable)ce);
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
        }
        if (primaryRuntime != null) {
            result = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)primaryRuntime);
        }
        return result;
    }

    public boolean isPre25WebProject(IProject project) throws CoreException {
        boolean result = false;
        if (project != null) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && facetedProject.hasProjectFacet(IJ2EEFacetConstants.DYNAMIC_WEB_FACET)) {
                    IProjectFacetVersion projectFacet = facetedProject.getInstalledVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
                    if (IJ2EEFacetConstants.DYNAMIC_WEB_FACET.getVersionComparator().compare(projectFacet.getVersionString(), "2.5") < 0) {
                        result = true;
                    }
                }
            }
            catch (CoreException ce) {
                Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Project facets could not be determined for project: " + project.getName(), (Throwable)ce);
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
                throw ce;
            }
        }
        return result;
    }

    public boolean isPre50ApplicationClientProject(IProject project) throws CoreException {
        boolean result = false;
        if (project != null) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null && facetedProject.hasProjectFacet(IJ2EEFacetConstants.APPLICATION_CLIENT_FACET)) {
                    IProjectFacetVersion projectFacet = facetedProject.getInstalledVersion(IJ2EEFacetConstants.APPLICATION_CLIENT_FACET);
                    if (IJ2EEFacetConstants.APPLICATION_CLIENT_FACET.getVersionComparator().compare(projectFacet.getVersionString(), "5.0") < 0) {
                        result = true;
                    }
                }
            }
            catch (CoreException ce) {
                Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Project facets could not be determined for project: " + project.getName(), (Throwable)ce);
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
                throw ce;
            }
        }
        return result;
    }

    public static boolean doesAnnotationResourceExist(IAnnotation annotation) {
        if (annotation.getResource() == null) {
            return false;
        }
        return annotation.getResource().exists();
    }

    public static boolean isAlreadyMarkerForAnnotation(IAnnotation annotation) {
        try {
            IMarker[] wsProbMarkers;
            ISourceRange nameRange = annotation.getNameRange();
            int charStart = nameRange.getOffset();
            int charEnd = charStart + nameRange.getLength();
            IResource resource = annotation.getResource();
            for (IMarker wsProbMarker : wsProbMarkers = resource.findMarkers(PROBLEM_MARKER, false, 2)) {
                if (wsProbMarker.getAttribute(MARKER_ATTR_CHAR_START_OLD, -1) != charStart || wsProbMarker.getAttribute(MARKER_ATTR_CHAR_END_OLD, -1) != charEnd) continue;
                return true;
            }
        }
        catch (CoreException e) {
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
        }
        return false;
    }

    public boolean supportAnnotations(IProject project) {
        return project != null ? this.supportAnnotations(JavaCore.create((IProject)project)) : false;
    }

    public boolean supportAnnotations(IJavaProject project) {
        String srcLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        return srcLevel.compareTo("1.4") > 0;
    }
}

