/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.common.annotations.ui.internal;

import com.ibm.etools.annotations.core.api.TriggerAnnotationListener;
import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiMessages;
import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiPlugin;
import com.ibm.jee.common.annotations.ui.internal.PreJee5AnnotationsValidator;
import com.ibm.jee.common.annotations.ui.internal.util.JeeAnnotationsUiUtilities;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.ValidatorMessage;

public class ValidateTrigger
extends TriggerAnnotationListener {
    public static final String VAL_STATE_ANNOTATION_TRIGGER = "VAL_STATE_ANNOTATION_TRIGGER";

    private void addMarker(ValidatorMessage message, IResource resource) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int charStart = message.getAttribute("charStart", 0);
            int charEnd = message.getAttribute("charEnd", 0);
            int severity = message.getAttribute("severity", 1);
            map.put("severity", new Integer(severity));
            map.put("message", message.getAttribute("message"));
            MarkerUtilities.setCharStart(map, (int)charStart);
            MarkerUtilities.setCharEnd(map, (int)charEnd);
            map.put("com.ibm.jee.common.annotations.ui.CHAR_START_OLD", new Integer(charStart));
            map.put("com.ibm.jee.common.annotations.ui.CHAR_END_OLD", new Integer(charEnd));
            map.put("com.ibm.jee.common.annotations.ui.KIND", message.getAttribute("com.ibm.jee.common.annotations.ui.KIND"));
            MarkerUtilities.createMarker((IResource)resource, map, (String)"com.ibm.jee.common.annotations.ui.ejb3AnnotationMarker");
        }
        catch (CoreException e) {
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private void validateAnnotation(final IAnnotation annotation) {
        Job validateJob = new Job(JeeCommonAnnotationsUiMessages.VALIDATING_ANNOTATIONS){

            protected IStatus run(IProgressMonitor monitor) {
                PreJee5AnnotationsValidator validator = new PreJee5AnnotationsValidator();
                if (!JeeAnnotationsUiUtilities.doesAnnotationResourceExist(annotation)) {
                    return Status.OK_STATUS;
                }
                Validator val = ValidationFramework.getDefault().getValidator("com.ibm.jee.common.annotations.PreJee5AnnotationsValidator", annotation.getResource().getProject());
                if (val != null && val.isBuildValidation()) {
                    ValidatorMessage[] messages;
                    ValidationState state = new ValidationState();
                    state.put(ValidateTrigger.VAL_STATE_ANNOTATION_TRIGGER, (Object)Boolean.TRUE);
                    ValidationResult result = validator.validate(annotation.getResource(), 0, state, null);
                    for (ValidatorMessage m : messages = result.getMessages()) {
                        if (JeeAnnotationsUiUtilities.isAlreadyMarkerForAnnotation(annotation)) continue;
                        ValidateTrigger.this.addMarker(m, annotation.getResource());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        validateJob.schedule();
    }

    public void annotationChanged(IAnnotation annotation) {
        this.validateAnnotation(annotation);
    }

    public void annotationAdded(IAnnotation annotation) {
        this.validateAnnotation(annotation);
    }

    public void annotationRemoved(IAnnotation annotation) {
        this.validateAnnotation(annotation);
    }
}

