/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.common.annotations.ui.internal;

import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiMessages;
import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiPlugin;
import com.ibm.jee.common.annotations.ui.internal.util.JeeAnnotationsUiUtilities;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class ScanPolicyMarkerResolution
implements IMarkerResolution {
    private IFile findManifestFile(IProject project) {
        IFile result = JeeAnnotationsUiUtilities.getSingleInstance().findMetaInfFile("MANIFEST.MF", project);
        if (result == null) {
            try {
                IFolder metaInfFolder = JeeAnnotationsUiUtilities.getSingleInstance().findMetaInfFolder(project);
                if (metaInfFolder == null) {
                    IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                    if (component.getRootFolder() == null) {
                        return result;
                    }
                    metaInfFolder = ((IFolder)component.getRootFolder().getUnderlyingFolder()).getFolder("META-INF");
                    if (metaInfFolder == null) {
                        return result;
                    }
                }
                result = metaInfFolder.getFile("MANIFEST.MF");
                this.ensureParentExists((IResource)result);
                if (!result.exists()) {
                    InputStream empty = new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return -1;
                        }
                    };
                    result.create(empty, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException ce) {
                Status status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, "Error creating a MANIFEST.MF file.", (Throwable)ce);
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    private void ensureParentExists(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (!parent.exists()) {
            this.ensureParentExists((IResource)parent);
            ((IFolder)parent).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public String getLabel() {
        return JeeCommonAnnotationsUiMessages.ADD_PROPERTY_QUICKFIX;
    }

    public void run(IMarker marker) {
        final IFile manifestFile = this.findManifestFile(marker.getResource().getProject());
        WorkspaceJob job = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                Thread thread = this.getThread();
                if (thread != null) {
                    thread.setPriority(1);
                }
                if (manifestFile != null) {
                    try {
                        InputStream in = manifestFile.getContents();
                        Manifest manifest = new Manifest(in);
                        in.close();
                        Attributes attributes = manifest.getMainAttributes();
                        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                        }
                        if (attributes.getValue(Attributes.Name.CLASS_PATH) == null) {
                            attributes.putValue(Attributes.Name.CLASS_PATH.toString(), "");
                        }
                        attributes.putValue("UseEJB61FEPScanPolicy", "true");
                        FileOutputStream out = new FileOutputStream(manifestFile.getLocation().toFile());
                        manifest.write(out);
                        ((OutputStream)out).close();
                        manifestFile.refreshLocal(0, monitor);
                    }
                    catch (CoreException ce) {
                        status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, NLS.bind((String)JeeCommonAnnotationsUiMessages.ERROR_MODIFYING_FILE, (Object)"MANIFEST.MF"), (Throwable)ce);
                        JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(status);
                    }
                    catch (IOException ioe) {
                        status = new Status(4, "com.ibm.jee.common.annotations.ui", 4, NLS.bind((String)JeeCommonAnnotationsUiMessages.ERROR_MODIFYING_FILE, (Object)"MANIFEST.MF"), (Throwable)ioe);
                        JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(status);
                    }
                } else {
                    status = new Status(4, "com.ibm.jee.common.annotations.ui", NLS.bind((String)JeeCommonAnnotationsUiMessages.ERROR_MODIFYING_FILE, (Object)"MANIFEST.MF"));
                }
                return status;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)manifestFile));
        job.schedule();
    }
}

