/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.common.annotations.ui.internal;

import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiMessages;
import com.ibm.jee.common.annotations.ui.internal.JeeCommonAnnotationsUiPlugin;
import com.ibm.jee.common.annotations.ui.internal.util.IJeeAnnotationLists;
import com.ibm.jee.common.annotations.ui.internal.util.JeeAnnotationsUiUtilities;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;

public final class PreJee5AnnotationsValidator
extends AbstractValidator {
    private boolean triggeredByAnnotationChange;

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult result;
        block15: {
            result = new ValidationResult();
            this.triggeredByAnnotationChange = false;
            if (state != null && state.get("VAL_STATE_ANNOTATION_TRIGGER") instanceof Boolean) {
                this.triggeredByAnnotationChange = (Boolean)state.get("VAL_STATE_ANNOTATION_TRIGGER");
            }
            if ("java".equalsIgnoreCase(resource.getFileExtension())) {
                ICompilationUnit icu = (ICompilationUnit)JavaCore.create((IResource)resource);
                this.validateCompilationUnit(icu, result);
            } else {
                IProject project = resource.getProject();
                try {
                    IJavaProject javaProj;
                    if (!this.isSupportedProject(project) || (javaProj = JavaCore.create((IProject)project)) == null || !javaProj.exists()) break block15;
                    IPackageFragmentRoot[] pkgFragmentRoots = new IPackageFragmentRoot[]{};
                    try {
                        pkgFragmentRoots = javaProj.getPackageFragmentRoots();
                    }
                    catch (JavaModelException e) {
                        JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
                    }
                    for (IPackageFragmentRoot root : pkgFragmentRoots) {
                        block16: {
                            try {
                                if (root.getKind() != 1) {
                                }
                                break block16;
                            }
                            catch (JavaModelException e) {
                                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
                            }
                            continue;
                        }
                        try {
                            for (IJavaElement element : root.getChildren()) {
                                IPackageFragment pkg = (IPackageFragment)element;
                                for (ICompilationUnit icu : pkg.getCompilationUnits()) {
                                    this.validateCompilationUnit(icu, result);
                                }
                            }
                        }
                        catch (JavaModelException e) {
                            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                }
                catch (CoreException e) {
                    JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
        }
        return result;
    }

    private void validateCompilationUnit(ICompilationUnit icu, ValidationResult result) {
        IType[] types;
        try {
            if (!this.isSupportedProject(icu.getJavaProject().getProject())) {
                return;
            }
        }
        catch (CoreException e) {
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
            return;
        }
        try {
            types = icu.getTypes();
        }
        catch (JavaModelException e) {
            return;
        }
        for (IType t : types) {
            if (t.getResource() == null || !t.getResource().exists()) continue;
            JeeAnnotationsUiUtilities.removeMarkers(t.getResource(), "com.ibm.jee.common.annotations.ui.ejb3AnnotationMarker");
            if (!this.triggeredByAnnotationChange) {
                JeeAnnotationsUiUtilities.removeMarkers(t.getResource(), "com.ibm.jee.common.annotations.ui.ejb3AnnotationProblemMarker");
            }
            try {
                for (IAnnotation iAnnotation : t.getAnnotations()) {
                    this.validateAnnotation(iAnnotation, result);
                }
                for (IAnnotation iAnnotation : t.getChildren()) {
                    if (!(iAnnotation instanceof IAnnotatable)) continue;
                    for (IAnnotation a : ((IAnnotatable)iAnnotation).getAnnotations()) {
                        this.validateAnnotation(a, result);
                    }
                }
            }
            catch (JavaModelException e) {
                JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    protected boolean isSupportedProject(IProject project) throws CoreException {
        return JeeAnnotationsUiUtilities.getSingleInstance().supportAnnotations(project) && (JeeAnnotationsUiUtilities.getSingleInstance().isPre25WebProject(project) || JeeAnnotationsUiUtilities.getSingleInstance().isPre50ApplicationClientProject(project));
    }

    public void validateAnnotation(IAnnotation annotation, ValidationResult result) {
        try {
            int severity;
            if (this.shouldHandle(annotation) && (severity = this.findEjb3AnnotationMarkerSeverity(annotation.getResource().getProject())) > -1) {
                String message = NLS.bind((String)JeeCommonAnnotationsUiMessages.ANNOTATION_NOT_RECOGNIZED, (Object)annotation.getElementName());
                ValidatorMessage m = ValidatorMessage.create((String)message, (IResource)annotation.getResource());
                m.setType("com.ibm.jee.common.annotations.ui.ejb3AnnotationProblemMarker");
                m.setAttribute("charStart", annotation.getNameRange().getOffset());
                m.setAttribute("charEnd", annotation.getNameRange().getOffset() + annotation.getNameRange().getLength());
                m.setAttribute("severity", severity);
                m.setAttribute("sourceId", (Object)"com.ibm.jee.common.annotations.ui.ejb3AnnotationProblemMarker");
                m.setAttribute("com.ibm.jee.common.annotations.ui.CHAR_START_OLD", annotation.getNameRange().getOffset());
                m.setAttribute("com.ibm.jee.common.annotations.ui.CHAR_END_OLD", annotation.getNameRange().getOffset() + annotation.getNameRange().getLength());
                m.setAttribute("org.eclipse.core.resources.marker", (Object)"com.ibm.jee.common.annotations.ui.ejb3AnnotationProblemMarker");
                result.add(m);
            }
        }
        catch (JavaModelException e) {
            JeeCommonAnnotationsUiPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private boolean shouldHandle(IAnnotation annotation) {
        String elementName = annotation.getElementName();
        if (elementName.indexOf(".") == -1) {
            return IJeeAnnotationLists.EJB3_ANNOTATION_SHORT_NAMES_FOR_PRE_JEE5_MODULES.contains(elementName);
        }
        return IJeeAnnotationLists.EJB3_ANNOTATION_NAMES_FOR_PRE_JEE5_MODULES.contains(elementName);
    }

    protected int findEjb3AnnotationMarkerSeverity(IProject project) {
        int result = 0;
        IRuntime serverRuntime = JeeAnnotationsUiUtilities.getSingleInstance().findServerRuntime(project);
        if (serverRuntime != null && !JeeAnnotationsUiUtilities.getSingleInstance().findScanPolicyValue(project) && WASRuntimeUtil.isWASv85OrLaterRuntime((IRuntime)serverRuntime)) {
            result = 2;
        }
        return result;
    }
}

