/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.wizards;

import com.ibm.jee.batch.core.BatchCorePlugin;
import com.ibm.jee.batch.core.internal.BatchFilesUtil;
import com.ibm.jee.batch.ui.wizards.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class NewBatchJobFileWizardPage
extends WizardPage {
    protected IStructuredSelection structuredSelection;
    private IProject selectedProject;
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private Label jobNameLabel;
    private Text jobNameText;
    private Label restartableNameLabel;
    private Button restartableNameCheck;
    private boolean isRestartable;

    public void setStructuredSelection(IStructuredSelection structuredSelection) {
        this.structuredSelection = structuredSelection;
    }

    protected NewBatchJobFileWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.CreateBatchJobFileWizardPage_title);
        this.setDescription(Messages.CreateBatchJobFileWizardPage_description);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        this.createProjectGroup(top);
        this.createJobNameGroup(top);
        this.createLineSeparator(top);
        this.createAttributesGroup(top);
        this.setControl((Control)top);
        this.setPageComplete(false);
    }

    private void createAttributesGroup(Composite top) {
        this.restartableNameLabel = new Label(top, 0);
        this.restartableNameLabel.setText(Messages.BatchJobWizardPage_Restartable);
        this.restartableNameCheck = new Button(top, 32);
        this.restartableNameCheck.setSelection(true);
        this.setRestartable(true);
        new Label(top, 0);
        this.restartableNameCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Button button = (Button)arg0.getSource();
                if (button.getSelection()) {
                    NewBatchJobFileWizardPage.this.setRestartable(true);
                } else {
                    NewBatchJobFileWizardPage.this.setRestartable(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void createLineSeparator(Composite top) {
        Label advancedSettingsSeparator = new Label(top, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        griddata.verticalIndent = 12;
        advancedSettingsSeparator.setLayoutData((Object)griddata);
    }

    private void createJobNameGroup(Composite top) {
        GridData data = new GridData(768);
        this.jobNameLabel = new Label(top, 0);
        this.jobNameLabel.setText(Messages.BatchJobWizardPage_JobName);
        this.jobNameLabel.setLayoutData((Object)data);
        data = new GridData(768);
        this.jobNameText = new Text(top, 2048);
        this.jobNameText.setLayoutData((Object)data);
        this.jobNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                NewBatchJobFileWizardPage.this.validatePage();
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.jobNameText.setFocus();
        top.setLayoutData((Object)data);
    }

    private void createProjectGroup(Composite parent) {
        GridData data = new GridData(768);
        this.projectNameLabel = new Label(parent, 0);
        this.projectNameLabel.setText(Messages.BatchJobWizardPage_ProjectList);
        this.projectNameLabel.setLayoutData((Object)data);
        data = new GridData(768);
        data.widthHint = 300;
        data.horizontalSpan = 1;
        this.projectNameCombo = new Combo(parent, 2056);
        this.projectNameCombo.setLayoutData((Object)data);
        this.initializeProjectList();
        new Label(parent, 0);
        this.projectNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                IProject project;
                Combo combo = (Combo)arg0.getSource();
                if (combo.getSelectionIndex() >= 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(combo.getText())) != null) {
                    NewBatchJobFileWizardPage.this.setSelectedProject(project);
                    NewBatchJobFileWizardPage.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
    }

    private void initializeProjectList() {
        IProject[] workspaceProjects = ProjectUtilities.getAllProjects();
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < workspaceProjects.length; ++i) {
            IProject project = workspaceProjects[i];
            if (!this.isProjectValid(project)) continue;
            items.add(project.getName());
        }
        if (items.isEmpty()) {
            this.setErrorMessage(Messages.Error_NoBatchProjects);
            this.setPageComplete(false);
            return;
        }
        String[] names = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            names[i] = (String)items.get(i);
        }
        this.projectNameCombo.setItems(names);
        if (this.selectedProject == null) {
            this.setSelectedProject(BatchFilesUtil.getProjectFromSelection((ISelection)this.structuredSelection));
        }
        if (this.selectedProject != null && this.isProjectValid(this.selectedProject)) {
            this.projectNameCombo.setText(this.selectedProject.getName());
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(Messages.Error_Project_Invalid);
            this.setPageComplete(false);
        }
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }

    public boolean isRestartable() {
        return this.isRestartable;
    }

    private void setRestartable(boolean isRestartable) {
        this.isRestartable = isRestartable;
    }

    public String getJobNameText() {
        return this.jobNameText.getText();
    }

    protected boolean isProjectValid(IProject project) {
        boolean result;
        try {
            result = project != null && project.isAccessible() && FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"com.ibm.jee.batch");
        }
        catch (CoreException ce) {
            result = false;
            BatchCorePlugin.logError((CoreException)ce);
        }
        return result;
    }

    private void validatePage() {
        if (this.getJobNameText().isEmpty()) {
            this.setErrorMessage(Messages.Error_BatchJobFile_Empty);
            this.setPageComplete(false);
        } else if (BatchFilesUtil.jobExists((IProject)this.selectedProject, (String)this.getJobNameText())) {
            this.setErrorMessage(Messages.Error_BatchJobFile_Exists);
            this.setPageComplete(false);
        } else if (!this.isProjectValid(this.selectedProject)) {
            this.setErrorMessage(Messages.Error_Project_Invalid);
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }
}

