/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.wizards;

import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.wizards.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.dialogs.TypeSearchEngine;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class NewBatchClassBaseWizardPage
extends NewJavaClassWizardPage {
    protected TableViewer interfaceViewer;
    protected Button useFQNButton;
    protected Button cdiSupportButton;
    protected Button mappingButton;
    protected Button addButton;
    protected Button removeButton;
    protected Text batchId;
    protected Text cdiName;

    public NewBatchClassBaseWizardPage(IDataModel model, String pageName, String pageTitle) {
        super(model, pageName, Messages.NEW_JAVA_CLASS_DESTINATION_WIZARD_PAGE_DESC, pageTitle, null);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.createAbstractSuperClassOptions(composite);
        this.createInterfacesGroup(composite);
        this.addSeperator(composite, 3);
        this.createClassImplementationGroup(composite);
        return composite;
    }

    private void createAbstractSuperClassOptions(Composite parent) {
        boolean makeVisible;
        String supClass = this.getDataModel().getStringProperty("NewBatchClassDataModel.ABSTRACT_SUPERCLASS");
        boolean bl = makeVisible = supClass != null && supClass.length() > 0;
        if (makeVisible) {
            final Button useAbstractSuperClass = new Button(parent, 32);
            useAbstractSuperClass.setText(Messages.USE_ABSTRACT_SUPERCLASS);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            useAbstractSuperClass.setLayoutData((Object)data);
            this.synchHelper.synchCheckbox(useAbstractSuperClass, "NewBatchClassDataModel.USE_ABSTRACT_SUPERCLASS", null);
            useAbstractSuperClass.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (useAbstractSuperClass.getSelection()) {
                        NewBatchClassBaseWizardPage.this.interfaceViewer.remove(NewBatchClassBaseWizardPage.this.getBatchArtifactInterface());
                        NewBatchClassBaseWizardPage.this.model.setProperty("NewJavaClassDataModel.INTERFACES", (Object)NewBatchClassBaseWizardPage.this.getInterfaceViewerItems());
                    } else {
                        NewBatchClassBaseWizardPage.this.interfaceViewer.add(NewBatchClassBaseWizardPage.this.getBatchArtifactInterface());
                        NewBatchClassBaseWizardPage.this.model.setProperty("NewJavaClassDataModel.INTERFACES", (Object)NewBatchClassBaseWizardPage.this.getInterfaceViewerItems());
                    }
                }
            });
        }
    }

    private void createInterfacesGroup(Composite parent) {
        Label interfaceLabel = new Label(parent, 0);
        interfaceLabel.setText(J2EEUIMessages.JAVA_CLASS_INTERFACES_LABEL);
        interfaceLabel.setLayoutData((Object)new GridData(34));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.interfaceViewer = new TableViewer(composite, 2050);
        this.interfaceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.interfaceViewer.setContentProvider((IContentProvider)this.getInterfaceContentProvider());
        this.interfaceViewer.setLabelProvider((IBaseLabelProvider)this.getInterfaceLabelProvider());
        this.interfaceViewer.getControl().addKeyListener(this.getInterfaceKeyListener());
        this.interfaceViewer.setInput(this.model.getProperty("NewJavaClassDataModel.INTERFACES"));
        Composite buttonCompo = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonCompo.setLayout((Layout)layout);
        buttonCompo.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonCompo, 8);
        this.addButton.setText(J2EEUIMessages.ADD_BUTTON_LABEL);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NewBatchClassBaseWizardPage.this.handleInterfaceAddButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton = new Button(buttonCompo, 8);
        this.removeButton.setText(J2EEUIMessages.REMOVE_BUTTON);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NewBatchClassBaseWizardPage.this.handleInterfaceRemoveButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.interfaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (this.isValidSelection()) {
                    NewBatchClassBaseWizardPage.this.removeButton.setEnabled(!selection.isEmpty());
                } else {
                    NewBatchClassBaseWizardPage.this.removeButton.setEnabled(false);
                }
            }

            public boolean isValidSelection() {
                IStructuredSelection selection = (IStructuredSelection)NewBatchClassBaseWizardPage.this.interfaceViewer.getSelection();
                List items = selection.toList();
                return !items.contains(NewBatchClassBaseWizardPage.this.getBatchArtifactInterface());
            }
        });
    }

    protected abstract Object getBatchArtifactInterface();

    protected IStructuredContentProvider getInterfaceContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] ret = new Object[]{};
                if (inputElement instanceof List) {
                    ret = ((List)inputElement).toArray();
                }
                return ret;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ILabelProvider getInterfaceLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");
            }

            public String getText(Object element) {
                String ret = "";
                if (element instanceof String) {
                    ret = (String)element;
                }
                return ret;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    protected KeyListener getInterfaceKeyListener() {
        return new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    NewBatchClassBaseWizardPage.this.handleInterfaceRemoveButtonSelected();
                }
            }
        };
    }

    protected void handleInterfaceAddButtonSelected() {
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
        IJavaSearchScope scope = TypeSearchEngine.createJavaSearchScopeForAProject((IJavaProject)javaProject, (boolean)true, (boolean)true);
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)context, scope, 6);
        dialog.setTitle(J2EEUIMessages.INTERFACE_SELECTION_DIALOG_TITLE);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            String newInterface = "";
            if (type != null) {
                newInterface = type.getFullyQualifiedName();
                List valueList = this.getInterfaceViewerItems();
                if (!valueList.contains(newInterface)) {
                    this.interfaceViewer.add((Object)newInterface);
                    this.model.setProperty("NewJavaClassDataModel.INTERFACES", (Object)this.getInterfaceViewerItems());
                }
            }
        }
    }

    protected void handleInterfaceRemoveButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.interfaceViewer.getSelection();
        List items = selection.toList();
        if (!items.isEmpty()) {
            List valueList = this.getInterfaceViewerItems();
            for (int i = 0; i < items.size(); ++i) {
                valueList.remove(items.get(i));
            }
            this.interfaceViewer.setInput((Object)valueList);
            this.model.setProperty("NewJavaClassDataModel.INTERFACES", (Object)valueList);
        }
    }

    private List getInterfaceViewerItems() {
        TableItem[] items;
        ArrayList<String> list = new ArrayList<String>();
        for (TableItem item : items = this.interfaceViewer.getTable().getItems()) {
            list.add(item.getText());
        }
        return list;
    }

    private void createClassImplementationGroup(Composite parent) {
        Group batchClassMgm = new Group(parent, 16);
        batchClassMgm.setText(Messages.CLASS_IMPLEMENTATION_GROUP_TITLE);
        batchClassMgm.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        batchClassMgm.setLayoutData((Object)data);
        this.useFQNButton = new Button((Composite)batchClassMgm, 16);
        this.useFQNButton.setText(Messages.CLASS_IMPLEMENTATION_OPTION0);
        GridData data0 = new GridData(768);
        data0.horizontalSpan = 2;
        this.useFQNButton.setLayoutData((Object)data0);
        this.synchHelper.synchRadio(this.useFQNButton, "NewBatchClassDataModel.USE_FQ_NAME", null);
        this.cdiSupportButton = new Button((Composite)batchClassMgm, 16);
        this.cdiSupportButton.setText(Messages.CLASS_IMPLEMENTATION_OPTION1);
        GridData data1 = new GridData(768);
        data1.horizontalSpan = 2;
        this.cdiSupportButton.setLayoutData((Object)data1);
        this.synchHelper.synchRadio(this.cdiSupportButton, "NewBatchClassDataModel.USE_CDI", null);
        Label label2 = new Label((Composite)batchClassMgm, 0);
        label2.setText(Messages.CLASS_IMPLEMENTATION_CDI_NAME_FIELD);
        this.cdiName = new Text((Composite)batchClassMgm, 2052);
        GridData data4 = new GridData(768);
        data4.horizontalSpan = 1;
        this.cdiName.setLayoutData((Object)data4);
        this.synchHelper.synchText(this.cdiName, "NewBatchClassDataModel.CDI_NAME", null);
        this.mappingButton = new Button((Composite)batchClassMgm, 16);
        this.mappingButton.setText(Messages.CLASS_IMPLEMENTATION_OPTION2);
        GridData data2 = new GridData(768);
        data2.horizontalSpan = 2;
        this.mappingButton.setLayoutData((Object)data2);
        this.synchHelper.synchRadio(this.mappingButton, "NewBatchClassDataModel.ADD_TO_BATCH_XML", null);
        Label label = new Label((Composite)batchClassMgm, 0);
        label.setText(Messages.CLASS_IMPLEMENTATION_CLASS_ID_FIELD);
        this.batchId = new Text((Composite)batchClassMgm, 2052);
        GridData data3 = new GridData(768);
        data3.horizontalSpan = 1;
        this.batchId.setLayoutData((Object)data3);
        this.synchHelper.synchText(this.batchId, "NewBatchClassDataModel.BATCH_ID", null);
    }

    protected boolean isProjectValid(IProject project) {
        boolean result;
        try {
            result = project.isAccessible() && project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && (JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.web") || JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.ejb") || JavaEEProjectUtilities.getJ2EEProjectType((IProject)project).equals("jst.utility"));
        }
        catch (CoreException ce) {
            result = false;
            BatchUIPlugin.logError(ce);
        }
        return result;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewJavaClassDataModel.CLASS_NAME", "NewJavaClassDataModel.JAVA_PACKAGE", "NewBatchClassDataModel.ADD_TO_BATCH_XML", "NewBatchClassDataModel.BATCH_ID", "NewBatchClassDataModel.USE_CDI", "NewBatchClassDataModel.CDI_NAME"};
    }

    protected boolean showValidationErrorsOnEnter() {
        return true;
    }
}

