/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.wizards;

import com.ibm.jee.batch.ui.BatchUIPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEEditorUtility;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;

public abstract class NewBatchClassBaseWizard
extends DataModelWizard
implements INewWizard {
    protected static final String PAGE_ONE = "pageOne";
    private String createdClassId = "";

    public NewBatchClassBaseWizard(IDataModel model) {
        super(model);
        this.setWindowTitle(this.getTitle());
        this.setDefaultPageImageDescriptor(this.getImage());
    }

    public NewBatchClassBaseWizard() {
    }

    protected abstract String getTitle();

    public void init(IWorkbench arg0, IStructuredSelection arg1) {
        this.getDataModel();
    }

    protected IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = BatchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public boolean canFinish() {
        return this.getDataModel().isValid();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        try {
            if (this.getDataModel().getBooleanProperty("NewBatchClassDataModel.USE_CDI")) {
                this.createdClassId = this.getDataModel().getStringProperty("NewBatchClassDataModel.CDI_NAME");
            } else if (this.getDataModel().getBooleanProperty("NewBatchClassDataModel.ADD_TO_BATCH_XML")) {
                this.createdClassId = this.getDataModel().getStringProperty("NewBatchClassDataModel.BATCH_ID");
            } else if (this.getDataModel().getBooleanProperty("NewBatchClassDataModel.USE_FQ_NAME")) {
                this.createdClassId = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            }
            String className = this.getDataModel().getStringProperty("NewJavaClassDataModel.QUALIFIED_CLASS_NAME");
            IProject p = (IProject)this.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
            IJavaProject javaProject = J2EEEditorUtility.getJavaProject((IProject)p);
            IType type = javaProject.findType(className);
            IFile file = null;
            if (type != null) {
                file = (IFile)type.getResource();
            }
            if (file != null) {
                this.openEditor(file);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void openEditor(final IFile file) {
        if (this.getDataModel().getBooleanProperty("NewJavaClassDataModel.OPEN_IN_EDITOR") && file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected ImageDescriptor getImage() {
        return BatchUIPlugin.getImageDescriptor("icons/wizban/newclass_wiz.gif");
    }

    public String getCreatedClassId() {
        return this.createdClassId;
    }

    public void setProjectName(String projectName) {
        IDataModel dm = this.getDataModel();
        dm.setStringProperty("IArtifactEditOperationDataModelProperties.COMPONENT_NAME", projectName);
    }
}

