/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.handlers;

import com.ibm.jee.batch.core.IBatchConstants;
import com.ibm.jee.batch.core.internal.JSLReferenceUtils;
import com.ibm.jee.batch.ui.dialogs.SelectClassTypeDialog;
import com.ibm.jee.batch.ui.handlers.BatchClassActionHandler;
import com.ibm.jee.batch.ui.utils.ResourceUtils;
import com.ibm.jee.batch.ui.wizards.NewBatchClassBaseWizard;
import com.ibm.jee.batch.ui.wizards.NewBatchletClassWizard;
import com.ibm.jee.batch.ui.wizards.NewCheckpointAlgorithmClassWizard;
import com.ibm.jee.batch.ui.wizards.NewChunkListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewDeciderClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemProcessListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemProcessorClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemReadListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemReaderClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemWriteListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewItemWriterClassWizard;
import com.ibm.jee.batch.ui.wizards.NewJobListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewPartitionAnalyzerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewPartitionCollectorClassWizard;
import com.ibm.jee.batch.ui.wizards.NewPartitionMapperClassWizard;
import com.ibm.jee.batch.ui.wizards.NewPartitionReducerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewRetryProcessListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewRetryReadListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewRetryWriteListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewSkipProcessListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewSkipReadListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewSkipWriteListenerClassWizard;
import com.ibm.jee.batch.ui.wizards.NewStepListenerClassWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NewBatchClassActionHandler
extends BatchClassActionHandler {
    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        if (value != null && !value.isEmpty()) {
            IFile jslFile = (IFile)editorPart.getEditorInput().getAdapter(IFile.class);
            IJavaElement type = JSLReferenceUtils.findReference((String)value, (IProject)jslFile.getProject());
            if (type != null) {
                this.openJavaClassFileInEditor(type);
                return null;
            }
            return this.openNewClassWizard(itemNode, closestAncestor, editorPart);
        }
        return this.openNewClassWizard(itemNode, closestAncestor, editorPart);
    }

    private void openJavaClassFileInEditor(IJavaElement type) {
        if (type != null) {
            IResource resource = type.getResource();
            IPath file = resource.getProjectRelativePath();
            IProject srcProj = resource.getProject();
            IFile target = srcProj.getFile(file);
            if (target != null && target.exists()) {
                ResourceUtils.openResource(target);
            }
        }
    }

    private String openNewClassWizard(Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        String result = null;
        IBatchConstants.BatchClasses[] allowedClasses = this.getClassesForNode(itemNode, closestAncestor);
        if (allowedClasses.length > 0) {
            NewBatchClassBaseWizard wizard = null;
            if (allowedClasses.length == 1) {
                wizard = this.getWizard(allowedClasses[0]);
            } else {
                SelectClassTypeDialog dlg = new SelectClassTypeDialog(this.getShell());
                dlg.setClassTypes(allowedClasses);
                if (dlg.open() == 0) {
                    IBatchConstants.BatchClasses selectedType = dlg.getSelectedClassType();
                    wizard = this.getWizard(selectedType);
                }
            }
            if (wizard != null) {
                WizardDialog dialog;
                IProject project = this.getProject(editorPart);
                if (project != null) {
                    wizard.setProjectName(project.getName());
                }
                if ((dialog = new WizardDialog(this.getShell(), (IWizard)wizard)).open() == 0) {
                    result = wizard.getCreatedClassId();
                }
            }
            return result;
        }
        return result;
    }

    protected NewBatchClassBaseWizard getWizard(IBatchConstants.BatchClasses batchClass) {
        NewBatchClassBaseWizard wizard = null;
        switch (batchClass) {
            case BATCHLET: {
                wizard = new NewBatchletClassWizard();
                break;
            }
            case CHECKPOINT_ALGORITHM: {
                wizard = new NewCheckpointAlgorithmClassWizard();
                break;
            }
            case CHUNK_LISTENER: {
                wizard = new NewChunkListenerClassWizard();
                break;
            }
            case DECIDER: {
                wizard = new NewDeciderClassWizard();
                break;
            }
            case ITEM_PROCESSOR: {
                wizard = new NewItemProcessorClassWizard();
                break;
            }
            case ITEM_PROCESS_LISTENER: {
                wizard = new NewItemProcessListenerClassWizard();
                break;
            }
            case ITEM_READER: {
                wizard = new NewItemReaderClassWizard();
                break;
            }
            case ITEM_READ_LISTENER: {
                wizard = new NewItemReadListenerClassWizard();
                break;
            }
            case ITEM_WRITER: {
                wizard = new NewItemWriterClassWizard();
                break;
            }
            case ITEM_WRITE_LISTENER: {
                wizard = new NewItemWriteListenerClassWizard();
                break;
            }
            case JOB_LISTENER: {
                wizard = new NewJobListenerClassWizard();
                break;
            }
            case PARTITION_ANALYZER: {
                wizard = new NewPartitionAnalyzerClassWizard();
                break;
            }
            case PARTITION_COLLECTOR: {
                wizard = new NewPartitionCollectorClassWizard();
                break;
            }
            case PARTITION_MAPPER: {
                wizard = new NewPartitionMapperClassWizard();
                break;
            }
            case PARTITION_REDUCER: {
                wizard = new NewPartitionReducerClassWizard();
                break;
            }
            case RETRY_PROCESS_LISTENER: {
                wizard = new NewRetryProcessListenerClassWizard();
                break;
            }
            case RETRY_READ_LISTENER: {
                wizard = new NewRetryReadListenerClassWizard();
                break;
            }
            case RETRY_WRITE_LISTENER: {
                wizard = new NewRetryWriteListenerClassWizard();
                break;
            }
            case SKIP_PROCESS_LISTENER: {
                wizard = new NewSkipProcessListenerClassWizard();
                break;
            }
            case SKIP_READ_LISTENER: {
                wizard = new NewSkipReadListenerClassWizard();
                break;
            }
            case SKIP_WRITE_LISTENER: {
                wizard = new NewSkipWriteListenerClassWizard();
                break;
            }
            case STEP_LISTENER: {
                wizard = new NewStepListenerClassWizard();
            }
        }
        return wizard;
    }
}

