/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.handlers;

import com.ibm.jee.batch.core.IBatchConstants;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BatchClassActionHandler
implements IAdvancedCustomizationObject {
    protected IBatchConstants.BatchClasses[] getClassesForNode(Node itemNode, Element closestAncestor) {
        if (itemNode.getNodeName().equals("ref")) {
            ArrayList<IBatchConstants.BatchClasses> result = new ArrayList<IBatchConstants.BatchClasses>();
            String containerElementName = closestAncestor.getNodeName();
            if (containerElementName.equals("batchlet")) {
                result.add(IBatchConstants.BatchClasses.BATCHLET);
            } else if (containerElementName.equals("reader")) {
                result.add(IBatchConstants.BatchClasses.ITEM_READER);
            } else if (containerElementName.equals("writer")) {
                result.add(IBatchConstants.BatchClasses.ITEM_WRITER);
            } else if (containerElementName.equals("processor")) {
                result.add(IBatchConstants.BatchClasses.ITEM_PROCESSOR);
            } else if (containerElementName.equals("decision")) {
                result.add(IBatchConstants.BatchClasses.DECIDER);
            } else if (containerElementName.equals("checkpoint-algorithm")) {
                result.add(IBatchConstants.BatchClasses.CHECKPOINT_ALGORITHM);
            } else if (containerElementName.equals("mapper")) {
                result.add(IBatchConstants.BatchClasses.PARTITION_MAPPER);
            } else if (containerElementName.equals("reducer")) {
                result.add(IBatchConstants.BatchClasses.PARTITION_REDUCER);
            } else if (containerElementName.equals("collector")) {
                result.add(IBatchConstants.BatchClasses.PARTITION_COLLECTOR);
            } else if (containerElementName.equals("analyzer")) {
                result.add(IBatchConstants.BatchClasses.PARTITION_ANALYZER);
            } else if (containerElementName.equals("listener")) {
                Node listenersNode = closestAncestor.getParentNode();
                Node parentOfListeners = listenersNode.getParentNode();
                if (parentOfListeners.getNodeName().equals("job")) {
                    result.add(IBatchConstants.BatchClasses.JOB_LISTENER);
                } else if (parentOfListeners.getNodeName().equals("step")) {
                    boolean stepTypeFound = false;
                    NodeList childNodes = parentOfListeners.getChildNodes();
                    for (int i = 0; i < childNodes.getLength(); ++i) {
                        Node child = childNodes.item(i);
                        if (child.getNodeName().equals("batchlet")) {
                            result.add(IBatchConstants.BatchClasses.STEP_LISTENER);
                            stepTypeFound = true;
                            continue;
                        }
                        if (!child.getNodeName().equals("chunk")) continue;
                        IBatchConstants.BatchClasses[] allowedTypes = new IBatchConstants.BatchClasses[]{IBatchConstants.BatchClasses.STEP_LISTENER, IBatchConstants.BatchClasses.CHUNK_LISTENER, IBatchConstants.BatchClasses.ITEM_READ_LISTENER, IBatchConstants.BatchClasses.ITEM_PROCESS_LISTENER, IBatchConstants.BatchClasses.ITEM_WRITE_LISTENER, IBatchConstants.BatchClasses.SKIP_READ_LISTENER, IBatchConstants.BatchClasses.SKIP_PROCESS_LISTENER, IBatchConstants.BatchClasses.SKIP_WRITE_LISTENER, IBatchConstants.BatchClasses.RETRY_READ_LISTENER, IBatchConstants.BatchClasses.RETRY_PROCESS_LISTENER, IBatchConstants.BatchClasses.RETRY_WRITE_LISTENER};
                        result.addAll(Arrays.asList(allowedTypes));
                        stepTypeFound = true;
                    }
                    if (!stepTypeFound) {
                        result.add(IBatchConstants.BatchClasses.STEP_LISTENER);
                    }
                }
            }
            return result.toArray(new IBatchConstants.BatchClasses[result.size()]);
        }
        return new IBatchConstants.BatchClasses[0];
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected IProject getProject(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            return project;
        }
        return null;
    }
}

