/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.facet;

import com.ibm.jee.batch.ui.BatchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class BatchProjectFacetDetector
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    private static final String BATCH_PROJECT_DECORATOR_ICON = "icons/project-decorator2.png";
    private ImageDescriptor descriptor;

    public void decorate(Object element, IDecoration decoration) {
        IProject project;
        if (element instanceof IProject && this.isBatchDecorableProject(project = (IProject)element)) {
            if (this.descriptor == null) {
                this.descriptor = BatchUIPlugin.getImageDescriptor(BATCH_PROJECT_DECORATOR_ICON);
            }
            decoration.addOverlay(this.descriptor, 0);
        }
    }

    private boolean isBatchDecorableProject(IProject project) {
        try {
            if (!FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"com.ibm.jee.batch") || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.ejb") || FacetedProjectFramework.hasProjectFacet((IProject)project, (String)"jst.web")) {
                return false;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

