/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.editor;

import com.ibm.jee.batch.core.internal.ModelUtils;
import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.Messages;
import com.ibm.jee.batch.ui.dialogs.XMLSubstitutionDialog;
import com.ibm.xwt.dde.customization.ICustomControlObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import java.util.EventListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class SubstitutionCustomObject
implements ICustomControlObject {
    public final void createCustomControl(final Element input, final String itemName, Composite parent, final IEditorPart editorPart, EventListener listener) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.createControl(input, itemName, composite, editorPart);
        Button substitutionButton = new Button(composite, 8);
        substitutionButton.setImage(BatchUIPlugin.getImageDescriptor("icons/obj16/substprops.gif").createImage());
        substitutionButton.setToolTipText(Messages.SUBSTITUTION_TOOLTIP_TEXT);
        substitutionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchPartSite site = editorPart.getSite();
                Shell shell = site != null ? site.getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                XMLSubstitutionDialog dialog = new XMLSubstitutionDialog(shell, input, editorPart, SubstitutionCustomObject.this.getControlText());
                if (dialog.open() == 0) {
                    String newValue = dialog.getXMLSubstitutionValue();
                    SubstitutionCustomObject.this.updateAttribute(input, itemName, newValue);
                    ((DDEMultiPageEditorPart)editorPart).refresh();
                }
            }
        });
    }

    protected String getElementText(Element element, String attributeName) {
        Attr attr = element.getAttributeNode(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return "";
    }

    protected void updateAttribute(Element element, String attributeName, String newValue) {
        Attr attr = element.getAttributeNode(attributeName);
        if (newValue == null || newValue.length() == 0 && ModelUtils.isAttributeOptional((String)attributeName)) {
            if (attr != null) {
                element.removeAttributeNode(attr);
            }
        } else if (!element.getAttribute(attributeName).equals(newValue)) {
            element.setAttribute(attributeName, newValue);
        }
    }

    protected IFile getJobFile(IEditorPart editorPart) {
        IEditorInput editorInput = editorPart.getEditorInput();
        IFile file = null;
        if (editorInput != null) {
            file = (IFile)editorInput.getAdapter(IFile.class);
        }
        return file;
    }

    protected abstract String getControlText();

    protected abstract void createControl(Element var1, String var2, Composite var3, IEditorPart var4);
}

