/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.dialogs;

import com.ibm.jee.batch.core.internal.substitution.OperatorTarget;
import com.ibm.jee.batch.core.internal.substitution.XMLSubstitutionOperator;
import com.ibm.jee.batch.core.internal.substitution.XMLSubstitutionUtils;
import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;

public class XMLSubstitutionDialog
extends TitleAreaDialog {
    private Image dialogImage = null;
    private Text previewValueText = null;
    private String previewText = null;
    private Combo operatorCombo = null;
    private Combo targetCombo = null;
    private Text defaultValueText = null;
    private Element element = null;
    private IEditorPart editorPart = null;
    private String initialValue = null;
    private Map<XMLSubstitutionOperator, List<OperatorTarget>> operatorTargetsMap = new HashMap<XMLSubstitutionOperator, List<OperatorTarget>>();
    private Label statusLabel = null;
    private StatusBar statusBar = new StatusBar();

    public XMLSubstitutionDialog(Shell parentShell, Element element, IEditorPart editorPart, String initialValue) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.element = element;
        this.editorPart = editorPart;
        this.initialValue = initialValue;
        this.previewText = initialValue;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.XML_SUBSTITUTION_DIALOG_TITLE);
        this.setTitle(Messages.XML_SUBSTITUTION_DIALOG_TITLE);
        this.setMessage(Messages.XML_SUBSTITUTION_DIALOG_MESSAGE);
        this.dialogImage = BatchUIPlugin.getImageDescriptor("icons/wizban/subproperty.png").createImage();
        this.setTitleImage(this.dialogImage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Group group = new Group(comp, 32);
        group.setText(Messages.XML_SUBSTITUTION_DIALOG_TITLE);
        GridLayout gridLayout = new GridLayout(5, false);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)new GridData(768));
        Label operatorLabel = new Label((Composite)group, 512);
        operatorLabel.setText(Messages.SUBSTITUTION_OPERATOR);
        this.operatorCombo = new Combo((Composite)group, 8);
        this.operatorCombo.setItems(this.getOperatorComboValues());
        this.operatorCombo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XMLSubstitutionDialog.this.handleOperatorCombo();
            }
        });
        this.operatorCombo.select(0);
        Label operatorValueLabel = new Label((Composite)group, 512);
        operatorValueLabel.setText(Messages.SUBSTITUTION_TARGET);
        this.targetCombo = new Combo((Composite)group, 0);
        this.targetCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.handleOperatorCombo();
        Label defaultLabel = new Label((Composite)group, 512);
        defaultLabel.setText(Messages.SUBSTITUTION_DEFAULT);
        this.defaultValueText = new Text((Composite)group, 2052);
        this.defaultValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        Button insertButton = new Button((Composite)group, 8);
        insertButton.setText(Messages.SUBSTITUTION_INSERT);
        insertButton.setLayoutData((Object)new GridData(131076, 0x1000000, false, true, 1, 1));
        insertButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XMLSubstitutionDialog.this.handleInsertButton(event);
            }
        });
        Composite previewComposite = new Composite(comp, 0);
        previewComposite.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        previewComposite.setLayout((Layout)new GridLayout(2, false));
        Label previewLabel = new Label(previewComposite, 512);
        previewLabel.setText(Messages.SUBSTITUTION_VALUE);
        this.previewValueText = new Text(previewComposite, 2052);
        this.previewValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.previewValueText.setText(this.previewText == null ? "" : this.previewText);
        return comp;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        Label statusSeparatorLabel = new Label(parent, 258);
        statusSeparatorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.statusLabel = new Label(parent, 512);
        this.statusLabel.setLayoutData((Object)new GridData(131072, 131072, true, true, 1, 1));
        return control;
    }

    private void handleOperatorCombo() {
        this.targetCombo.removeAll();
        XMLSubstitutionOperator operator = this.getOperator();
        List<OperatorTarget> validTargets = this.getOperatorTargetValues(operator);
        if (validTargets != null) {
            for (OperatorTarget target : validTargets) {
                this.targetCombo.add(target.toString());
            }
        }
    }

    private List<OperatorTarget> getOperatorTargetValues(final XMLSubstitutionOperator operator) {
        List<OperatorTarget> targetValues = this.operatorTargetsMap.get(operator);
        if (targetValues == null) {
            this.operatorTargetsMap.put(operator, new ArrayList());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    XMLSubstitutionDialog.this.statusBar.startShowingMessage(Messages.SUBSTITUTION_TARGET_STATUS_MESSAGE);
                    List newValues = XMLSubstitutionUtils.getValidTargets((XMLSubstitutionOperator)operator, (Element)XMLSubstitutionDialog.this.element, (IFile)XMLSubstitutionDialog.this.getJobFile());
                    XMLSubstitutionDialog.this.operatorTargetsMap.put(operator, newValues);
                    XMLSubstitutionDialog.this.updateTargetCombo(operator);
                    XMLSubstitutionDialog.this.statusBar.stopShowingMessage();
                }
            };
            new Thread(runnable).start();
        }
        return targetValues;
    }

    private void updateTargetCombo(final XMLSubstitutionOperator operator) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (XMLSubstitutionDialog.this.getOperator().equals((Object)operator)) {
                    List validTargets = XMLSubstitutionDialog.this.getOperatorTargetValues(operator);
                    boolean setListVisible = XMLSubstitutionDialog.this.targetCombo.getListVisible();
                    XMLSubstitutionDialog.this.targetCombo.removeAll();
                    for (OperatorTarget target : validTargets) {
                        XMLSubstitutionDialog.this.targetCombo.add(target.toString());
                    }
                    if (setListVisible) {
                        XMLSubstitutionDialog.this.targetCombo.setListVisible(setListVisible);
                    }
                }
            }
        };
        Display.getDefault().asyncExec(runnable);
    }

    private IFile getJobFile() {
        IEditorInput editorInput = this.editorPart.getEditorInput();
        IFile file = null;
        if (editorInput != null) {
            file = (IFile)editorInput.getAdapter(IFile.class);
        }
        return file;
    }

    private void handleInsertButton(Event event) {
        int caretPosition = this.previewValueText.getCaretPosition();
        int endPosition = this.previewValueText.getText().length();
        StringBuffer sb = new StringBuffer(this.previewValueText.getText().substring(0, caretPosition));
        XMLSubstitutionOperator operator = this.getOperator();
        String targetValue = this.targetCombo.getText();
        int index = this.targetCombo.getSelectionIndex();
        if (index >= 0) {
            List<OperatorTarget> validTargets = this.getOperatorTargetValues(operator);
            OperatorTarget target = validTargets.get(index);
            targetValue = target.getValue();
        }
        String substitutionString = XMLSubstitutionUtils.generateSubstitutionString((XMLSubstitutionOperator)operator, (String)targetValue, (String)this.defaultValueText.getText());
        sb.append(substitutionString);
        sb.append(this.previewValueText.getText().substring(caretPosition, endPosition));
        this.previewValueText.setText(sb.toString());
    }

    private String[] getOperatorComboValues() {
        return new String[]{Messages.SUBSTITUTION_OPERATOR_JOB_PARAMETERS, Messages.SUBSTITUTION_OPERATOR_JOB_PROPERTIES, Messages.SUBSTITUTION_OPERATOR_SYSTEM_PROPERTIES, Messages.SUBSTITUTION_OPERATOR_PARTITION_PLAN};
    }

    private XMLSubstitutionOperator getOperator() {
        int selectedIndex = this.operatorCombo.getSelectionIndex();
        switch (selectedIndex) {
            case 0: {
                return XMLSubstitutionOperator.JOB_PARAMETERS;
            }
            case 1: {
                return XMLSubstitutionOperator.JOB_PROPERTIES;
            }
            case 2: {
                return XMLSubstitutionOperator.SYSTEM_PROPERTIES;
            }
            case 3: {
                return XMLSubstitutionOperator.PARTITION_PLAN;
            }
        }
        return null;
    }

    public boolean close() {
        if (this.dialogImage != null) {
            this.dialogImage.dispose();
        }
        return super.close();
    }

    public String getXMLSubstitutionValue() {
        return this.previewText;
    }

    public void okPressed() {
        this.previewText = this.previewValueText.getText();
        super.okPressed();
    }

    public void cancelPressed() {
        this.previewText = this.initialValue;
        super.cancelPressed();
    }

    private class StatusBar {
        private boolean showMessage = false;

        private StatusBar() {
        }

        public void startShowingMessage(final String message) {
            this.showMessage = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (StatusBar.this.showMessage) {
                        final String progressText = StatusBar.this.getProgressLabel(i++);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (XMLSubstitutionDialog.this.statusLabel != null && !XMLSubstitutionDialog.this.statusLabel.isDisposed()) {
                                    XMLSubstitutionDialog.this.statusLabel.setText(message.concat(progressText));
                                    XMLSubstitutionDialog.this.statusLabel.getParent().layout();
                                }
                            }
                        });
                        if (i == 3) {
                            i = 0;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (XMLSubstitutionDialog.this.statusLabel != null && !XMLSubstitutionDialog.this.statusLabel.isDisposed()) {
                                XMLSubstitutionDialog.this.statusLabel.setText("");
                                XMLSubstitutionDialog.this.statusLabel.getParent().layout();
                            }
                        }
                    });
                }
            };
            new Thread(runnable).start();
        }

        private String getProgressLabel(int i) {
            if (i == 1) {
                return ".  ";
            }
            if (i == 2) {
                return ".. ";
            }
            return "...";
        }

        public void stopShowingMessage() {
            this.showMessage = false;
        }
    }
}

