/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.dialogs;

import com.ibm.jee.batch.core.IBatchConstants;
import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.wizards.Messages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectClassTypeDialog
extends TitleAreaDialog {
    private static final String DTA_CLASS_TYPE = "DTA_CLASS_TYPE";
    private IBatchConstants.BatchClasses[] types = new IBatchConstants.BatchClasses[0];
    private IBatchConstants.BatchClasses selectedClassType;
    private Image dialogImage = null;

    public SelectClassTypeDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SELECT_CLASS_TYPE_DIALOG_DEFAULT_TITTLE);
        this.setMessage(Messages.SELECT_CLASS_TYPE_DIALOG_DEFAULT_MESSAGE);
        this.dialogImage = BatchUIPlugin.getImageDescriptor("icons/wizban/newclass_wiz.gif").createImage();
        this.setTitleImage(this.dialogImage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.createControls(comp);
        return comp;
    }

    private void createControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        int classes = this.types.length;
        if (classes > 0) {
            int numColumns = classes % 3 == 0 ? 3 : 2;
            GridLayout gl = new GridLayout(numColumns, true);
            comp.setLayout((Layout)gl);
        }
        boolean first = true;
        for (IBatchConstants.BatchClasses type : this.types) {
            Button btn = new Button(comp, 16);
            String lbl = null;
            switch (type) {
                case BATCHLET: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_BATCHLET;
                    break;
                }
                case CHUNK_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_CHUNK_LISTENER;
                    break;
                }
                case ITEM_PROCESS_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_PROCESS_LISTENER;
                    break;
                }
                case ITEM_PROCESSOR: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_PROCESSOR;
                    break;
                }
                case ITEM_READ_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_READ_LISTENER;
                    break;
                }
                case ITEM_READER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_READER;
                    break;
                }
                case ITEM_WRITE_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_WRITE_LISTENER;
                    break;
                }
                case ITEM_WRITER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_ITEM_WRITER;
                    break;
                }
                case JOB_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_JOB_LISTENER;
                    break;
                }
                case RETRY_PROCESS_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_RETRY_PROCESSOR_LISTENER;
                    break;
                }
                case RETRY_READ_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_RETRY_READ_LISTENER;
                    break;
                }
                case RETRY_WRITE_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_RETRY_WRITE_LISTENER;
                    break;
                }
                case SKIP_PROCESS_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_SKIP_PROCESS_LISTENER;
                    break;
                }
                case SKIP_READ_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_SKIP_READ_LISTENER;
                    break;
                }
                case SKIP_WRITE_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_SKIP_WRITE_LISTENER;
                    break;
                }
                case STEP_LISTENER: {
                    lbl = Messages.SELECT_CLASS_TYPE_DIALOG_STEP_LISTENER;
                }
            }
            btn.setText(lbl);
            btn.setData(DTA_CLASS_TYPE, (Object)type);
            if (first) {
                btn.setSelection(true);
                this.selectedClassType = type;
                first = false;
            } else {
                btn.setSelection(false);
            }
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button selectedBtn = (Button)e.getSource();
                    SelectClassTypeDialog.this.selectedClassType = (IBatchConstants.BatchClasses)selectedBtn.getData(SelectClassTypeDialog.DTA_CLASS_TYPE);
                }
            });
        }
    }

    public IBatchConstants.BatchClasses getSelectedClassType() {
        return this.selectedClassType;
    }

    public void setClassTypes(IBatchConstants.BatchClasses[] types) {
        this.types = types;
    }

    public boolean close() {
        if (this.dialogImage != null) {
            this.dialogImage.dispose();
        }
        return super.close();
    }
}

