/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.dialogs;

import com.ibm.jee.batch.core.internal.JSLReferenceUtils;
import com.ibm.jee.batch.ui.Messages;
import com.ibm.xwt.dde.customization.ICustomCreationObject;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Text;

public class PropertyCreationDialog
implements ICustomCreationObject {
    public Element create(Element parentElement, IEditorPart editorPart) {
        propertyDialog propertyDialog2 = new propertyDialog(editorPart.getSite().getShell(), parentElement);
        propertyDialog2.create();
        propertyDialog2.getShell().setText(Messages.NEW_PROPERTY_DIALOG_TITLE);
        if (propertyDialog2.open() == 0) {
            Element property = this.appendElement(parentElement, "property");
            this.appendAttr(property, "name", propertyDialog2.propertyName);
            return property;
        }
        return null;
    }

    private Element appendElement(Element parentElement, String childName, String childValue) {
        Document document = parentElement.getOwnerDocument();
        String namespace = parentElement.getOwnerDocument().getDocumentElement().getNamespaceURI();
        Element childElement = document.createElementNS(namespace, childName);
        parentElement.appendChild(childElement);
        if (childValue != null) {
            Text textNode = childElement.getOwnerDocument().createTextNode(childValue);
            childElement.appendChild(textNode);
        }
        return childElement;
    }

    private Element appendAttr(Element parentElement, String attrName, String attrValue) {
        if (attrValue != null && attrName != null) {
            parentElement.setAttribute(attrName, attrValue);
        }
        return parentElement;
    }

    private Element appendElement(Element parentElement, String childName) {
        return this.appendElement(parentElement, childName, null);
    }

    private class propertyDialog
    extends Dialog {
        public String propertyName;
        private Element parentElement;
        private Combo nameCombo;
        private Composite comboComposite;
        private Job lastEclipseJob;
        private List<String> valuesList;
        private IProject activeProject;
        private String javaFile;

        public void refreshCombo() {
            ComboChangeAdapter listener = new ComboChangeAdapter();
            this.lastEclipseJob = new Job(Messages.BATCHPROPERTY_ANNOTATIONS_JOB){

                protected IStatus run(IProgressMonitor monitor) {
                    propertyDialog.this.valuesList = JSLReferenceUtils.findBatchAnnotationAttrValuesFromJavaFile((IProject)propertyDialog.this.activeProject, (String)"BatchProperty", (String)"name", (String)propertyDialog.this.javaFile);
                    return Status.OK_STATUS;
                }
            };
            this.lastEclipseJob.addJobChangeListener((IJobChangeListener)listener);
            this.lastEclipseJob.setPriority(20);
            this.lastEclipseJob.schedule();
        }

        protected propertyDialog(Shell parentShell, Element parentElement) {
            super(parentShell);
            this.nameCombo = null;
            this.comboComposite = null;
            this.setShellStyle(this.getShellStyle() | 0x4F0);
            this.parentElement = parentElement;
        }

        protected Control createDialogArea(Composite parent) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout());
            comp.setLayoutData((Object)new GridData(1808));
            this.comboComposite = new Composite(comp, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            this.comboComposite.setLayout((Layout)gridLayout);
            this.comboComposite.setLayoutData((Object)new GridData(768));
            Label comboLabel = new Label(this.comboComposite, 512);
            comboLabel.setText(Messages.NEW_PROPERTY_NAME);
            this.nameCombo = new Combo(this.comboComposite, 4);
            this.nameCombo.setLayoutData((Object)new GridData(768));
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IFileEditorInput input = (IFileEditorInput)editorPart.getEditorInput();
            IFile file = input.getFile();
            this.activeProject = file.getProject();
            NamedNodeMap parentAttributes = this.parentElement.getParentNode().getAttributes();
            for (int i = 0; i < parentAttributes.getLength(); ++i) {
                if (!parentAttributes.item(i).getNodeName().equals("ref")) continue;
                this.javaFile = parentAttributes.item(i).getNodeValue();
                break;
            }
            this.refreshCombo();
            return comp;
        }

        private String[] setComboValues(List<String> list) {
            String[] arrayValues = new String[list.size()];
            list.toArray(arrayValues);
            return arrayValues;
        }

        protected void okPressed() {
            this.propertyName = this.nameCombo.getText();
            super.okPressed();
        }

        private final class ComboChangeAdapter
        extends JobChangeAdapter {
            private ComboChangeAdapter() {
            }

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!propertyDialog.this.nameCombo.isDisposed()) {
                            String text = propertyDialog.this.nameCombo.getText();
                            Collections.sort(propertyDialog.this.valuesList);
                            propertyDialog.this.nameCombo.setItems(propertyDialog.this.setComboValues(propertyDialog.this.valuesList));
                            if (!text.equals("")) {
                                propertyDialog.this.nameCombo.setText(text);
                                Rectangle bounds = propertyDialog.this.nameCombo.getBounds();
                                Point point = new Point(bounds.x, bounds.x + bounds.width);
                                propertyDialog.this.nameCombo.setSelection(point);
                            } else {
                                propertyDialog.this.nameCombo.select(0);
                            }
                            propertyDialog.this.nameCombo.setFocus();
                        }
                    }
                });
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
                propertyDialog.this.lastEclipseJob = null;
            }
        }
    }
}

