/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.dialogs;

import com.ibm.jee.batch.ui.BatchUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public class MultipleTypeHierarchyScope
implements IJavaSearchScope {
    private IType[] types;
    private List<IJavaSearchScope> scopes = new ArrayList<IJavaSearchScope>();

    public MultipleTypeHierarchyScope(IType[] types) {
        this.types = types;
        for (IType type : types) {
            try {
                IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)type);
                if (scope == null) continue;
                this.scopes.add(scope);
            }
            catch (JavaModelException e) {
                BatchUIPlugin.logError((CoreException)e);
            }
        }
    }

    public boolean encloses(String resourcePath) {
        for (IJavaSearchScope scope : this.scopes) {
            if (!scope.encloses(resourcePath)) continue;
            return true;
        }
        return false;
    }

    public boolean encloses(IJavaElement element) {
        for (IJavaSearchScope scope : this.scopes) {
            if (!scope.encloses(element)) continue;
            return true;
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        HashSet<IPath> paths = new HashSet<IPath>();
        for (IJavaSearchScope scope : this.scopes) {
            paths.addAll(Arrays.asList(scope.enclosingProjectsAndJars()));
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    @Deprecated
    public boolean includesBinaries() {
        for (IJavaSearchScope scope : this.scopes) {
            if (!scope.includesBinaries()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean includesClasspaths() {
        for (IJavaSearchScope scope : this.scopes) {
            if (!scope.includesClasspaths()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void setIncludesBinaries(boolean includesBinaries) {
        for (IJavaSearchScope scope : this.scopes) {
            scope.setIncludesBinaries(includesBinaries);
        }
    }

    @Deprecated
    public void setIncludesClasspaths(boolean includesClasspaths) {
        for (IJavaSearchScope scope : this.scopes) {
            scope.setIncludesClasspaths(includesClasspaths);
        }
    }

    public IType[] getTypes() {
        return this.types;
    }
}

