/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.dialogs;

import com.ibm.jee.batch.core.IBatchConstants;
import com.ibm.jee.batch.core.internal.StringUtils;
import com.ibm.jee.batch.internal.operations.batch.xml.BatchXmlParser;
import com.ibm.jee.batch.internal.operations.batch.xml.Reference;
import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.Messages;
import com.ibm.jee.batch.ui.dialogs.BatchReferencesContentProvider;
import com.ibm.jee.batch.ui.dialogs.MultipleTypeHierarchyScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.PageBook;
import org.xml.sax.SAXException;

public class BrowseBatchClassDialog
extends FilteredTypesSelectionDialog
implements SelectionListener {
    private Object[] localResult;
    private IJavaSearchScope javaSearchScope;
    private IFile batchXmlFile;
    private IBatchConstants.BatchClasses[] batchClasses;
    private boolean useCDIForSelectedClass;
    private Composite pageBookContainerComposite;
    private Button browseClassesChkButton;
    private Button browseBatchXmlChkButton;
    private PageBook pageBook;
    private Control browseClassesControl;
    private Control browseBatchXmlReferencesControl;
    private Control selectedControl;
    private TreeViewer batchReferencesTable;
    private Button chkUseCDIName;
    private Label lblUseCDIName;
    private Text txtCDIName;

    public BrowseBatchClassDialog(Shell parent, IRunnableContext context, IJavaSearchScope scope, IBatchConstants.BatchClasses[] batchClasses, IFile batchXmlFile) {
        super(parent, false, context, scope, 5);
        this.batchClasses = batchClasses;
        this.batchXmlFile = batchXmlFile;
        this.javaSearchScope = scope;
        this.setTitle(Messages.BrowseBatchClassDialog_Title);
        this.addListFilter(new PackageViewerFilter());
    }

    protected Control createDialogArea(Composite parent) {
        this.pageBookContainerComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        this.pageBookContainerComposite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pageBookContainerComposite.setLayoutData((Object)gd);
        this.browseClassesChkButton = new Button(this.pageBookContainerComposite, 16);
        this.browseClassesChkButton.setText(Messages.BrowseBatchClassDialog_SearchForClasses);
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.verticalIndent = 20;
        this.browseClassesChkButton.setLayoutData((Object)gd);
        this.browseClassesChkButton.setSelection(true);
        this.browseClassesChkButton.addSelectionListener((SelectionListener)this);
        this.browseBatchXmlChkButton = new Button(this.pageBookContainerComposite, 16);
        this.browseBatchXmlChkButton.setText(Messages.BrowseBatchClassDialog_BrowseBatchXML);
        gd = new GridData();
        gd.horizontalIndent = 10;
        gd.verticalIndent = 20;
        this.browseBatchXmlChkButton.setLayoutData((Object)gd);
        this.browseBatchXmlChkButton.addSelectionListener((SelectionListener)this);
        this.browseBatchXmlChkButton.setEnabled(this.batchXmlFile != null);
        this.pageBook = new PageBook(this.pageBookContainerComposite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.pageBook.setLayoutData((Object)gd);
        this.browseClassesControl = this.getBrowseClassesControl((Composite)this.pageBook);
        gd = new GridData(1808);
        this.browseClassesControl.setLayoutData((Object)gd);
        if (this.batchXmlFile != null) {
            this.browseBatchXmlReferencesControl = this.getBatchXmlReferencesControl((Composite)this.pageBook);
            gd = new GridData(1808);
            this.browseBatchXmlReferencesControl.setLayoutData((Object)gd);
        }
        this.pageBook.showPage(this.browseClassesControl);
        this.selectedControl = this.browseClassesControl;
        return parent;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(768));
        this.chkUseCDIName = new Button(composite, 32);
        this.chkUseCDIName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                BrowseBatchClassDialog.this.useCDIForSelectedClass = btn.getSelection();
            }
        });
        this.chkUseCDIName.setEnabled(false);
        this.lblUseCDIName = new Label(composite, 0);
        this.lblUseCDIName.setText(Messages.BrowseBatchClassDialog_UseCDIName);
        this.lblUseCDIName.setEnabled(false);
        this.txtCDIName = new Text(composite, 8);
        GridData gridData = new GridData(768);
        this.txtCDIName.setLayoutData((Object)gridData);
        this.txtCDIName.setEnabled(false);
        return composite;
    }

    private Control getBatchXmlReferencesControl(Composite parent) {
        Composite com = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        com.setLayout((Layout)layout);
        com.setLayoutData((Object)new GridData(1808));
        com.setFont(parent.getFont());
        Label lblDescription = new Label(com, 0);
        lblDescription.setText(Messages.BrowseBatchClassDialog_BatchXMLTableCaption);
        GridData gd = new GridData(768);
        lblDescription.setLayoutData((Object)gd);
        BatchXmlParser parser = new BatchXmlParser(this.batchXmlFile);
        boolean parsedOK = true;
        try {
            parser.parse();
        }
        catch (SAXException e) {
            BatchUIPlugin.logError(e);
            parsedOK = false;
        }
        catch (IOException e) {
            BatchUIPlugin.logError(e);
            parsedOK = false;
        }
        catch (ParserConfigurationException e) {
            BatchUIPlugin.logError(e);
            parsedOK = false;
        }
        ArrayList references = null;
        references = !parsedOK ? new ArrayList() : parser.getReferences();
        int style = 2052;
        Tree tree = new Tree(com, style);
        this.batchReferencesTable = new TreeViewer(tree);
        gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tree.setLayout((Layout)tableLayout);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn idColumn = new TreeColumn(tree, 0, 0);
        idColumn.setText(Messages.BrowseBatchClassDialog_BatchXMLTableColumnId);
        idColumn.setResizable(true);
        TreeColumn classColumn = new TreeColumn(tree, 0, 1);
        classColumn.setText(Messages.BrowseBatchClassDialog_BatchXMLTableColumnClass);
        classColumn.setResizable(true);
        tableLayout.layout((Composite)tree, true);
        BatchReferencesContentProvider provider = new BatchReferencesContentProvider();
        this.batchReferencesTable.setContentProvider((IContentProvider)provider);
        this.batchReferencesTable.setLabelProvider((IBaseLabelProvider)provider);
        IProject project = this.batchXmlFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        this.batchReferencesTable.addFilter((ViewerFilter)new BatchClassesViewerFilter(javaProject, this.batchClasses));
        this.batchReferencesTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseBatchClassDialog.this.updateOKButton();
            }
        });
        this.batchReferencesTable.setInput(references);
        return com;
    }

    private Control getBrowseClassesControl(Composite parent) {
        return super.createDialogArea(parent);
    }

    protected void computeResult() {
        super.computeResult();
        if (this.selectedControl == this.browseClassesControl) {
            Object[] result = super.getResult();
            if (result == null) {
                this.localResult = result;
            } else {
                String[] sResult = new String[1];
                IType selection = (IType)result[0];
                sResult[0] = this.isUseCDIForSelectedClass() ? this.getCDIName(selection) : selection.getFullyQualifiedName();
                this.localResult = sResult;
            }
        } else if (this.selectedControl == this.browseBatchXmlReferencesControl) {
            Object[] result = new Object[1];
            ISelection sel = this.batchReferencesTable.getSelection();
            StructuredSelection sSel = (StructuredSelection)sel;
            Reference ref = (Reference)sSel.getFirstElement();
            result[0] = ref.getId();
            this.localResult = result;
        } else {
            this.localResult = new Object[0];
        }
    }

    public Object[] getResult() {
        return this.localResult;
    }

    private boolean isUseCDIForSelectedClass() {
        return this.useCDIForSelectedClass;
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        Object element = selection.getFirstElement();
        if (element instanceof TypeNameMatch) {
            String cdiName;
            IType tElement;
            TypeNameMatch tnm = (TypeNameMatch)element;
            this.updateCDIPanelForSelection(tElement, cdiName, (cdiName = this.getCDIName(tElement = tnm.getType())) != null);
        }
    }

    private void updateCDIPanelForSelection(IType tElement, String cdiName, boolean cdiEnabled) {
        this.chkUseCDIName.setEnabled(cdiEnabled);
        this.lblUseCDIName.setEnabled(cdiEnabled);
        this.txtCDIName.setEnabled(cdiEnabled);
        if (cdiEnabled) {
            this.txtCDIName.setText(cdiName);
        } else {
            this.txtCDIName.setText("");
            this.chkUseCDIName.setSelection(false);
            this.useCDIForSelectedClass = false;
        }
    }

    private String getCDIName(IType type) {
        try {
            IAnnotation[] annotations = type.getAnnotations();
            IAnnotation namedAnnotation = null;
            for (IAnnotation annotation : annotations) {
                if (!"javax.inject.Named".endsWith(annotation.getElementName())) continue;
                namedAnnotation = annotation;
            }
            if (namedAnnotation != null) {
                IMemberValuePair[] mvps = namedAnnotation.getMemberValuePairs();
                String cdiName = null;
                cdiName = mvps.length == 0 ? StringUtils.makeFirstLetterLowerCase((String)type.getElementName()) : (String)mvps[0].getValue();
                return cdiName;
            }
            return null;
        }
        catch (JavaModelException e) {
            BatchUIPlugin.logError((CoreException)e);
            return null;
        }
    }

    private void updateOKButton() {
        Button okButton = this.getOkButton();
        if (this.selectedControl == this.browseClassesControl) {
            okButton.setEnabled(this.getSelectedItems().size() > 0);
        } else if (this.selectedControl == this.browseBatchXmlReferencesControl) {
            okButton.setEnabled(this.validateSelectionInBatchXML().isOK());
        }
    }

    public static IJavaSearchScope buildSearchScope(IBatchConstants.BatchClasses[] batchClasses, IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        ArrayList<IType> types = new ArrayList<IType>();
        try {
            for (IBatchConstants.BatchClasses batchClassToSearch : batchClasses) {
                IType type = jProject.findType(batchClassToSearch.getBatchInterface());
                if (type == null) continue;
                types.add(type);
            }
            IType[] typesArray = types.toArray(new IType[types.size()]);
            if (typesArray.length == 0) {
                return null;
            }
            Object scope = null;
            scope = typesArray.length == 1 ? SearchEngine.createHierarchyScope((IType)typesArray[0]) : new MultipleTypeHierarchyScope(typesArray);
            return scope;
        }
        catch (JavaModelException e) {
            BatchUIPlugin.logError((CoreException)e);
            return null;
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource().equals(this.browseBatchXmlChkButton) && this.browseBatchXmlChkButton.getSelection()) {
            this.pageBook.showPage(this.browseBatchXmlReferencesControl);
            this.selectedControl = this.browseBatchXmlReferencesControl;
            this.updateOKButton();
        } else if (event.getSource().equals(this.browseClassesChkButton) && this.browseClassesChkButton.getSelection()) {
            this.pageBook.showPage(this.browseClassesControl);
            this.selectedControl = this.browseClassesControl;
            this.updateOKButton();
        }
    }

    protected void okPressed() {
        if (this.selectedControl == this.browseBatchXmlReferencesControl) {
            this.updateStatus(this.validateSelectionInBatchXML());
        }
        super.okPressed();
    }

    protected IStatus validateSelectionInBatchXML() {
        if (this.batchReferencesTable.getSelection().isEmpty()) {
            return new Status(4, "com.ibm.jee.batch.core", 4, "", null);
        }
        return Status.OK_STATUS;
    }

    private class PackageViewerFilter
    extends ViewerFilter {
        private final String[] filteredPackages = new String[]{"java.lang", "javax.batch.api"};

        private PackageViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = true;
            if (element instanceof TypeNameMatch) {
                TypeNameMatch tnm = (TypeNameMatch)element;
                IType tElement = tnm.getType();
                IPackageFragment pf = tElement.getPackageFragment();
                for (String filteredPackage : this.filteredPackages) {
                    if (!pf.getElementName().startsWith(filteredPackage)) continue;
                    result = false;
                }
            }
            return result;
        }
    }

    private class BatchClassesViewerFilter
    extends ViewerFilter {
        private List<IType> types = new ArrayList<IType>();
        private IJavaProject javaProject;

        BatchClassesViewerFilter(IJavaProject javaProject, IBatchConstants.BatchClasses[] classes) {
            this.javaProject = javaProject;
            for (IBatchConstants.BatchClasses batchClass : classes) {
                try {
                    IType type = javaProject.findType(batchClass.getBatchInterface());
                    if (type == null) continue;
                    this.types.add(type);
                }
                catch (JavaModelException e) {
                    BatchUIPlugin.logError((CoreException)e);
                }
            }
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            return true;
        }
    }
}

