/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.browsers;

import com.ibm.jee.batch.core.IBatchConstants;
import com.ibm.jee.batch.core.internal.BatchFilesUtil;
import com.ibm.jee.batch.ui.dialogs.BrowseBatchClassDialog;
import com.ibm.jee.batch.ui.handlers.BatchClassActionHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BatchClassReferenceBrowser
extends BatchClassActionHandler {
    public String invoke(String value, Node itemNode, Element closestAncestor, IEditorPart editorPart) {
        IProject project;
        String result = null;
        IBatchConstants.BatchClasses[] classesToBrowse = this.getClassesForNode(itemNode, closestAncestor);
        if (classesToBrowse.length > 0 && (project = this.getProject(editorPart)) != null) {
            IJavaSearchScope scope = BrowseBatchClassDialog.buildSearchScope(classesToBrowse, project);
            if (scope == null) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
            }
            if (scope != null) {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                IFile batchXmlFile = BatchFilesUtil.getBatchXmlFile((IProject)project);
                BrowseBatchClassDialog dialog = new BrowseBatchClassDialog(this.getShell(), (IRunnableContext)progressService, scope, classesToBrowse, batchXmlFile);
                dialog.setInitialSelections(new String[]{value});
                if (dialog.open() == 0) {
                    result = (String)dialog.getResult()[0];
                }
            }
        }
        return result;
    }
}

