/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jee.batch.ui.assist;

import com.ibm.jee.batch.core.internal.substitution.OperatorTarget;
import com.ibm.jee.batch.core.internal.substitution.XMLSubstitutionOperator;
import com.ibm.jee.batch.core.internal.substitution.XMLSubstitutionUtils;
import com.ibm.jee.batch.ui.BatchUIPlugin;
import com.ibm.jee.batch.ui.Messages;
import com.ibm.jee.batch.ui.editor.FlowElementsAndDecisionValues;
import com.ibm.jee.batch.ui.editor.FlowElementsValues;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BatchSubstitutionCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private static final String POUND = "#";
    private static final String SEMICOLON = ";";
    private static final String EQUALS = "=";
    private static final String QUOTE = "\"";
    private static final String RIGHT_BRACKET = "]";
    private static final String RIGHT_CURLY_BRACKET = "}";
    private static final String LEFT_CURLY_BRACKET = "{";
    private static final String APOSTROPHE = "'";
    private static final String POUND_WITH_LEFT_BRACKET = "#{";
    private static final String RIGHT_BRACKET_WITH_RIGHT_CURLY_BRACKET = "]}";
    private static final String DEFAULT_EXPRESSION = "?:;";

    protected void addAttributeValueProposals(ContentAssistRequest request, CompletionProposalInvocationContext context) {
        Attr attribute;
        Node node = request.getNode();
        if (node == null) {
            return;
        }
        String selectedText = "";
        int offset = context.getViewer().getSelectedRange().x;
        int length = context.getViewer().getSelectedRange().y;
        if (length > 0) {
            try {
                selectedText = context.getDocument().get(offset, length);
            }
            catch (BadLocationException e) {
                BatchUIPlugin.logError(e);
            }
        }
        if ((attribute = this.getAttributeNode(request)) == null || attribute.getName().equals("id")) {
            return;
        }
        this.handleJobXMLSubstitutionProposals(attribute, context, request, offset, selectedText);
        this.handleNextProposals(attribute, context, request, offset, selectedText);
        this.handleFlowProposals(attribute, context, request, offset, selectedText);
    }

    private void handleFlowProposals(Attr attribute, CompletionProposalInvocationContext context, ContentAssistRequest request, int offset, String selectedText) {
        if (!attribute.getName().equals("next")) {
            return;
        }
        String currValue = attribute.getValue();
        String leftChar = this.getCharsFromCurrentPosition(context, 1, Direction.LEFT);
        if (!leftChar.equals(QUOTE) && !leftChar.equals(EQUALS)) {
            return;
        }
        boolean wrapWithQuotes = leftChar.equals(EQUALS) || currValue.length() == 0 && !leftChar.equals(QUOTE);
        FlowElementsAndDecisionValues flowValues = new FlowElementsAndDecisionValues();
        Map<String, String> values = flowValues.getPosibleValues(null, null, null, (IResource)this.getCurrentFile());
        for (String key : values.keySet()) {
            String proposal = this.generateProposalString(wrapWithQuotes, key);
            request.addProposal((ICompletionProposal)new CompletionProposal(proposal, offset, selectedText.length(), proposal.length(), null, key, null, null));
        }
    }

    private void handleNextProposals(Attr attribute, CompletionProposalInvocationContext context, ContentAssistRequest request, int offset, String selectedText) {
        if (!attribute.getName().equals("to") && !attribute.getName().equals("restart")) {
            return;
        }
        String currValue = attribute.getValue();
        String leftChar = this.getCharsFromCurrentPosition(context, 1, Direction.LEFT);
        if (!leftChar.equals(QUOTE) && !leftChar.equals(EQUALS)) {
            return;
        }
        boolean wrapWithQuotes = leftChar.equals(EQUALS) || currValue.length() == 0 && !leftChar.equals(QUOTE);
        FlowElementsValues flowValues = new FlowElementsValues();
        Map<String, String> values = flowValues.getPosibleValues(null, null, null, (IResource)this.getCurrentFile());
        for (String key : values.keySet()) {
            String proposal = this.generateProposalString(wrapWithQuotes, key);
            request.addProposal((ICompletionProposal)new CompletionProposal(proposal, offset, selectedText.length(), proposal.length(), null, key, null, null));
        }
    }

    private void handleJobXMLSubstitutionProposals(Attr attribute, CompletionProposalInvocationContext context, ContentAssistRequest request, int offset, String selectedText) {
        XMLSubstitutionOperator selectedOperator;
        String currValue = attribute.getValue();
        String leftChar = this.getCharsFromCurrentPosition(context, 1, Direction.LEFT);
        String left2Chars = this.getCharsFromCurrentPosition(context, 2, Direction.LEFT);
        String rightChar = this.getCharsFromCurrentPosition(context, 1, Direction.RIGHT);
        boolean wrapWithQuotes = leftChar.equals(EQUALS) || currValue.length() == 0 && !leftChar.equals(QUOTE);
        boolean showOperators = leftChar.equals(EQUALS) || leftChar.equals(QUOTE) || rightChar.equals(QUOTE) || leftChar.equals(RIGHT_CURLY_BRACKET) || leftChar.equals(POUND) || left2Chars.equals(POUND_WITH_LEFT_BRACKET) || leftChar.equals(SEMICOLON) || leftChar.equals(APOSTROPHE) && !rightChar.equals(RIGHT_BRACKET);
        boolean showTargets = leftChar.equals(APOSTROPHE);
        boolean showDefault = left2Chars.equals(RIGHT_BRACKET_WITH_RIGHT_CURLY_BRACKET);
        if (showOperators) {
            for (XMLSubstitutionOperator operator : XMLSubstitutionOperator.values()) {
                String leftText = POUND_WITH_LEFT_BRACKET;
                int cursorPosition = operator.toString().length() == 16 ? 20 : 17;
                int n = cursorPosition = wrapWithQuotes ? cursorPosition + 1 : cursorPosition;
                if (leftChar.equals(POUND)) {
                    --cursorPosition;
                    leftText = LEFT_CURLY_BRACKET;
                } else if (left2Chars.equals(POUND_WITH_LEFT_BRACKET)) {
                    cursorPosition -= 2;
                    leftText = "";
                }
                String proposal = this.generateProposalString(wrapWithQuotes, leftText, operator.toString(), "['']}");
                request.addProposal((ICompletionProposal)new CompletionProposal(proposal.toString(), offset, selectedText.length(), cursorPosition, BatchUIPlugin.getImageDescriptor("icons/obj16/substprops.gif").createImage(), operator.toString(), null, this.getAdditionalOperatorInfo(operator)));
            }
        }
        if (showTargets && (selectedOperator = this.getSelectedOperator(context)) != null) {
            IFile jobFile = this.getCurrentFile();
            List targets = XMLSubstitutionUtils.getValidTargets((XMLSubstitutionOperator)selectedOperator, (Element)((Element)request.getNode()), (IFile)jobFile);
            for (OperatorTarget target : targets) {
                request.addProposal((ICompletionProposal)new CompletionProposal(target.getValue(), offset, selectedText.length(), target.getValue().length(), BatchUIPlugin.getImageDescriptor("icons/obj16/properties-node.png").createImage(), this.generateProposalString(false, target.getValue(), " - ", target.getOwner()), null, this.getAdditionalOperatorTargetInfo(selectedOperator, target)));
            }
        }
        if (showDefault) {
            request.addProposal((ICompletionProposal)new CompletionProposal(DEFAULT_EXPRESSION, offset, selectedText.length(), 2, null, Messages.PROPOSAL_SUBSTITUTION_DEFAULT, null, Messages.PROPOSAL_ADDITIONAL_SUBSTITUTION_DEFAULT));
        }
    }

    private String getAdditionalOperatorTargetInfo(XMLSubstitutionOperator selectedOperator, OperatorTarget target) {
        String additionalInfo = "";
        switch (selectedOperator) {
            case JOB_PARAMETERS: {
                additionalInfo = Messages.bind((String)Messages.PROPOSAL_SUBSTITUTION_JOB_PARAMETERS_TARGET, (Object)target.getOwner());
                break;
            }
            case JOB_PROPERTIES: {
                additionalInfo = Messages.bind((String)Messages.PROPOSAL_SUBSTITUTION_JOB_PROPERTIES_TARGET, (Object)target.getOwner());
                break;
            }
            case PARTITION_PLAN: {
                additionalInfo = Messages.PROPOSAL_SUBSTITUTION_PARTITION_PLAN_TARGET;
                break;
            }
            case SYSTEM_PROPERTIES: {
                additionalInfo = Messages.bind((String)Messages.PROPOSAL_SUBSTITUTION_SYSTEM_PROPERTIES_TARGET, (Object)target.getOwner());
            }
        }
        return additionalInfo;
    }

    private String getAdditionalOperatorInfo(XMLSubstitutionOperator operator) {
        String additionalInfo = "";
        switch (operator) {
            case JOB_PARAMETERS: {
                additionalInfo = Messages.PROPOSAL_SUBSTITUTION_JOB_PARAMETERS;
                break;
            }
            case JOB_PROPERTIES: {
                additionalInfo = Messages.PROPOSAL_SUBSTITUTION_JOB_PROPERTIES;
                break;
            }
            case PARTITION_PLAN: {
                additionalInfo = Messages.PROPOSAL_SUBSTITUTION_PARTITION_PLAN;
                break;
            }
            case SYSTEM_PROPERTIES: {
                additionalInfo = Messages.PROPOSAL_SUBSTITUTION_SYSTEM_PROPERTIES;
            }
        }
        return additionalInfo;
    }

    private String generateProposalString(boolean wrapWithQuotes, String ... elements) {
        StringBuffer sb = new StringBuffer();
        for (String element : elements) {
            sb.append(element);
        }
        if (wrapWithQuotes) {
            StringBuffer tmp = new StringBuffer(sb.length() + 2);
            tmp.append(QUOTE);
            tmp.append(sb.toString());
            tmp.append(QUOTE);
            sb = tmp;
        }
        return sb.toString();
    }

    private IFile getCurrentFile() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        return ((FileEditorInput)editor.getEditorInput()).getFile();
    }

    private String getCharsFromCurrentPosition(CompletionProposalInvocationContext context, int length, Direction direction) {
        int offset = context.getInvocationOffset();
        String leftChar = "";
        try {
            leftChar = context.getDocument().get(offset + direction.getValue() * length, length);
        }
        catch (BadLocationException e) {
            BatchUIPlugin.logError(e);
        }
        return leftChar;
    }

    private XMLSubstitutionOperator getSelectedOperator(CompletionProposalInvocationContext context) {
        int offset = context.getInvocationOffset();
        try {
            String operatorText = context.getDocument().get(offset - 15, 13);
            if (operatorText.equals(XMLSubstitutionOperator.JOB_PROPERTIES.toString())) {
                return XMLSubstitutionOperator.JOB_PROPERTIES;
            }
            if (operatorText.equals(XMLSubstitutionOperator.JOB_PARAMETERS.toString())) {
                return XMLSubstitutionOperator.JOB_PARAMETERS;
            }
            if (operatorText.equals(XMLSubstitutionOperator.PARTITION_PLAN.toString())) {
                return XMLSubstitutionOperator.PARTITION_PLAN;
            }
            if (context.getDocument().get(offset - 18, 16).equals(XMLSubstitutionOperator.SYSTEM_PROPERTIES.toString())) {
                return XMLSubstitutionOperator.SYSTEM_PROPERTIES;
            }
        }
        catch (BadLocationException e) {
            BatchUIPlugin.logError(e);
        }
        return null;
    }

    private Attr getAttributeNode(ContentAssistRequest request) {
        Node node = request.getNode();
        if (node == null) {
            return null;
        }
        Attr attr = null;
        block0 : switch (node.getNodeType()) {
            case 2: {
                attr = (Attr)node;
                break;
            }
            case 1: {
                Element elem = (Element)node;
                ITextRegion valueRegion = request.getRegion();
                IStructuredDocumentRegion docRegion = request.getDocumentRegion();
                if (valueRegion == null || docRegion == null) break;
                ITextRegionList textRegions = docRegion.getRegions();
                int index = textRegions.indexOf(valueRegion) - 1;
                while (index >= 0) {
                    ITextRegion textRegion;
                    if (!"XML_TAG_ATTRIBUTE_NAME".equals((textRegion = textRegions.get(index--)).getType())) continue;
                    String name = docRegion.getFullText(textRegion);
                    attr = elem.getAttributeNode(name);
                    break block0;
                }
                break;
            }
        }
        return attr;
    }

    static enum Direction {
        LEFT(-1),
        RIGHT(0);

        private int value = 0;

        private Direction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

