/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.webproject.wizard.internal.management;

import com.ibm.faceted.project.wizard.core.management.IExtensionPointManager;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSet;
import com.ibm.faceted.project.wizard.core.management.extensionpts.ICoreFacetSetApprover;
import com.ibm.faceted.project.wizard.core.management.extensionpts.IProjectTemplate;
import java.util.Comparator;
import java.util.HashMap;

public class CoreFacetSetManager
implements Comparator<ICoreFacetSet>,
ICoreFacetSetApprover {
    private HashMap<ICoreFacetSet, Integer> validProgrammingModels;
    private ICoreFacetSet javaeeProgrammingModel;
    private ICoreFacetSet clientProgrammingModel;
    private ICoreFacetSet osgiJavaEEProgrammingModel;
    private static final String CLIENT_PROGRAMMING_MODEL_ID = "com.ibm.etools.webtools.webproject.wizard.programmingModel.client";
    private static final String JAVAEE_PROGRAMMING_MODEL_ID = "com.ibm.etools.j2ee.ui.webproject.programmingModel.javaee";
    private static final String OSGI_JAVAEE_PROGRAMMING_MODEL_ID = "com.ibm.etools.aries.ui.webproject.programmingModel.osgi-javaee";
    private final IExtensionPointManager wizardLevelExtPtMgr;

    public CoreFacetSetManager(IExtensionPointManager wizardLevelExtPtMgr) {
        this.wizardLevelExtPtMgr = wizardLevelExtPtMgr;
    }

    public boolean approveCoreFacetSetForTemplate(IProjectTemplate template, ICoreFacetSet programmingModel) {
        if (this.validProgrammingModels == null) {
            this.validProgrammingModels = new HashMap();
            this.clientProgrammingModel = this.wizardLevelExtPtMgr.getCoreFacetSetById(CLIENT_PROGRAMMING_MODEL_ID);
            if (this.clientProgrammingModel != null) {
                this.validProgrammingModels.put(this.clientProgrammingModel, 1);
            }
            this.javaeeProgrammingModel = this.wizardLevelExtPtMgr.getCoreFacetSetById(JAVAEE_PROGRAMMING_MODEL_ID);
            if (this.javaeeProgrammingModel != null) {
                this.validProgrammingModels.put(this.javaeeProgrammingModel, 2);
            }
            this.osgiJavaEEProgrammingModel = this.wizardLevelExtPtMgr.getCoreFacetSetById(OSGI_JAVAEE_PROGRAMMING_MODEL_ID);
            if (this.osgiJavaEEProgrammingModel != null) {
                this.validProgrammingModels.put(this.osgiJavaEEProgrammingModel, 3);
            }
        }
        return this.validProgrammingModels.containsKey(programmingModel);
    }

    @Override
    public int compare(ICoreFacetSet pm1, ICoreFacetSet pm2) {
        Integer pm1Value = this.validProgrammingModels.get(pm1);
        Integer pm2Value = this.validProgrammingModels.get(pm2);
        if (pm1Value == null) {
            pm1Value = -1;
        }
        if (pm2Value == null) {
            pm2Value = -1;
        }
        return pm1Value.compareTo(pm2Value);
    }

    public ICoreFacetSet getClientProgrammingModel() {
        return this.clientProgrammingModel;
    }

    public ICoreFacetSet getJavaeeProgrammingModel() {
        return this.javaeeProgrammingModel;
    }

    public ICoreFacetSet getOsgiJavaEEProgrammingModel() {
        return this.osgiJavaEEProgrammingModel;
    }

    public boolean hasClientProgrammingModel() {
        return this.clientProgrammingModel != null;
    }

    public boolean hasJavaeeProgrammingModel() {
        return this.javaeeProgrammingModel != null;
    }

    public boolean hasOsgiJavaEEProgrammingModel() {
        return this.osgiJavaEEProgrammingModel != null;
    }
}

