/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.wizards;

import com.ibm.etools.openapi.core.util.OpenApiFileHandler;
import com.ibm.etools.openapi.core.util.SwaggerFileHandler;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIMessages;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUIPlugin;
import com.ibm.etools.swagger.rest.api.ui.util.ProjectUtils;
import com.ibm.etools.swagger.rest.api.ui.wizards.SwaggerFileWizardPageOne;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class SwaggerFileSelectionWizard
extends Wizard
implements INewWizard {
    private static final String PAGE_ONE = "pageOne";
    private IProject project;
    private SwaggerFileWizardPageOne firstPage;

    protected ImageDescriptor getDefaultPageImageDescriptor() {
        Bundle bundle = SwaggerUIPlugin.getDefault().getBundle();
        URL url = bundle.getEntry("icons/Swagger_Logo_Banner.gif");
        return ImageDescriptor.createFromURL((URL)url);
    }

    public boolean canFinish() {
        IProject selectedProj = this.firstPage.getProject();
        String openApiVersion = this.firstPage.getOpenApiVersion();
        if (selectedProj != null) {
            Object specFile = null;
            specFile = "2.0".equals(openApiVersion) ? new SwaggerFileHandler(selectedProj, this.firstPage.genTemplate(), this.firstPage.fileTypeIsJson(), !this.firstPage.genAsTopLevel()) : new OpenApiFileHandler(selectedProj, this.firstPage.genTemplate(), this.firstPage.fileTypeIsJson());
            if (specFile.getFile().exists()) {
                return false;
            }
        }
        return this.firstPage.isPageComplete();
    }

    public boolean performFinish() {
        IProject selectedProj = this.firstPage.getProject();
        String openApiVersion = this.firstPage.getOpenApiVersion();
        if (selectedProj != null) {
            OpenApiFileHandler specFile = null;
            if (openApiVersion.equals("2.0")) {
                specFile = new SwaggerFileHandler(selectedProj, this.firstPage.genTemplate(), this.firstPage.fileTypeIsJson(), !this.firstPage.genAsTopLevel());
            } else if (openApiVersion.equals("3.0")) {
                specFile = new OpenApiFileHandler(selectedProj, this.firstPage.genTemplate(), this.firstPage.fileTypeIsJson());
            } else {
                SwaggerUIPlugin.logError("Unexpected error: version is not one of 2.0 or 3.0");
                return false;
            }
            try {
                IFile sFile = specFile.getFile();
                if (specFile != null && !sFile.exists()) {
                    specFile.createSwaggerFile();
                    this.openInEditor(sFile);
                }
            }
            catch (Exception e) {
                SwaggerUIPlugin.logError(e);
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        this.setWindowTitle(SwaggerUIMessages.SwaggerFileDialogTitle);
        this.firstPage = new SwaggerFileWizardPageOne(PAGE_ONE);
        this.firstPage.setProject(this.project);
        this.addPage((IWizardPage)this.firstPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.project = SwaggerFileSelectionWizard.getProjectFromSelection((ISelection)selection);
        this.setDefaultPageImageDescriptor(this.getDefaultPageImageDescriptor());
    }

    private static IProject getProjectFromSelection(ISelection selection) {
        boolean validProject;
        Object firstElement;
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IProject project = ProjectUtilities.getProject((Object)structuredSelection.getFirstElement());
        if (project == null && (firstElement = structuredSelection.getFirstElement()) instanceof IResource) {
            project = ((IResource)firstElement).getProject();
        }
        if (!(validProject = ProjectUtils.isValidProject(project))) {
            project = null;
        }
        return project;
    }

    public void openInEditor(final IFile file) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = PlatformUI.getWorkbench().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        SwaggerUIPlugin.logError((CoreException)((Object)e));
                    }
                }
            });
        }
    }
}

