/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.util;

import com.ibm.etools.swagger.rest.api.ui.util.SwaggerActionPropertyTester;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;

public final class ProjectUtils {
    public static List<IProject> getAllValidProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : ProjectUtilities.getAllProjects()) {
            if (!ProjectUtils.isValidProject(project)) continue;
            result.add(project);
        }
        return result;
    }

    public static List<IProject> getAllValidLibertyProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : ProjectUtilities.getAllProjects()) {
            if (!ProjectUtils.isLibertyProject(project)) continue;
            result.add(project);
        }
        return result;
    }

    public static List<IProject> getAllValidTWasProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IProject project : ProjectUtilities.getAllProjects()) {
            if (!ProjectUtils.isTWasProject(project)) continue;
            result.add(project);
        }
        return result;
    }

    private static boolean hasMinimumWebModuleFacet(IProject project) {
        if (project != null) {
            String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)project);
            return JavaEEProjectUtilities.isDynamicWebProject((IProject)project) && version != null && version.compareTo("2.5") >= 0;
        }
        return false;
    }

    public static boolean isValidProject(IProject project) {
        if (project != null) {
            return ProjectUtils.hasMinimumWebModuleFacet(project) && ProjectUtils.isSpecificTargetedProject(project, RUNTIMES.BOTH);
        }
        return false;
    }

    public static boolean isLibertyProject(IProject project) {
        if (project != null) {
            return ProjectUtils.hasMinimumWebModuleFacet(project) && ProjectUtils.isSpecificTargetedProject(project, RUNTIMES.LIBERTY);
        }
        return false;
    }

    public static boolean isTWasProject(IProject project) {
        if (project != null) {
            return ProjectUtils.hasMinimumWebModuleFacet(project) && ProjectUtils.isSpecificTargetedProject(project, RUNTIMES.TWAS);
        }
        return false;
    }

    private static boolean isSpecificTargetedProject(IProject proj, RUNTIMES runtimeType) {
        block9: {
            try {
                IFacetedProject facetedProj = ProjectFacetsManager.create((IProject)proj);
                if (facetedProj != null) {
                    for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : facetedProj.getTargetedRuntimes()) {
                        String runtimeId;
                        IRuntimeType type;
                        IRuntime facetRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
                        if (facetRuntime == null || (type = facetRuntime.getRuntimeType()) == null || (runtimeId = type.getId()) == null) continue;
                        switch (runtimeType.ordinal()) {
                            case 0: {
                                if (!runtimeId.startsWith("com.ibm.ws.st.runtime")) break;
                                return true;
                            }
                            case 1: {
                                if (!SwaggerActionPropertyTester.isWASv90OrLaterRuntime(facetRuntime)) break;
                                return true;
                            }
                            case 2: {
                                if (!runtimeId.startsWith("com.ibm.ws.st.runtime") && !SwaggerActionPropertyTester.isWASv90OrLaterRuntime(facetRuntime)) break;
                                return true;
                            }
                        }
                    }
                    break block9;
                }
                return false;
            }
            catch (CoreException e) {
                return false;
            }
        }
        return false;
    }

    public static List<IJavaProject> getAvailableWebProjects(IProject initialProject) throws JavaModelException {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] javaProjects = model.getJavaProjects();
        ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
        int length = javaProjects.length;
        for (int i = 0; i < length; ++i) {
            boolean isWeb31Project;
            IProject proj;
            IJavaProject javaProject;
            block5: {
                javaProject = javaProjects[i];
                proj = javaProjects[i].getProject();
                if (proj == null || !proj.isAccessible()) continue;
                isWeb31Project = false;
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)proj);
                    if (facetedProject == null) break block5;
                    Set fixedProjectFacets = facetedProject.getProjectFacets();
                    for (IProjectFacetVersion facet : fixedProjectFacets) {
                        if (!"jst.web".equals(facet.getProjectFacet().getId()) || "3.1".compareTo(facet.getVersionString()) > 0) continue;
                        isWeb31Project = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isWeb31Project) continue;
            if (proj == initialProject) {
                list.add(0, javaProject);
                continue;
            }
            list.add(javaProject);
        }
        return list;
    }

    public static IJavaProject getJavaProject(IProject iProject) {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        return model.getJavaProject(iProject.getName());
    }

    public static List<String> getValidTargetPathForProject(IJavaProject javaProject) throws JavaModelException {
        ArrayList<String> validTargetPaths = new ArrayList<String>();
        if (javaProject.getProject().isAccessible() && J2EEUtils.isWebComponent((IProject)javaProject.getProject())) {
            ProjectUtils.addFragments(javaProject, validTargetPaths, null);
        }
        return validTargetPaths;
    }

    public static List<String> getAllValidTargetPaths(IProject initialProject) throws JavaModelException {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject[] javaProjects = model.getJavaProjects();
        ArrayList<String> validTargetPaths = new ArrayList<String>();
        for (int i = 0; i < javaProjects.length; ++i) {
            if (!javaProjects[i].getProject().isAccessible() || !J2EEUtils.isWebComponent((IProject)javaProjects[i].getProject())) continue;
            ProjectUtils.addFragments(javaProjects[i], validTargetPaths, initialProject);
        }
        return validTargetPaths;
    }

    private static void addFragments(IJavaProject javaProject, List<String> validTargetPaths, IProject firstProject) throws JavaModelException {
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
        for (int j = 0; j < packageFragmentRoots.length; ++j) {
            IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[j];
            IPath targetPath = packageFragmentRoot.getPath();
            if (packageFragmentRoot.getKind() != 1) continue;
            String targetPathString = targetPath.toString();
            boolean hasHiddenDirectories = false;
            for (int k = 0; k < targetPath.segmentCount(); ++k) {
                if (!targetPath.segment(k).startsWith(".")) continue;
                hasHiddenDirectories = true;
                break;
            }
            if (hasHiddenDirectories) continue;
            if (firstProject != null && javaProject.getProject() == firstProject) {
                validTargetPaths.add(0, targetPathString);
                continue;
            }
            validTargetPaths.add(targetPathString);
        }
    }

    private static enum RUNTIMES {
        LIBERTY,
        TWAS,
        BOTH;

    }
}

