/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.swagger.rest.api.ui.commands;

import com.ibm.etools.openapi.core.commands.CommandRunner;
import com.ibm.etools.swagger.rest.api.ui.SwaggerUILogger;
import com.ibm.etools.swagger.rest.api.ui.commands.AbstractSwaggerCodeGenCommand;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class SwaggerServiceCodeGenCommand
extends AbstractSwaggerCodeGenCommand {
    public SwaggerServiceCodeGenCommand() {
    }

    public SwaggerServiceCodeGenCommand(IDataModel model) {
        super(model);
    }

    @Override
    protected void populateArgsList(List<String> mainArgsList) {
        mainArgsList.add("-jar");
        mainArgsList.add(this.codegenJar);
        mainArgsList.add("generate");
        mainArgsList.add("-l");
        mainArgsList.add("jaxrs-spec");
        mainArgsList.add("-i");
        if (this.swaggerJsonFile != null) {
            mainArgsList.add(this.argSurround + this.swaggerJsonFile.getLocation().toOSString() + this.argSurround);
        } else if (this.externalFile != null) {
            mainArgsList.add(this.argSurround + this.externalFile.getAbsolutePath() + this.argSurround);
        } else if (this.urlOfJsonFile != null) {
            mainArgsList.add(this.urlOfJsonFile);
        }
        mainArgsList.add("-o");
        mainArgsList.add(this.argSurround + this.srcFolder.getLocation().toOSString() + this.argSurround);
        String apiPackage = this.targetPackage.equals("") ? "io.swagger.api" : this.targetPackage + ".api";
        String modelPackage = this.targetPackage.equals("") ? "io.swagger.model" : this.targetPackage + ".model";
        mainArgsList.add("-DapiPackage=" + apiPackage + ",modelPackage=" + modelPackage + ",invokerPackage=" + this.targetPackage + ",sourceFolder=.");
        if (SwaggerUILogger.INFO) {
            int i;
            int length = mainArgsList.size();
            for (i = 0; i < length; ++i) {
                SwaggerUILogger.println("/debug/info", "SwaggerServiceCodeGen", "execute", mainArgsList.get(i));
            }
            System.out.println("-------------------------------");
            for (i = 0; i < length; ++i) {
                System.out.print(mainArgsList.get(i) + " ");
            }
            System.out.println("\n-------------------------------");
        }
    }

    @Override
    protected CommandRunner getCommandRunner(List<String> mainArgsList) {
        return new CommandRunner(mainArgsList, "SwaggerServiceCodeGen");
    }

    @Override
    protected void doPreExecuteSetup() {
    }

    @Override
    protected void deleteUnneededArtifacts() throws CoreException {
        this.targetFolder.refreshLocal(2, null);
        this.deleteFile(this.targetFolder, "LICENSE", null);
        this.deleteFile(this.targetFolder, "pom.xml", null);
        this.deleteFile(this.targetFolder, ".swagger-codegen-ignore", null);
        if (!this.srcMainFolderExists) {
            this.deleteFolder(this.targetFolder, "src/main", null);
        }
        if (!this.srcFolderExists) {
            this.deleteFolder(this.targetFolder, "src", null);
        }
        this.targetFolder.refreshLocal(2, null);
    }
}

