/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.javaee.ui.validation;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPreferences;
import com.ibm.etools.maven.javaee.ui.JavaEEUIPlugin;
import com.ibm.etools.maven.javaee.ui.preferences.MavenDefaultSettings;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidationMessages;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidationUtility;
import com.ibm.etools.maven.javaee.ui.validation.MavenValidator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPreferences;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferences;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.ValidatorMessage;
import org.osgi.framework.Bundle;

public class MavenProjectSettingsValidator
extends MavenValidator
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String TYPE = "com.ibm.etools.maven.javaee.ui.MavenProjectSettingsValidatorMarker";
    private static final String[] j2eeProperties = new String[]{"earContent", "dynWebOutput", "dynWebSource", "webContent", "ejbOutput", "ejbContent", "appClientContent", "appClientOutput", "jcaContent", "jcaOutput"};
    private static final String[] j2eeFacetCoreProperties = new String[]{"defaultSource", "outputFolder"};
    private static final String[] j2eeUIProperties = new String[]{"org.eclipse.jst.j2ee.preferences.useEARLibraries", "org.eclipse.jst.j2ee.preferences.useWebAppLibraries"};
    private static final String[] mavenProperties = new String[]{"org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", "org.eclipse.m2e.wtp.war.archiverFilesInBuilDir"};

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this.result = new ValidationResult();
        this.project = resource.getProject();
        if (this.supportedJavaEEMavenFacetInstalled(this.project)) {
            Bundle m2eBundle = Platform.getBundle((String)"org.eclipse.m2e.core");
            Bundle m2ewtpBundle = Platform.getBundle((String)"org.eclipse.m2e.wtp");
            if (m2eBundle != null && m2ewtpBundle != null && MavenValidationUtility.isActive(m2eBundle) && MavenValidationUtility.isActive(m2eBundle) && !JavaEEUIPlugin.getDefault().getPreferences().getBoolean("DISABLE_MAVEN_WORKSPACE_VALIDATION_PREFERENCE", false)) {
                this.initializeContext();
                this.context.setResult(this.result);
                this.context.setMarkerType(TYPE);
                this.validateProjectSettings();
            }
        }
        return this.result;
    }

    private boolean supportedJavaEEMavenFacetInstalled(IProject project) {
        if (project == null) {
            return false;
        }
        String[] facets = new String[]{"jst.web", "jst.ejb", "jst.utility", "jst.appclient", "jst.connector", "osgi.bundle"};
        try {
            IFacetedProject factedProject = ProjectFacetsManager.create((IProject)project);
            if (factedProject != null) {
                Set installedFacets = factedProject.getProjectFacets();
                for (IProjectFacetVersion facet : installedFacets) {
                    for (int i = 0; i < facets.length; ++i) {
                        String string = facets[i];
                        if (!facet.getProjectFacet().getId().equals(string)) continue;
                        return true;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private void validateProjectSettings() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (!this.hasStandardProjectSettings()) {
            if (!MavenValidationUtility.hasMarker((IResource)root, this.context.getMarkerType())) {
                ValidatorMessage msg = MavenValidationUtility.createWarningMessage(MavenValidationMessages.MAVEN_STANDARD_PROJECT_SETTINGS_NOT_SET, (IResource)root, this.context.getMarkerType(), MavenValidationMessages.WORKSPACE);
                this.context.getResult().add(msg);
            }
        } else if (MavenValidationUtility.hasMarker((IResource)root, this.context.getMarkerType())) {
            MavenValidationUtility.clearMessages((IResource)root, TYPE);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceEvent) {
        IWorkspaceRoot root;
        Bundle m2eBundle = Platform.getBundle((String)"org.eclipse.m2e.core");
        Bundle m2ewtpBundle = Platform.getBundle((String)"org.eclipse.m2e.wtp");
        if (m2eBundle != null && m2ewtpBundle != null && MavenValidationUtility.isActive(m2eBundle) && MavenValidationUtility.isActive(m2eBundle) && this.hasMavenProjects(root = ResourcesPlugin.getWorkspace().getRoot()) && this.isMavenProperty(preferenceEvent) && !JavaEEUIPlugin.getDefault().getPreferences().getBoolean("DISABLE_MAVEN_WORKSPACE_VALIDATION_PREFERENCE", false)) {
            if (!this.isStandardSetting(preferenceEvent)) {
                if (!MavenValidationUtility.hasMarker((IResource)root, TYPE)) {
                    try {
                        IMarker marker = root.createMarker(TYPE);
                        marker.setAttribute("message", (Object)MavenValidationMessages.MAVEN_STANDARD_PROJECT_SETTINGS_NOT_SET);
                        marker.setAttribute("severity", 1);
                        marker.setAttribute("transient", false);
                        marker.setAttribute("location", (Object)MavenValidationMessages.WORKSPACE);
                    }
                    catch (CoreException e) {
                        JavaEEUIPlugin.logError(e);
                    }
                }
            } else {
                MavenValidationUtility.clearMessages((IResource)root, TYPE);
            }
        }
    }

    private boolean isMavenProperty(IEclipsePreferences.PreferenceChangeEvent preferenceEvent) {
        if (Arrays.asList(j2eeProperties).contains(preferenceEvent.getKey())) {
            return true;
        }
        if (Arrays.asList(j2eeFacetCoreProperties).contains(preferenceEvent.getKey())) {
            return true;
        }
        if (Arrays.asList(j2eeUIProperties).contains(preferenceEvent.getKey())) {
            return true;
        }
        return Arrays.asList(mavenProperties).contains(preferenceEvent.getKey());
    }

    private boolean hasStandardProjectSettings() {
        Map<String, String> j2eeStandardPreferences = this.getStandardJ2EEPreferences();
        Map<String, String> j2eePreferences = this.getCurrentJ2EEPreferences();
        Map<String, String> j2eeStandardFacetPreferences = this.getStandardJ2EEFacetCorePreferences();
        Map<String, String> j2eeFacetCorePreferences = this.getCurrentJ2EEFacetCorePreferences();
        Map<String, Boolean> j2eeUIStandardPreferences = this.getStandardJ2EEUIPreferences();
        Map<String, Boolean> j2eeUIPreferences = this.getCurrentJ2EEUIPreferences();
        Map<String, Boolean> mavenStandardPreferences = this.getStandardMavenPreferences();
        Map<String, Boolean> mavenPreferences = this.getCurrentMavenPreferences();
        for (String preference : j2eeStandardPreferences.keySet()) {
            if (j2eePreferences.get(preference).equals(j2eeStandardPreferences.get(preference))) continue;
            return false;
        }
        for (String preference : j2eeStandardFacetPreferences.keySet()) {
            if (j2eeFacetCorePreferences.get(preference).equals(j2eeStandardFacetPreferences.get(preference))) continue;
            return false;
        }
        for (String preference : j2eeUIStandardPreferences.keySet()) {
            if (!(j2eeUIPreferences.get(preference) ^ j2eeUIStandardPreferences.get(preference))) continue;
            return false;
        }
        for (String preference : mavenStandardPreferences.keySet()) {
            if (!(mavenPreferences.get(preference) ^ mavenStandardPreferences.get(preference))) continue;
            return false;
        }
        return true;
    }

    private boolean isStandardSetting(IEclipsePreferences.PreferenceChangeEvent preferenceEvent) {
        if (preferenceEvent != null) {
            if (this.getStandardJ2EEPreferences().keySet().contains(preferenceEvent.getKey())) {
                System.out.println(this.getStandardJ2EEPreferences().get(preferenceEvent.getKey()));
                System.out.println((String)preferenceEvent.getNewValue());
                if (!this.getStandardJ2EEPreferences().get(preferenceEvent.getKey()).equals((String)preferenceEvent.getNewValue())) {
                    return false;
                }
            }
            if (this.getStandardJ2EEFacetCorePreferences().keySet().contains(preferenceEvent.getKey())) {
                System.out.println(this.getStandardJ2EEFacetCorePreferences().get(preferenceEvent.getKey()));
                System.out.println((String)preferenceEvent.getNewValue());
                if (!this.getStandardJ2EEFacetCorePreferences().get(preferenceEvent.getKey()).equals((String)preferenceEvent.getNewValue())) {
                    return false;
                }
            }
            if (this.getStandardJ2EEUIPreferences().keySet().contains(preferenceEvent.getKey())) {
                System.out.println(this.getStandardJ2EEUIPreferences().get(preferenceEvent.getKey()));
                System.out.println((String)preferenceEvent.getNewValue());
                if (this.getStandardJ2EEUIPreferences().get(preferenceEvent.getKey()) ^ new Boolean((String)preferenceEvent.getNewValue())) {
                    return false;
                }
            }
            if (this.getStandardMavenPreferences().keySet().contains(preferenceEvent.getKey())) {
                System.out.println(this.getStandardMavenPreferences().get(preferenceEvent.getKey()));
                System.out.println((String)preferenceEvent.getNewValue());
                if (this.getStandardMavenPreferences().get(preferenceEvent.getKey()) ^ new Boolean((String)preferenceEvent.getNewValue())) {
                    return false;
                }
            }
        }
        return true;
    }

    private Map<String, String> getStandardJ2EEPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("earContent", MavenDefaultSettings.MavenDefaultSettings0);
        preferences.put("dynWebOutput", MavenDefaultSettings.MavenDefaultSettings3);
        preferences.put("dynWebSource", MavenDefaultSettings.MavenDefaultSettings4);
        preferences.put("webContent", MavenDefaultSettings.MavenDefaultSettings1);
        preferences.put("ejbOutput", MavenDefaultSettings.MavenDefaultSettings3);
        preferences.put("ejbContent", MavenDefaultSettings.MavenDefaultSettings4);
        preferences.put("appClientContent", MavenDefaultSettings.MavenDefaultSettings4);
        preferences.put("appClientOutput", MavenDefaultSettings.MavenDefaultSettings3);
        preferences.put("jcaOutput", MavenDefaultSettings.MavenDefaultSettings3);
        preferences.put("jcaContent", MavenDefaultSettings.MavenDefaultSettings6);
        return preferences;
    }

    private Map<String, String> getCurrentJ2EEPreferences() {
        J2EEPreferences j2eePreferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        HashMap<String, String> preferences = new HashMap<String, String>();
        for (String preference : j2eeProperties) {
            preferences.put(preference, j2eePreferences.getString(preference));
        }
        return preferences;
    }

    private Map<String, String> getStandardJ2EEFacetCorePreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("defaultSource", MavenDefaultSettings.MavenDefaultSettings4);
        preferences.put("outputFolder", MavenDefaultSettings.MavenDefaultSettings3);
        return preferences;
    }

    private Map<String, String> getCurrentJ2EEFacetCorePreferences() {
        J2EEPreferences j2eePreferences = J2EEPlugin.getDefault().getJ2EEPreferences();
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("defaultSource", FacetCorePlugin.getJavaSrcFolder());
        preferences.put("outputFolder", j2eePreferences.getUtilityOutputFolderName());
        return preferences;
    }

    private Map<String, Boolean> getStandardJ2EEUIPreferences() {
        HashMap<String, Boolean> preferences = new HashMap<String, Boolean>();
        preferences.put("org.eclipse.jst.j2ee.preferences.useEARLibraries", new Boolean(false));
        preferences.put("org.eclipse.jst.j2ee.preferences.useWebAppLibraries", new Boolean(false));
        return preferences;
    }

    private Map<String, Boolean> getCurrentJ2EEUIPreferences() {
        J2EEUIPreferences j2eePreferencesUI = J2EEUIPlugin.getDefault().getJ2EEUIPreferences();
        HashMap<String, Boolean> preferences = new HashMap<String, Boolean>();
        preferences.put("org.eclipse.jst.j2ee.preferences.useEARLibraries", new Boolean(j2eePreferencesUI.getUseEARLibraries()));
        preferences.put("org.eclipse.jst.j2ee.preferences.useWebAppLibraries", new Boolean(j2eePreferencesUI.getUseWebLibaries()));
        return preferences;
    }

    private Map<String, Boolean> getStandardMavenPreferences() {
        HashMap<String, Boolean> preferences = new HashMap<String, Boolean>();
        preferences.put("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", new Boolean(false));
        preferences.put("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", new Boolean(false));
        return preferences;
    }

    private Map<String, Boolean> getCurrentMavenPreferences() {
        IMavenWtpPreferences mavenWTPPreferences = MavenWtpPlugin.getDefault().getMavenWtpPreferencesManager().getWorkspacePreferences();
        HashMap<String, Boolean> preferences = new HashMap<String, Boolean>();
        preferences.put("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", new Boolean(mavenWTPPreferences.isApplicationXmGeneratedInBuildDirectory()));
        preferences.put("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", new Boolean(mavenWTPPreferences.isWebMavenArchiverUsesBuildDirectory()));
        return preferences;
    }

    private boolean hasMavenProjects(IWorkspaceRoot root) {
        try {
            for (IProject project : root.getProjects()) {
                if (!project.hasNature("org.eclipse.m2e.core.maven2Nature")) continue;
                return true;
            }
        }
        catch (CoreException e) {
            JavaEEUIPlugin.logError(e);
            return false;
        }
        return false;
    }
}

