/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.javaee.ui.preferences;

import com.ibm.etools.maven.javaee.ui.JavaEEUIPlugin;
import com.ibm.etools.maven.javaee.ui.preferences.MavenPreferencePageMessages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class MavenRepositoryInitializationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Text userSettingsText;
    private static Label mavenPageDesc;
    private static Button intializeSettings;
    private static final String MAVEN_USER_PREFERENCE_PAGE_ID = "org.eclipse.m2e.core.preferences.MavenSettingsPreferencePage";
    private static final String SETTINGS_XML_FILE = "settings.xml";
    private IMavenConfiguration mc = MavenPlugin.getMavenConfiguration();
    public static final String MAVEN_INITIALIZE_SETTINGS = "MAVEN_INITIALIZE_SETTINGS";
    public static final String IBM_MAVEN_REPOSITORY_URL = "https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/maven/repository/";
    public static final String IBM_MAVEN_REPOSITORY_ID = "ibm-maven-repo";
    public static final String IBM_MAVEN_PROFILE_ID = "standard-extra-repos";

    public Control getControl() {
        Control control = super.getControl();
        if (control != null) {
            mavenPageDesc.setSize(mavenPageDesc.computeSize(-1, -1));
            String usf = this.mc.getUserSettingsFile() != null ? this.mc.getUserSettingsFile().trim() : SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
            userSettingsText.setText(usf);
            File file = new File(usf);
            if (file.getPath().indexOf(SETTINGS_XML_FILE) == -1) {
                mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Invalid_Settings_File);
                intializeSettings.setEnabled(false);
            } else if (!file.exists()) {
                mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_1);
                intializeSettings.setEnabled(true);
            } else if (!this.isIBMRepositoryInitialized()) {
                mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_2);
                intializeSettings.setEnabled(true);
            } else {
                mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_3);
                intializeSettings.setEnabled(false);
            }
        }
        return control;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
        this.getApplyButton().setVisible(false);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 0x1000000, true, false, 4, 1);
        mavenPageDesc = new Label(composite, 0);
        this.createUserSettings(composite);
        String usf = this.mc.getUserSettingsFile() != null ? this.mc.getUserSettingsFile().trim() : SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        userSettingsText.setText(usf);
        File file = new File(usf);
        if (file.getPath().indexOf(SETTINGS_XML_FILE) == -1) {
            mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Invalid_Settings_File);
            intializeSettings.setEnabled(false);
        } else if (!file.exists()) {
            mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_1);
            intializeSettings.setEnabled(true);
        } else if (!this.isIBMRepositoryInitialized()) {
            mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_2);
            intializeSettings.setEnabled(true);
        } else {
            mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_3);
            intializeSettings.setEnabled(false);
        }
        mavenPageDesc.setLayoutData((Object)gd);
        return composite;
    }

    private void createUserSettings(Composite composite) {
        PreferenceLinkArea userSettingsFileLabel = new PreferenceLinkArea(composite, 0, MAVEN_USER_PREFERENCE_PAGE_ID, MavenPreferencePageMessages.Maven_User_Settings_File_Link, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData gd_userSettingsLabel = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_userSettingsLabel.verticalIndent = 15;
        userSettingsFileLabel.getControl().setLayoutData((Object)gd_userSettingsLabel);
        userSettingsText = new Text(composite, 2048);
        userSettingsText.setData("name", (Object)"userSettingsText");
        GridData gd_userSettingsText = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_userSettingsText.verticalIndent = 5;
        gd_userSettingsText.widthHint = 100;
        userSettingsText.setLayoutData((Object)gd_userSettingsText);
        userSettingsText.setEnabled(false);
        GridData gd = new GridData(4, 131072, false, false, 1, 1);
        intializeSettings = new Button(composite, 0);
        intializeSettings.setText(MavenPreferencePageMessages.Configure);
        intializeSettings.setLayoutData((Object)gd);
        intializeSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MavenRepositoryInitializationPreferencePage.this.initializeMavenRepository()) {
                    mavenPageDesc.setText(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Description_3);
                    intializeSettings.setEnabled(false);
                } else {
                    MavenRepositoryInitializationPreferencePage.this.setMessage(MavenPreferencePageMessages.Maven_Repository_Initialization_Page_Initialize_error, 2);
                }
            }
        });
    }

    public void init(IWorkbench arg0) {
    }

    private boolean initializeMavenRepository() {
        String usf = this.mc.getUserSettingsFile() != null ? this.mc.getUserSettingsFile().trim() : SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        File file = new File(usf);
        IMaven mav = MavenPlugin.getMaven();
        try {
            Settings settings;
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                SettingsXpp3Reader reader = new SettingsXpp3Reader();
                settings = reader.read((InputStream)fis);
                fis.close();
            } else {
                String absPath = file.getAbsolutePath();
                String dirPath = absPath.substring(0, absPath.indexOf(SETTINGS_XML_FILE));
                File dir = new File(dirPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                settings = mav.getSettings();
            }
            Repository repos = new Repository();
            repos.setId(IBM_MAVEN_REPOSITORY_ID);
            repos.setName(IBM_MAVEN_REPOSITORY_ID);
            repos.setUrl(IBM_MAVEN_REPOSITORY_URL);
            repos.setLayout("default");
            RepositoryPolicy releases = new RepositoryPolicy();
            releases.setEnabled(true);
            releases.setUpdatePolicy("never");
            repos.setReleases(releases);
            RepositoryPolicy snapshot = new RepositoryPolicy();
            snapshot.setEnabled(false);
            snapshot.setUpdatePolicy("never");
            repos.setSnapshots(snapshot);
            Profile profile = new Profile();
            profile.setId(IBM_MAVEN_PROFILE_ID);
            Activation activation = new Activation();
            activation.setActiveByDefault(true);
            profile.setActivation(activation);
            profile.addRepository(repos);
            profile.addPluginRepository(repos);
            settings.getProfiles().add(profile);
            settings.getActiveProfiles().add(IBM_MAVEN_PROFILE_ID);
            SettingsXpp3Writer writer = new SettingsXpp3Writer();
            FileOutputStream fos = new FileOutputStream(file);
            writer.write((OutputStream)fos, settings);
            fos.close();
            mav.reloadSettings();
            return true;
        }
        catch (Exception e) {
            JavaEEUIPlugin.logError(e);
            return false;
        }
    }

    private boolean isIBMRepositoryInitialized() {
        String usf = this.mc.getUserSettingsFile() != null ? this.mc.getUserSettingsFile().trim() : SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE.getAbsolutePath();
        File file = new File(usf);
        try {
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                SettingsXpp3Reader reader = new SettingsXpp3Reader();
                Settings settings = reader.read((InputStream)fis);
                fis.close();
                Profile prof = (Profile)settings.getProfilesAsMap().get(IBM_MAVEN_PROFILE_ID);
                if (prof != null) {
                    Iterator repoIt = prof.getRepositories().iterator();
                    while (repoIt.hasNext()) {
                        if (!IBM_MAVEN_REPOSITORY_URL.equals(((Repository)repoIt.next()).getUrl().trim())) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            JavaEEUIPlugin.logError(e);
        }
        return false;
    }
}

